/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class SpaceAccessHandler
extends WebRequestHandler {
    private static final String SPACES_GROUP_PREFIX = "/spaces/";
    private static final String LAST_PORTAL_NAME = "prc.lastPortalName";
    public static final String PAGE_URI = "space-access";
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private IdentityRegistry identityRegistry;
    private URLFactoryService urlFactoryService;
    private UserPortalConfigService userPortalConfigService;

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        super.onInit(controller, sConfig);
        PortalContainer container = PortalContainer.getInstance();
        this.spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        this.identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        this.urlFactoryService = (URLFactoryService)container.getComponentInstanceOfType(URLFactoryService.class);
        this.userPortalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
    }

    public String getHandlerName() {
        return PAGE_URI;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        String remoteId = controllerContext.getRequest().getRemoteUser();
        String requestSiteType = controllerContext.getParameter(PortalRequestHandler.REQUEST_SITE_TYPE);
        String requestSiteName = controllerContext.getParameter(PortalRequestHandler.REQUEST_SITE_NAME);
        if (StringUtils.isNotBlank((CharSequence)remoteId) && SiteType.GROUP.name().equalsIgnoreCase(requestSiteType) && requestSiteName.startsWith(SPACES_GROUP_PREFIX)) {
            Space space = this.spaceService.getSpaceByGroupId(requestSiteName);
            if (space != null && this.canAccessSpace(remoteId, space)) {
                HttpSession session = controllerContext.getRequest().getSession();
                String lastAccessedSpaceId = (String)session.getAttribute("social.accessed.space.id.key");
                if (!StringUtils.equals((CharSequence)lastAccessedSpaceId, (CharSequence)space.getId())) {
                    this.spaceService.updateSpaceAccessed(remoteId, space);
                }
                this.cleanupSession(controllerContext);
                session.setAttribute("social.accessed.space.id.key", (Object)space.getId());
            } else {
                this.processSpaceAccess(controllerContext, remoteId, space);
                return true;
            }
        }
        return false;
    }

    private boolean canAccessSpace(String remoteId, Space space) {
        boolean canAccessSpace;
        Identity identity = this.identityRegistry.getIdentity(remoteId);
        if (identity == null) {
            return false;
        }
        Collection memberships = identity.getMemberships();
        boolean isSuperManager = this.spaceService.isSuperManager(remoteId);
        boolean isManager = this.spaceService.isManager(space, remoteId);
        boolean isMember = this.spaceService.isMember(space, remoteId);
        MembershipEntry memberMembership = new MembershipEntry(space.getGroupId(), "member");
        boolean bl = canAccessSpace = isMember || isManager || isSuperManager;
        if (canAccessSpace) {
            memberships.add(memberMembership);
        } else {
            memberships.remove(memberMembership);
        }
        MembershipEntry managerMembership = new MembershipEntry(space.getGroupId(), "manager");
        if (isManager || isSuperManager) {
            memberships.add(managerMembership);
        } else {
            memberships.remove(managerMembership);
        }
        return canAccessSpace;
    }

    private void processSpaceAccess(ControllerContext controllerContext, String remoteId, Space space) throws IOException {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(remoteId);
        if (identity.isExternal() && (space == null || !this.spaceService.isInvitedUser(space, remoteId))) {
            controllerContext.getResponse().sendRedirect("/");
            return;
        }
        SpaceAccessType spaceAccessType = Arrays.stream(SpaceAccessType.values()).filter(accessType -> accessType.doCheck(remoteId, space)).findFirst().orElse(null);
        this.sendRedirect(controllerContext, spaceAccessType, space);
    }

    private void sendRedirect(ControllerContext controllerContext, SpaceAccessType type, Space space) throws IOException {
        HttpServletRequest request = controllerContext.getRequest();
        HttpSession session = request.getSession();
        session.setAttribute("social.accessed.space.type.key", (Object)type);
        if (space == null) {
            session.removeAttribute("social.accessed.space.prettyName.key");
            session.removeAttribute("social.accessed.space.displayName.key");
        } else {
            session.setAttribute("social.accessed.space.id.key", (Object)space.getId());
            session.setAttribute("social.accessed.space.prettyName.key", (Object)space.getDisplayName());
            session.setAttribute("social.accessed.space.displayName.key", (Object)space.getPrettyName());
            session.setAttribute("social.accessed.space.request.path.key", (Object)request.getRequestURI());
        }
        controllerContext.getResponse().sendRedirect(this.getURI(controllerContext, PAGE_URI));
    }

    private void cleanupSession(ControllerContext controllerContext) {
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.type.key");
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.id.key");
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.prettyName.key");
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.request.path.key");
    }

    private void removeAttributeFromSession(ControllerContext controllerContext, String key) {
        if (controllerContext.getRequest().getAttribute(key) != null) {
            controllerContext.getRequest().getSession().removeAttribute(key);
        }
    }

    private String getURI(ControllerContext controllerContext, String uri) {
        String portalName = (String)controllerContext.getRequest().getSession().getAttribute(LAST_PORTAL_NAME);
        if (StringUtils.isBlank((CharSequence)portalName)) {
            portalName = this.userPortalConfigService.getMetaPortal();
        }
        SiteKey siteKey = SiteKey.portal((String)portalName);
        NavigationResource resource = new NavigationResource(siteKey.getType(), siteKey.getName(), uri);
        NodeURL url = (NodeURL)this.urlFactoryService.newURL(NodeURL.TYPE, (URLContext)new PortalURLContext(controllerContext, siteKey));
        url.setAjax(Boolean.valueOf(false));
        url.setResource(resource);
        return url.toString();
    }
}

