/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.impl.SpaceBean;
import org.exoplatform.wiki.service.listener.AttachmentWikiListener;
import org.exoplatform.wiki.service.listener.PageWikiListener;

public interface WikiService {
    public WikiPageParams getWikiPageParams(BreadcrumbData var1) throws WikiException;

    public List<PermissionEntry> getWikiPermission(String var1, String var2) throws WikiException;

    public void updateWikiPermission(String var1, String var2, List<PermissionEntry> var3) throws WikiException;

    public Page getPageOfWikiByName(String var1, String var2, String var3) throws WikiException;

    public String getDefaultWikiSyntaxId();

    public List<Attachment> getAttachmentsOfPage(Page var1) throws WikiException;

    default public List<Attachment> getAttachmentsOfPage(Page page, boolean loadContent) throws WikiException {
        return this.getAttachmentsOfPage(page);
    }

    public int getNbOfAttachmentsOfPage(Page var1) throws WikiException;

    public Attachment getAttachmentOfPageByName(String var1, Page var2) throws WikiException;

    default public Attachment getAttachmentOfPageByName(String attachmentName, Page page, boolean loadContent) throws WikiException {
        return this.getAttachmentOfPageByName(attachmentName, page);
    }

    public void addAttachmentToPage(Attachment var1, Page var2) throws WikiException;

    public void deleteAttachmentOfPage(String var1, Page var2) throws WikiException;

    public List<PermissionEntry> getWikiDefaultPermissions(String var1, String var2) throws WikiException;

    public void addComponentPlugin(ComponentPlugin var1);

    public List<PageWikiListener> getPageListeners();

    public List<AttachmentWikiListener> getAttachmentListeners();

    public Wiki getOrCreateUserWiki(String var1) throws WikiException;

    public String getSpaceNameByGroupId(String var1);

    public List<SpaceBean> searchSpaces(String var1) throws WikiException;

    public Wiki getWikiByTypeAndOwner(String var1, String var2) throws WikiException;

    public List<Wiki> getWikisByType(String var1) throws WikiException;

    public Wiki createWiki(String var1, String var2) throws WikiException;

    public String getWikiWebappUri();

    public boolean hasPermissionOnWiki(Wiki var1, PermissionType var2, Identity var3) throws WikiException;

    public boolean hasAdminSpacePermission(String var1, String var2) throws WikiException;

    public boolean hasAdminPagePermission(String var1, String var2) throws WikiException;

    public Wiki getWikiById(String var1) throws WikiException;

    public String getWikiNameById(String var1) throws WikiException;
}

