/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintWriter;
import java.util.UUID;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangelogRewriter;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.model.HubChangeLog;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;

public class DeactivateChangelogCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"deactivateChangelog"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Throwable throwable = null;
        try (PrintWriter output = new PrintWriter(resultsBuilder.getOutputStream());){
            String changeLogId;
            HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
            if (!hubServiceFactory.isOnline()) {
                throw new CommandExecutionException("The command deactivateChangeLog requires communication with Liquibase Hub, \nwhich is prevented by liquibase.hub.mode='off'. \nPlease set to 'all' or 'meta' and try again. \nLearn more at https://hub.liquibase.com");
            }
            String changeLogFile = commandScope.getArgumentValue(CHANGELOG_FILE_ARG);
            DatabaseChangeLog databaseChangeLog = this.parseChangeLogFile(changeLogFile);
            String string = changeLogId = databaseChangeLog != null ? databaseChangeLog.getChangeLogId() : null;
            if (changeLogId == null) {
                throw new CommandExecutionException("Changelog '" + changeLogFile + "' does not have a changelog ID and is not registered with Hub.\nFor more information visit https://docs.liquibase.com.");
            }
            HubService service = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
            HubChangeLog hubChangeLog = service.getHubChangeLog(UUID.fromString(changeLogId));
            if (hubChangeLog == null) {
                String message = "WARNING: Changelog '" + changeLogFile + "' has a changelog ID but was not found in Hub.\nThe changelog ID will be removed from the file, but Hub will not be updated.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                Scope.getCurrentScope().getLog(DeactivateChangelogCommandStep.class).warning(message);
            } else {
                hubChangeLog.setStatus("INACTIVE");
                hubChangeLog = service.deactivateChangeLog(hubChangeLog);
            }
            ChangelogRewriter.ChangeLogRewriterResult rewriterResult = ChangelogRewriter.removeChangeLogId(changeLogFile, changeLogId, databaseChangeLog);
            String message = null;
            if (rewriterResult.success) {
                message = "The changelog '" + changeLogFile + "' was deactivated.\nNote: If this is a shared changelog, please check it into Source Control.\nOperation data sent to the now inactive changelogID will still be accepted at Hub.\nFor more information visit https://docs.liquibase.com.\n";
                Scope.getCurrentScope().getLog(DeactivateChangelogCommandStep.class).info(message);
                output.println(message);
                resultsBuilder.addResult("statusCode", (Object)0);
                return;
            }
            try {
                throw new CommandExecutionException(rewriterResult.message);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private DatabaseChangeLog parseChangeLogFile(String changeLogFile) throws LiquibaseException {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(changeLogFile, resourceAccessor);
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        return parser.parse(changeLogFile, changeLogParameters, resourceAccessor);
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription("Removes the changelogID from your changelog so it stops sending reports to Liquibase Hub");
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = builder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().description("The root changelog").build();
    }
}

