/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.cache;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.UserProfileDAOImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;

public class CacheableUserProfileHandlerImpl
extends UserProfileDAOImpl {
    private UserProfile NULL_OBJECT = this.createUserProfileInstance();
    private final ThreadLocal<Boolean> disableCacheInThread = new ThreadLocal();
    private final ExoCache<String, UserProfile> userProfileCache;
    private final FutureExoCache<String, UserProfile, UserProfileCacheOperationType> futureUserProfile;

    public CacheableUserProfileHandlerImpl(OrganizationCacheHandler organizationCacheHandler, PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        super(orgService, service);
        this.userProfileCache = organizationCacheHandler.getUserProfileCache();
        this.futureUserProfile = new FutureExoCache((Loader)new Loader<String, UserProfile, UserProfileCacheOperationType>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public UserProfile retrieve(UserProfileCacheOperationType context, String key) throws Exception {
                CacheableUserProfileHandlerImpl.this.disableCacheInThread.set(true);
                try {
                    UserProfile userProfile = null;
                    switch (context) {
                        case PROFILE_BY_USERNAME_NO_NULL: {
                            userProfile = CacheableUserProfileHandlerImpl.this.findUserProfileByName(key);
                            break;
                        }
                        case PROFILE_BY_USERNAME: {
                            userProfile = CacheableUserProfileHandlerImpl.this.getProfile(key);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unrecognized context value " + String.valueOf((Object)context));
                        }
                    }
                    UserProfile userProfile2 = userProfile == null || userProfile.getUserInfoMap() == null || userProfile.getUserInfoMap().isEmpty() ? CacheableUserProfileHandlerImpl.this.NULL_OBJECT : userProfile;
                    return userProfile2;
                }
                finally {
                    CacheableUserProfileHandlerImpl.this.disableCacheInThread.set(false);
                }
            }
        }, this.userProfileCache);
    }

    @Override
    public UserProfile findUserProfileByName(String userName) throws Exception {
        UserProfile userProfile = null;
        if (this.disableCacheInThread.get() != null && this.disableCacheInThread.get().booleanValue()) {
            return super.findUserProfileByName(userName);
        }
        userProfile = (UserProfile)this.futureUserProfile.get((Object)UserProfileCacheOperationType.PROFILE_BY_USERNAME_NO_NULL, (Object)userName);
        if (userProfile == null || userProfile == this.NULL_OBJECT || StringUtils.isBlank((String)userProfile.getUserName()) || userProfile.getUserInfoMap() == null || userProfile.getUserInfoMap().isEmpty()) {
            userProfile = null;
        }
        return userProfile == null ? null : ((UserProfileImpl)userProfile).clone();
    }

    @Override
    public UserProfile getProfile(String userName) {
        UserProfile userProfile = null;
        userProfile = this.disableCacheInThread.get() == null || this.disableCacheInThread.get() == false ? (UserProfile)this.futureUserProfile.get((Object)UserProfileCacheOperationType.PROFILE_BY_USERNAME, (Object)userName) : super.getProfile(userName);
        if (userProfile == null || userProfile == this.NULL_OBJECT || StringUtils.isBlank((String)userProfile.getUserName()) || userProfile.getUserInfoMap() == null || userProfile.getUserInfoMap().isEmpty()) {
            userProfile = null;
        }
        return userProfile == null ? null : ((UserProfileImpl)userProfile).clone();
    }

    @Override
    public Collection findUserProfiles() throws Exception {
        return super.findUserProfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        UserProfile userProfile = null;
        try {
            userProfile = super.removeUserProfile(userName, broadcast);
            this.userProfileCache.remove((Serializable)((Object)userName));
            UserProfile userProfile2 = userProfile;
            return userProfile2;
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    @Override
    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            super.saveUserProfile(profile, broadcast);
            this.userProfileCache.remove((Serializable)((Object)profile.getUserName()));
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    public void clearCache() {
        this.userProfileCache.clearCache();
    }

    public void disableCache() {
        this.disableCacheInThread.set(true);
    }

    public void enableCache() {
        this.disableCacheInThread.set(null);
    }

    public static enum UserProfileCacheOperationType {
        PROFILE_BY_USERNAME_NO_NULL,
        PROFILE_BY_USERNAME;

    }
}

