/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class EditCommentPlugin
extends BaseNotificationPlugin {
    public static final String ID = "EditCommentPlugin";
    protected boolean isSubComment = false;

    public EditCommentPlugin(InitParams initParams) {
        super(initParams);
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        String spaceId = activity.getSpaceId();
        HashSet<String> receivers = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)comment.getParentCommentId())) {
            ExoSocialActivity parentComment = Utils.getActivityManager().getActivity(comment.getParentCommentId());
            String parentCommentUserPosterId = Utils.getUserId(parentComment.getPosterId());
            if (this.isSubComment) {
                Utils.sendToActivityPoster(receivers, parentComment.getPosterId(), comment.getPosterId(), spaceId);
            } else {
                Utils.sendToCommeters(receivers, activity.getCommentedIds(), comment.getPosterId(), spaceId);
                Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), comment.getPosterId());
                Utils.sendToActivityPoster(receivers, activity.getPosterId(), comment.getPosterId(), spaceId);
                receivers.remove(parentCommentUserPosterId);
            }
        } else {
            Utils.sendToCommeters(receivers, activity.getCommentedIds(), comment.getPosterId(), spaceId);
            Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), comment.getPosterId());
            Utils.sendToActivityPoster(receivers, activity.getPosterId(), comment.getPosterId(), spaceId);
        }
        String poster = Utils.getUserId(comment.getUserId());
        return NotificationInfo.instance().to(new ArrayList<String>(receivers)).setFrom(poster).setSpaceId(spaceId == null ? 0L : Long.parseLong(spaceId)).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.COMMENT_ID.getKey(), comment.getId()).with(SocialNotificationUtils.POSTER.getKey(), poster).key(this.getId());
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        if (this.isSubComment && comment.getParentCommentId() == null) {
            return false;
        }
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateSpaceIdentity(activity.getStreamOwner());
        return spaceIdentity == null || !activity.getPosterId().equals(spaceIdentity.getId());
    }
}

