/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.url;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.URLContext;
import org.gatein.common.io.UndeclaredIOException;

public class StandaloneAppURLContext
implements URLContext {
    private final ControllerContext controllerContext;
    private URIWriter writer;
    private StringBuilder buffer;

    public StandaloneAppURLContext(ControllerContext controllerContext) {
        if (controllerContext == null) {
            throw new NullPointerException("No null controller context");
        }
        this.controllerContext = controllerContext;
    }

    public <R, U extends PortalURL<R, U>> String render(U url) {
        try {
            return this._render(url);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    private <R, U extends PortalURL<R, U>> String _render(U url) throws IOException {
        if (url.getResource() == null) {
            throw new IllegalStateException("No resource set on standaloneApp URL");
        }
        if (this.writer == null) {
            this.buffer = new StringBuilder();
            this.writer = new URIWriter((Appendable)this.buffer);
        } else {
            this.buffer.setLength(0);
            this.writer.reset((Appendable)this.buffer);
        }
        HttpServletRequest req = this.controllerContext.getRequest();
        if (url.getSchemeUse()) {
            this.buffer.append(req.getScheme());
            this.buffer.append("://");
        }
        if (url.getAuthorityUse()) {
            this.buffer.append(req.getServerName());
            int port = req.getServerPort();
            if (port != 80) {
                this.buffer.append(':').append(port);
            }
        }
        this.writer.setMimeType(url.getMimeType());
        String confirm = url.getConfirm();
        boolean hasConfirm = confirm != null && confirm.length() > 0;
        Boolean ajax = url.getAjax() != null && url.getAjax() != false;
        if (ajax.booleanValue()) {
            this.writer.append("javascript:");
            if (hasConfirm) {
                this.writer.append("if(confirm('");
                this.writer.append(confirm.replaceAll("'", "\\\\'"));
                this.writer.append("'))");
            }
            this.writer.append("ajaxGet('");
        } else if (hasConfirm) {
            this.writer.append("javascript:");
            this.writer.append("if(confirm('");
            this.writer.append(confirm.replaceAll("'", "\\\\'"));
            this.writer.append("'))");
            this.writer.append("window.location='");
        }
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(WebAppController.HANDLER_PARAM, "standalone");
        for (QualifiedName parameterName : url.getParameterNames()) {
            String parameterValue = url.getParameterValue(parameterName);
            if (parameterValue == null) continue;
            parameters.put(parameterName, parameterValue);
        }
        this.controllerContext.renderURL(parameters, this.writer);
        Map queryParameters = url.getQueryParameters();
        if (queryParameters != null) {
            for (Map.Entry entry : queryParameters.entrySet()) {
                for (String value : (String[])entry.getValue()) {
                    this.writer.appendQueryParameter((String)entry.getKey(), value);
                }
            }
        }
        if (ajax.booleanValue()) {
            this.writer.appendQueryParameter("ajaxRequest", "true");
            this.writer.append("')");
        } else if (hasConfirm) {
            this.writer.append("'");
        }
        return this.buffer.toString();
    }
}

