/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.EntityConverter;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure1;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure11;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure13;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure15;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure17;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure19;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure21;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure3;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure5;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure7;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure9;
import org.exoplatform.wiki.jpa.dao.DraftPageAttachmentDAO;
import org.exoplatform.wiki.jpa.dao.DraftPageDAO;
import org.exoplatform.wiki.jpa.dao.PageAttachmentDAO;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.PageMoveDAO;
import org.exoplatform.wiki.jpa.dao.PageVersionDAO;
import org.exoplatform.wiki.jpa.dao.TemplateDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO;
import org.exoplatform.wiki.jpa.entity.AttachmentEntity;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PageMoveEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.TemplateEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.jpa.search.WikiElasticSearchServiceConnector;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Permission;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.utils.VersionNameComparatorDesc;

public class JPADataStorage
implements DataStorage {
    public static final String WIKI_TYPE_DRAFT = "draft";
    public static final String WIKI_FILES_NAMESPACE_NAME = "wiki";
    public static final String WIKI_FILES_NAMESPACE_DESCRIPTION = "wiki application files";
    private WikiDAO wikiDAO;
    private PageDAO pageDAO;
    private PageAttachmentDAO pageAttachmentDAO;
    private DraftPageAttachmentDAO draftPageAttachmentDAO;
    private DraftPageDAO draftPageDAO;
    private PageVersionDAO pageVersionDAO;
    private PageMoveDAO pageMoveDAO;
    private TemplateDAO templateDAO;
    private FileService fileService;
    private UserACL userACL;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public JPADataStorage(WikiDAO wikiDAO, PageDAO pageDAO, PageAttachmentDAO pageAttachmentDAO, DraftPageAttachmentDAO draftPageAttachmentDAO, DraftPageDAO draftPageDAO, PageVersionDAO pageVersionDAO, PageMoveDAO pageMoveDAO, TemplateDAO templateDAO, FileService fileService, UserACL userACL) {
        this.wikiDAO = wikiDAO;
        this.pageDAO = pageDAO;
        this.pageAttachmentDAO = pageAttachmentDAO;
        this.draftPageAttachmentDAO = draftPageAttachmentDAO;
        this.draftPageDAO = draftPageDAO;
        this.pageVersionDAO = pageVersionDAO;
        this.pageMoveDAO = pageMoveDAO;
        this.templateDAO = templateDAO;
        this.fileService = fileService;
        this.userACL = userACL;
    }

    @Override
    public PageList<SearchResult> search(WikiSearchData wikiSearchData) {
        if (wikiSearchData == null) {
            return new ObjectPageList(Collections.emptyList(), 0);
        }
        WikiElasticSearchServiceConnector searchService = (WikiElasticSearchServiceConnector)((Object)PortalContainer.getInstance().getComponentInstanceOfType(WikiElasticSearchServiceConnector.class));
        List<SearchResult> searchResults = searchService.searchWiki(this.getSearchedText(wikiSearchData), wikiSearchData.getUserId(), wikiSearchData.getTagNames(), wikiSearchData.isFavorites(), (int)wikiSearchData.getOffset(), wikiSearchData.getLimit());
        return new ObjectPageList(searchResults, searchResults.size());
    }

    private String getSearchedText(WikiSearchData wikiSearchData) {
        String searchText = "";
        if (StringUtils.isNotBlank((CharSequence)wikiSearchData.getTitle())) {
            searchText = wikiSearchData.getTitle();
        } else if (StringUtils.isNotBlank((CharSequence)wikiSearchData.getContent())) {
            searchText = wikiSearchData.getContent();
        }
        return searchText;
    }

    private SearchResult toSearchResult(io.meeds.notes.legacy.api.search.data.SearchResult input) {
        SearchResult output = new SearchResult();
        output.setTitle(input.getTitle());
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(input.getDate());
        output.setCreatedDate(cal);
        output.setExcerpt(input.getExcerpt());
        output.setPageName(input.getTitle());
        output.setUrl(input.getUrl());
        return output;
    }

    @Override
    public Wiki getWikiByTypeAndOwner(String wikiType, String wikiOwner) throws WikiException {
        return EntityConverter.convertWikiEntityToWiki(this.wikiDAO.getWikiByTypeAndOwner(wikiType, wikiOwner));
    }

    @Override
    public List<Wiki> getWikisByType(String wikiType) throws WikiException {
        ArrayList<Wiki> wikis = new ArrayList<Wiki>();
        for (WikiEntity wikiEntity : this.wikiDAO.getWikisByType(wikiType)) {
            wikis.add(EntityConverter.convertWikiEntityToWiki(wikiEntity));
        }
        return wikis;
    }

    @Override
    @ExoTransactional
    public Wiki createWiki(Wiki wiki) throws WikiException {
        Wiki wiki2 = wiki;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)wiki2);
        Object[] objectArray = new Object[]{this, wiki2, joinPoint};
        JPADataStorage$AjcClosure1 jPADataStorage$AjcClosure1 = new JPADataStorage$AjcClosure1(objectArray);
        return (Wiki)ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Page createPage(Wiki wiki, Page parentPage, Page page) throws WikiException {
        Wiki wiki2 = wiki;
        Page page2 = parentPage;
        Page page3 = page;
        Object[] objectArray = new Object[]{wiki2, page2, page3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, wiki2, page2, page3, joinPoint};
        JPADataStorage$AjcClosure3 jPADataStorage$AjcClosure3 = new JPADataStorage$AjcClosure3(objectArray2);
        return (Page)ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    public Page getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) throws WikiException {
        if (wikiType == null || wikiOwner == null) {
            return null;
        }
        if (WIKI_TYPE_DRAFT.equals(wikiType)) {
            return EntityConverter.convertDraftPageEntityToDraftPage(this.draftPageDAO.findLatestDraftPageByUserAndName(wikiOwner, pageName));
        }
        return EntityConverter.convertPageEntityToPage(this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName));
    }

    @Override
    public Page getPageById(String id) throws WikiException {
        return EntityConverter.convertPageEntityToPage((PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(id))));
    }

    @Override
    public DraftPage getDraftPageById(String id) throws WikiException {
        return EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)this.draftPageDAO.find(Long.valueOf(Long.parseLong(id))));
    }

    @Override
    public Page getParentPageOf(Page page) throws WikiException {
        Page parentPage = null;
        PageEntity childPageEntity = null;
        childPageEntity = page.getId() != null && !page.getId().isEmpty() ? (PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(page.getId()))) : this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (childPageEntity != null) {
            parentPage = EntityConverter.convertPageEntityToPage(childPageEntity.getParentPage());
        }
        return parentPage;
    }

    @Override
    public List<Page> getChildrenPageOf(Page page, String userId, boolean withDrafts) throws WikiException {
        List<DraftPageEntity> draftPageEntities;
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot get children of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<Page> childrenPages = new ArrayList<Page>();
        List<PageEntity> childrenPagesEntities = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPagesEntities != null) {
            for (PageEntity childPageEntity : childrenPagesEntities) {
                childrenPages.add(EntityConverter.convertPageEntityToPage(childPageEntity));
            }
        }
        if (withDrafts && !(draftPageEntities = this.draftPageDAO.findDraftPagesByUserAndParentPage(userId, pageEntity.getId())).isEmpty()) {
            for (DraftPageEntity draftPageEntity : draftPageEntities) {
                childrenPages.add(EntityConverter.convertDraftPageEntityToDraftPage(draftPageEntity));
            }
        }
        return childrenPages;
    }

    @Override
    public boolean hasChildren(long noteId) throws WikiException {
        return this.pageDAO.countPageChildrenById(noteId) > 0L;
    }

    @Override
    @ExoTransactional
    public void deletePage(String wikiType, String wikiOwner, String pageName) throws WikiException {
        String string = wikiType;
        String string2 = wikiOwner;
        String string3 = pageName;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        JPADataStorage$AjcClosure5 jPADataStorage$AjcClosure5 = new JPADataStorage$AjcClosure5(objectArray2);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    private void deletePageEntity(PageEntity pageEntity) {
        List<PageEntity> childrenPages = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPages != null) {
            for (PageEntity childPage : childrenPages) {
                this.deletePageEntity(childPage);
            }
        }
        pageEntity.setDeleted(true);
        this.pageDAO.update(pageEntity);
    }

    @Override
    public void deleteDraftOfPage(Page page, String username) throws WikiException {
        List<DraftPageEntity> draftPages = this.draftPageDAO.findDraftPagesByUserAndTargetPage(username, Long.parseLong(page.getId()));
        for (DraftPageEntity draftPage : draftPages) {
            if (draftPage == null) continue;
            this.deleteAttachmentsOfDraftPage(draftPage);
        }
        this.draftPageDAO.deleteDraftPagesByUserAndTargetPage(username, Long.valueOf(page.getId()));
    }

    @Override
    public void deleteDraftOfPage(Page page, String username, String lang) throws WikiException {
        List<DraftPageEntity> draftPages = this.draftPageDAO.findDraftPagesByUserAndTargetPage(username, Long.parseLong(page.getId()));
        for (DraftPageEntity draftPage : draftPages) {
            if (draftPage == null || !StringUtils.equals((CharSequence)draftPage.getLang(), (CharSequence)lang)) continue;
            this.deleteAttachmentsOfDraftPage(draftPage);
            this.draftPageDAO.delete(draftPage);
        }
    }

    @Override
    public void deleteDraftByName(String draftPageName, String username) throws WikiException {
        DraftPageEntity draftPage = this.draftPageDAO.findLatestDraftPageByUserAndName(username, draftPageName);
        if (draftPage != null) {
            this.deleteAttachmentsOfDraftPage(draftPage);
        }
        this.draftPageDAO.deleteDraftPagesByUserAndName(draftPageName, username);
    }

    @Override
    @ExoTransactional
    public void renamePage(String wikiType, String wikiOwner, String pageName, String newName, String newTitle) throws WikiException {
        String string = wikiType;
        String string2 = wikiOwner;
        String string3 = pageName;
        String string4 = newName;
        String string5 = newTitle;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, joinPoint};
        JPADataStorage$AjcClosure7 jPADataStorage$AjcClosure7 = new JPADataStorage$AjcClosure7(objectArray2);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void movePage(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        WikiPageParams wikiPageParams = currentLocationParams;
        WikiPageParams wikiPageParams2 = newLocationParams;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)wikiPageParams, (Object)wikiPageParams2);
        Object[] objectArray = new Object[]{this, wikiPageParams, wikiPageParams2, joinPoint};
        JPADataStorage$AjcClosure9 jPADataStorage$AjcClosure9 = new JPADataStorage$AjcClosure9(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void updateWikiOfPageTree(WikiEntity wikiEntity, PageEntity pageEntity) {
        pageEntity.setWiki(wikiEntity);
        List<PageEntity> childrenPages = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPages != null) {
            for (PageEntity childrenPageEntity : childrenPages) {
                this.updateWikiOfPageTree(wikiEntity, childrenPageEntity);
            }
        }
    }

    @Override
    public List<PermissionEntry> getWikiPermission(String wikiType, String wikiOwner) throws WikiException {
        WikiEntity wikiEntity = this.wikiDAO.getWikiByTypeAndOwner(wikiType, wikiOwner);
        if (wikiEntity == null) {
            throw new WikiException("Cannot get permissions of wiki " + wikiType + ":" + wikiOwner + " because wiki does not exist.");
        }
        return EntityConverter.convertPermissionEntitiesToPermissionEntries(wikiEntity.getPermissions(), Arrays.asList(PermissionType.ADMINPAGE, PermissionType.ADMINSPACE));
    }

    @Override
    public void updateWikiPermission(String wikiType, String wikiOwner, List<PermissionEntry> permissionEntries) throws WikiException {
        WikiEntity wikiEntity = this.wikiDAO.getWikiByTypeAndOwner(wikiType, wikiOwner);
        if (wikiEntity == null) {
            throw new WikiException("Cannot update permissions of wiki " + wikiType + ":" + wikiOwner + " because wiki does not exist.");
        }
        wikiEntity.setPermissions(EntityConverter.convertPermissionEntriesToPermissionEntities(permissionEntries));
        this.wikiDAO.update(wikiEntity);
    }

    @Override
    public List<Page> getRelatedPagesOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot get related pages of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<Page> relatedPages = new ArrayList<Page>();
        List<PageEntity> relatedPagesEntities = pageEntity.getRelatedPages();
        if (relatedPagesEntities != null) {
            for (PageEntity relatedPageEntity : relatedPagesEntities) {
                relatedPages.add(EntityConverter.convertPageEntityToPage(relatedPageEntity));
            }
        }
        return relatedPages;
    }

    @Override
    public Page getRelatedPage(String wikiType, String wikiOwner, String pageName) throws WikiException {
        Page relatedPage = null;
        List<PageMoveEntity> pageMoveEntities = this.pageMoveDAO.findInPageMoves(wikiType, wikiOwner, pageName);
        if (pageMoveEntities != null && !pageMoveEntities.isEmpty()) {
            relatedPage = EntityConverter.convertPageEntityToPage(pageMoveEntities.get(0).getPage());
        }
        return relatedPage;
    }

    @Override
    public void addRelatedPage(Page page, Page relatedPage) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot add related page to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        PageEntity relatedPageEntity = this.pageDAO.getPageOfWikiByName(relatedPage.getWikiType(), relatedPage.getWikiOwner(), relatedPage.getName());
        if (relatedPageEntity == null) {
            throw new WikiException("Cannot add related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because related page does not exist.");
        }
        List<PageEntity> relatedPages = pageEntity.getRelatedPages();
        if (relatedPages == null) {
            relatedPages = new ArrayList<PageEntity>();
        }
        relatedPages.add(relatedPageEntity);
        pageEntity.setRelatedPages(relatedPages);
        this.pageDAO.update(pageEntity);
    }

    @Override
    public List<Page> getPagesOfWiki(String wikiType, String wikiOwner) {
        if (StringUtils.isBlank((CharSequence)wikiOwner)) {
            throw new IllegalArgumentException("wikiOwner is mandatory argument");
        }
        if (StringUtils.isBlank((CharSequence)wikiType)) {
            throw new IllegalArgumentException("wikiType is mandatory argument");
        }
        List<PageEntity> pagesOfWiki = this.pageDAO.getPagesOfWiki(wikiType, wikiOwner, false);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (PageEntity pageEntity : pagesOfWiki) {
            pages.add(EntityConverter.convertPageEntityToPage(pageEntity));
        }
        return pages;
    }

    @Override
    public void removeRelatedPage(Page page, Page relatedPage) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot remove related page to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        PageEntity relatedPageEntity = this.pageDAO.getPageOfWikiByName(relatedPage.getWikiType(), relatedPage.getWikiOwner(), relatedPage.getName());
        if (relatedPageEntity == null) {
            throw new WikiException("Cannot remove related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because related page does not exist.");
        }
        List<PageEntity> relatedPages = pageEntity.getRelatedPages();
        if (relatedPages != null) {
            for (int i = 0; i < relatedPages.size(); ++i) {
                if (relatedPages.get(i).getId() != relatedPageEntity.getId()) continue;
                relatedPages.remove(i);
                break;
            }
            pageEntity.setRelatedPages(relatedPages);
            this.pageDAO.update(pageEntity);
        }
    }

    @Override
    public Page getExsitedOrNewDraftPageById(String wikiType, String wikiOwner, String pageName, String username) throws WikiException {
        DraftPage draftPage;
        if (pageName.contains("_A_A_")) {
            String[] pageNameParts = pageName.split("_A_A_");
            username = pageNameParts[0];
        }
        if ((draftPage = this.getDraft(pageName, username)) == null) {
            Page targetPage;
            Date now = GregorianCalendar.getInstance().getTime();
            draftPage = new DraftPage();
            draftPage.setWikiType(PortalConfig.USER_TYPE);
            draftPage.setWikiOwner(username);
            draftPage.setName(pageName);
            draftPage.setAuthor(username);
            draftPage.setNewPage(true);
            draftPage.setCreatedDate(now);
            draftPage.setUpdatedDate(now);
            if (wikiType != null && wikiOwner != null && (targetPage = this.getPageOfWikiByName(wikiType, wikiOwner, pageName)) != null) {
                draftPage.setTargetPageId(targetPage.getId());
                draftPage.setTargetPageRevision("1");
            }
            this.createDraftPageForUser(draftPage, username);
        }
        return draftPage;
    }

    @Override
    public List<DraftPage> getDraftsOfPage(Long pageId, String username) {
        ArrayList<DraftPage> draftPages = new ArrayList<DraftPage>();
        List<DraftPageEntity> draftPagesOfUser = this.draftPageDAO.findDraftPagesByUserAndTargetPage(username, pageId);
        for (DraftPageEntity draft : draftPagesOfUser) {
            draftPages.add(EntityConverter.convertDraftPageEntityToDraftPage(draft));
        }
        return draftPages;
    }

    @Override
    public DraftPage getDraft(WikiPageParams wikiPageParams, String username) throws WikiException {
        BasePageEntity latestDraftEntity;
        DraftPage latestDraft = null;
        Page page = this.getPageOfWikiByName(wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageName());
        if (page != null) {
            List<DraftPageEntity> draftPagesOfUser = this.draftPageDAO.findDraftPagesByUserAndTargetPage(username, Long.valueOf(page.getId()));
            latestDraftEntity = null;
            for (DraftPageEntity draft : draftPagesOfUser) {
                if (latestDraftEntity != null && latestDraftEntity.getUpdatedDate().getTime() >= draft.getUpdatedDate().getTime()) continue;
                latestDraftEntity = draft;
            }
        } else {
            throw new WikiException("Cannot get draft of page " + wikiPageParams.getType() + ":" + wikiPageParams.getOwner() + ":" + wikiPageParams.getPageName() + " because page does not exist.");
        }
        latestDraft = EntityConverter.convertDraftPageEntityToDraftPage(latestDraftEntity);
        return latestDraft;
    }

    @Override
    public DraftPage getLastestDraft(String username) throws WikiException {
        DraftPageEntity draftPagEntity = this.draftPageDAO.findLatestDraftPageByUser(username);
        return EntityConverter.convertDraftPageEntityToDraftPage(draftPagEntity);
    }

    @Override
    public DraftPage getLatestDraftOfPage(Page targetPage, String username) {
        DraftPageEntity draftPagEntity = this.draftPageDAO.findLatestDraftPageByUserAndTargetPage(Long.parseLong(targetPage.getId()), username);
        return EntityConverter.convertDraftPageEntityToDraftPage(draftPagEntity);
    }

    @Override
    public DraftPage getDraft(String draftName, String username) throws WikiException {
        DraftPage draftPageOfUser = null;
        List<DraftPage> draftPages = this.getDraftPagesOfUser(username);
        if (draftPages != null) {
            for (DraftPage draftPage : draftPages) {
                if (draftPage.getName() == null || !draftPage.getName().equals(draftName)) continue;
                draftPageOfUser = draftPage;
                break;
            }
        }
        return draftPageOfUser;
    }

    @Override
    public List<DraftPage> getDraftPagesOfUser(String username) throws WikiException {
        ArrayList<DraftPage> draftPages = new ArrayList<DraftPage>();
        List<DraftPageEntity> draftPagesEntities = this.draftPageDAO.findDraftPagesByUser(username);
        if (draftPagesEntities != null) {
            for (DraftPageEntity draftPageEntity : draftPagesEntities) {
                draftPages.add(EntityConverter.convertDraftPageEntityToDraftPage(draftPageEntity));
            }
        }
        return draftPages;
    }

    @Override
    public DraftPage createDraftPageForUser(DraftPage draftPage, String username) throws WikiException {
        DraftPageEntity draftPageEntity = EntityConverter.convertDraftPageToDraftPageEntity(draftPage, this.pageDAO);
        draftPageEntity.setAuthor(username);
        draftPage = EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)this.draftPageDAO.create(draftPageEntity));
        return draftPage;
    }

    @Override
    public DraftPage updateDraftPageForUser(DraftPage draftPage, String username) throws WikiException {
        DraftPageEntity draftPageEntity = EntityConverter.convertDraftPageToDraftPageEntity(draftPage, this.pageDAO);
        draftPageEntity.setAuthor(username);
        draftPage = EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)this.draftPageDAO.update(draftPageEntity));
        return draftPage;
    }

    @Override
    public List<TemplateSearchResult> searchTemplate(TemplateSearchData templateSearchData) throws WikiException {
        String wikiOwner = templateSearchData.getWikiOwner();
        if (templateSearchData.getWikiType().toUpperCase().equals(WikiType.GROUP.toString())) {
            wikiOwner = this.templateDAO.validateGroupWikiOwner(wikiOwner);
        }
        List<TemplateEntity> templates = this.templateDAO.searchTemplatesByTitle(templateSearchData.getWikiType(), wikiOwner, templateSearchData.getTitle());
        ArrayList<TemplateSearchResult> searchResults = new ArrayList<TemplateSearchResult>();
        if (templates != null) {
            for (TemplateEntity templateEntity : templates) {
                Calendar createdDateCalendar = null;
                Date createdDate = templateEntity.getCreatedDate();
                if (createdDate != null) {
                    createdDateCalendar = Calendar.getInstance();
                    createdDateCalendar.setTime(createdDate);
                }
                Calendar updatedDateCalendar = null;
                Date updatedDate = templateEntity.getUpdatedDate();
                if (updatedDate != null) {
                    updatedDateCalendar = Calendar.getInstance();
                    updatedDateCalendar.setTime(updatedDate);
                }
                TemplateSearchResult templateSearchResult = new TemplateSearchResult(templateEntity.getWiki().getType(), templateEntity.getWiki().getOwner(), templateEntity.getName(), templateEntity.getTitle(), SearchResultType.TEMPLATE, updatedDateCalendar, createdDateCalendar, null);
                searchResults.add(templateSearchResult);
            }
        }
        return searchResults;
    }

    @Override
    public List<Attachment> getAttachmentsOfPage(Page page) throws WikiException {
        return this.getAttachmentsOfPage(page, false);
    }

    @Override
    public List<Attachment> getAttachmentsOfPage(Page page, boolean loadContent) throws WikiException {
        String pageName;
        String wikiOwner;
        String wikiType;
        ArrayList<AttachmentEntity> attachmentsEntities;
        if (page.isDraftPage()) {
            DraftPageEntity draftPageEntity = this.draftPageDAO.findLatestDraftPageByUserAndName(page.getAuthor(), page.getName());
            if (draftPageEntity == null) {
                throw new WikiException("Cannot get attachments of draft page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because draft page does not exist.");
            }
            attachmentsEntities = new ArrayList();
            List<DraftPageAttachmentEntity> draftPageAttachmentEntities = draftPageEntity.getAttachments();
            if (draftPageAttachmentEntities != null) {
                attachmentsEntities.addAll(draftPageAttachmentEntities);
            }
            if (draftPageEntity.isNewPage()) {
                wikiType = WIKI_TYPE_DRAFT;
                wikiOwner = draftPageEntity.getAuthor();
                pageName = draftPageEntity.getName();
            } else {
                PageEntity targetPage = draftPageEntity.getTargetPage();
                WikiEntity wiki = targetPage.getWiki();
                wikiType = wiki.getType();
                wikiOwner = wiki.getOwner();
                pageName = targetPage.getName();
            }
        } else {
            PageEntity pageEntity = this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot get attachments of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            attachmentsEntities = new ArrayList<AttachmentEntity>();
            List<PageAttachmentEntity> pageAttachmentEntities = pageEntity.getAttachments();
            if (pageAttachmentEntities != null) {
                attachmentsEntities.addAll(pageAttachmentEntities);
            }
            WikiEntity wikiEntity = pageEntity.getWiki();
            wikiType = wikiEntity.getType();
            wikiOwner = wikiEntity.getOwner();
            pageName = pageEntity.getName();
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (attachmentsEntities != null) {
            for (AttachmentEntity attachmentEntity : attachmentsEntities) {
                Attachment attachment = EntityConverter.convertAttachmentEntityToAttachment(this.fileService, attachmentEntity, loadContent);
                if (attachment.getTitle() == null || StringUtils.isEmpty((CharSequence)attachment.getTitle())) {
                    int index = attachment.getName().lastIndexOf(".");
                    if (index != -1) {
                        attachment.setTitle(attachment.getName().substring(0, index));
                    } else {
                        attachment.setTitle(attachment.getName());
                    }
                }
                if (attachment.getFullTitle() == null || StringUtils.isEmpty((CharSequence)attachment.getFullTitle())) {
                    attachment.setFullTitle(attachment.getName());
                }
                attachment.setDownloadURL(this.getDownloadURL(wikiType, wikiOwner, pageName, attachment));
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    @Override
    @ExoTransactional
    public void addAttachmentToPage(Attachment attachment, Page page) throws WikiException {
        Attachment attachment2 = attachment;
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)attachment2, (Object)page2);
        Object[] objectArray = new Object[]{this, attachment2, page2, joinPoint};
        JPADataStorage$AjcClosure11 jPADataStorage$AjcClosure11 = new JPADataStorage$AjcClosure11(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteAttachmentOfPage(String attachmentName, Page page) throws WikiException {
        String string = attachmentName;
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)page2);
        Object[] objectArray = new Object[]{this, string, page2, joinPoint};
        JPADataStorage$AjcClosure13 jPADataStorage$AjcClosure13 = new JPADataStorage$AjcClosure13(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    private boolean deletePageAttachementEntity(String attachmentName, PageEntity pageEntity, boolean attachmentFound) {
        List<PageAttachmentEntity> attachmentsEntities = pageEntity.getAttachments();
        if (attachmentsEntities != null) {
            for (int i = 0; i < attachmentsEntities.size(); ++i) {
                AttachmentEntity attachmentEntity = attachmentsEntities.get(i);
                String name = null;
                if (attachmentEntity.getAttachmentFileID() != null) {
                    name = this.fileService.getFileInfo(attachmentEntity.getAttachmentFileID().longValue()).getName();
                }
                if (name == null || !name.equals(attachmentName)) continue;
                attachmentFound = true;
                attachmentsEntities.remove(i);
                this.fileService.deleteFile(attachmentEntity.getAttachmentFileID().longValue());
                this.pageAttachmentDAO.delete((PageAttachmentEntity)attachmentEntity);
                pageEntity.setAttachments(attachmentsEntities);
                this.pageDAO.update(pageEntity);
                break;
            }
        }
        return attachmentFound;
    }

    private boolean deleteDraftPageAttachementEntity(String attachmentName, DraftPageEntity draftPageEntity, boolean attachmentFound) {
        List<DraftPageAttachmentEntity> draftAttachmentsEntities = draftPageEntity.getAttachments();
        if (draftAttachmentsEntities != null) {
            for (int i = 0; i < draftAttachmentsEntities.size(); ++i) {
                AttachmentEntity attachmentEntity = draftAttachmentsEntities.get(i);
                String name = null;
                if (attachmentEntity.getAttachmentFileID() != null) {
                    name = this.fileService.getFileInfo(attachmentEntity.getAttachmentFileID().longValue()).getName();
                }
                if (name == null || !name.equals(attachmentName)) continue;
                attachmentFound = true;
                draftAttachmentsEntities.remove(i);
                this.fileService.deleteFile(attachmentEntity.getAttachmentFileID().longValue());
                this.draftPageAttachmentDAO.delete((DraftPageAttachmentEntity)attachmentEntity);
                draftPageEntity.setAttachments(draftAttachmentsEntities);
                this.draftPageDAO.update(draftPageEntity);
                break;
            }
        }
        return attachmentFound;
    }

    @Override
    @Deprecated
    public Page getHelpSyntaxPage(String syntaxId, boolean fullContent, List<ValuesParam> syntaxHelpParams, ConfigurationManager configurationManager) throws WikiException {
        return null;
    }

    @Override
    public boolean hasPermissionOnPage(Page page, PermissionType permissionType, Identity identity) throws WikiException {
        String userId = identity.getUserId();
        if (userId.equals(IdentityConstants.SYSTEM)) {
            return true;
        }
        if (userId.equals(page.getOwner())) {
            return true;
        }
        List<PermissionEntry> pagePermissions = page.getPermissions();
        if (pagePermissions == null) {
            Page fetchedPage = page.getId() != null && !page.getId().isEmpty() ? this.getPageById(page.getId()) : this.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
            pagePermissions = fetchedPage.getPermissions();
        }
        if (pagePermissions == null || pagePermissions.isEmpty()) {
            return true;
        }
        return this.hasPermission(pagePermissions, identity, permissionType);
    }

    @Override
    public boolean hasPermissionOnWiki(Wiki wiki, PermissionType permissionType, Identity identity) throws WikiException {
        if (wiki == null) {
            throw new WikiException("Wiki cannot be null");
        }
        String userId = identity.getUserId();
        if (userId.equals(IdentityConstants.SYSTEM)) {
            return true;
        }
        if (wiki.getType().equals(PortalConfig.USER_TYPE) && userId.equals(wiki.getOwner())) {
            return true;
        }
        List<PermissionEntry> wikiPermissions = wiki.getPermissions();
        if (wikiPermissions == null || wikiPermissions.isEmpty()) {
            return true;
        }
        return this.hasPermission(wikiPermissions, identity, permissionType);
    }

    @Override
    public boolean hasAdminSpacePermission(String wikiType, String owner, Identity identity) throws WikiException {
        Wiki wiki = this.getWikiByTypeAndOwner(wikiType, owner);
        return this.hasPermissionOnWiki(wiki, PermissionType.ADMINSPACE, identity);
    }

    @Override
    public boolean hasAdminPagePermission(String wikiType, String owner, Identity identity) throws WikiException {
        Wiki wiki = this.getWikiByTypeAndOwner(wikiType, owner);
        return this.hasPermissionOnWiki(wiki, PermissionType.ADMINPAGE, identity);
    }

    private boolean hasPermission(List<PermissionEntry> resourcePermissions, Identity identity, PermissionType permissionType) {
        String userId = identity.getUserId();
        for (PermissionEntry pagePermission : resourcePermissions) {
            block6: for (Permission permission : pagePermission.getPermissions()) {
                if (!permission.isAllowed() || !permission.getPermissionType().equals((Object)permissionType)) continue;
                if (IdentityConstants.ANY.equals(pagePermission.getId())) {
                    return true;
                }
                switch (pagePermission.getIdType()) {
                    case USER: {
                        if (userId.equals(pagePermission.getId())) {
                            return true;
                        }
                    }
                    case GROUP: {
                        if (identity.isMemberOf(pagePermission.getId())) {
                            return true;
                        }
                    }
                    case MEMBERSHIP: {
                        UserACL.Permission membershipPermission = new UserACL.Permission();
                        membershipPermission.setPermissionExpression(pagePermission.getId());
                        if (!identity.isMemberOf(membershipPermission.getGroupId(), membershipPermission.getMembership())) continue block6;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public List<PageVersion> getVersionsOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get versions of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<PageVersion> pageVersions = new ArrayList<PageVersion>();
        List<PageVersionEntity> pageVersionEntities = pageEntity.getVersions();
        if (pageVersionEntities != null) {
            for (PageVersionEntity pageVersionEntity : pageVersionEntities) {
                pageVersions.add(EntityConverter.convertPageVersionEntityToPageVersion(pageVersionEntity));
            }
        }
        Collections.sort(pageVersions, new VersionNameComparatorDesc());
        return pageVersions;
    }

    @Override
    public List<PageHistory> getHistoryOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get versions of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<PageHistory> pageVersionsHistory = new ArrayList<PageHistory>();
        List<PageVersionEntity> pageVersionEntities = pageEntity.getVersions();
        if (pageVersionEntities != null) {
            for (PageVersionEntity pageVersionEntity : pageVersionEntities) {
                PageHistory pageHistory = EntityConverter.convertPageVersionEntityToPageHistory(pageVersionEntity);
                pageVersionsHistory.add(pageHistory);
            }
        }
        return pageVersionsHistory;
    }

    @Override
    @ExoTransactional
    public void addPageVersion(Page page, String userName) throws WikiException {
        Page page2 = page;
        String string = userName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)page2, (Object)string);
        Object[] objectArray = new Object[]{this, page2, string, joinPoint};
        JPADataStorage$AjcClosure15 jPADataStorage$AjcClosure15 = new JPADataStorage$AjcClosure15(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    @Override
    public void restoreVersionOfPage(String versionName, Page page) throws WikiException {
        PageVersionEntity versionToRestore;
        PageEntity pageEntity;
        if (page != null) {
            pageEntity = this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot restore version of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            versionToRestore = this.pageVersionDAO.getPageversionByPageIdAndVersion(Long.parseLong(page.getId()), Long.parseLong(versionName));
            if (versionToRestore == null) {
                throw new WikiException("Cannot restore version " + versionName + " of a page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because version does not exist.");
            }
        } else {
            throw new WikiException("Cannot restore version of a page null");
        }
        pageEntity.setContent(versionToRestore.getContent());
        pageEntity.setUpdatedDate(Calendar.getInstance().getTime());
        this.pageDAO.update(pageEntity);
    }

    @Override
    @ExoTransactional
    public Page updatePage(Page page) throws WikiException {
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)page2);
        Object[] objectArray = new Object[]{this, page2, joinPoint};
        JPADataStorage$AjcClosure17 jPADataStorage$AjcClosure17 = new JPADataStorage$AjcClosure17(objectArray);
        return (Page)ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    @Override
    public List<String> getPreviousNamesOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get previous names of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<String> previousPageName = new ArrayList<String>();
        List<PageMoveEntity> moves = pageEntity.getMoves();
        if (moves != null) {
            for (PageMoveEntity pageMoveEntity : moves) {
                previousPageName.add(pageMoveEntity.getPageName());
            }
        }
        return previousPageName;
    }

    @Override
    public List<String> getWatchersOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get watchers of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        return pageEntity.getWatchers() == null ? null : new ArrayList<String>(pageEntity.getWatchers());
    }

    @Override
    public void addWatcherToPage(String username, Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot add a watcher on page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        if (pageEntity.getWatchers() == null) {
            throw new WikiException("Cannot add a watcher on page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because list of watchers is null.");
        }
        pageEntity.getWatchers().add(username);
        this.pageDAO.update(pageEntity);
    }

    @Override
    public void deleteWatcherOfPage(String username, Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete a watcher of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        Set<String> watchers = pageEntity.getWatchers();
        if (watchers == null || !watchers.contains(username)) {
            throw new WikiException("Cannot remove watcher " + username + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because watcher does not exist.");
        }
        watchers.remove(username);
        pageEntity.setWatchers(watchers);
        this.pageDAO.update(pageEntity);
    }

    @ExoTransactional
    public void deleteAttachmentsOfDraftPage(DraftPageEntity page) throws WikiException {
        DraftPageEntity draftPageEntity = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)draftPageEntity);
        Object[] objectArray = new Object[]{this, draftPageEntity, joinPoint};
        JPADataStorage$AjcClosure19 jPADataStorage$AjcClosure19 = new JPADataStorage$AjcClosure19(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    public PageEntity fetchPageEntity(Page page) {
        Long pageId = null;
        if (page.getId() != null && !page.getId().isEmpty()) {
            try {
                pageId = Long.parseLong(page.getId());
            }
            catch (NumberFormatException e) {
                pageId = null;
            }
        }
        PageEntity pageEntity = pageId != null ? (PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(page.getId()))) : this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        return pageEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<PermissionEntry> getWikiHomePageDefaultPermissions(String wikiType, String wikiOwner) throws WikiException {
        Permission[] permissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true)};
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
            HashMap<String, IDType> aclForAdmins = Utils.getACLForAdmins();
            for (Map.Entry<String, IDType> entry : aclForAdmins.entrySet()) {
                PermissionEntry permissionEntry = new PermissionEntry(entry.getKey(), "", entry.getValue(), permissions);
                permissionEntries.add(permissionEntry);
            }
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
            try {
                String[] portalAccessPermissions;
                UserPortalConfig userPortalConfig;
                if (userPortalConfigService == null || (userPortalConfig = userPortalConfigService.getUserPortalConfig(wikiOwner, null)) == null) return permissionEntries;
                PortalConfig portalConfig = userPortalConfig.getPortalConfig();
                String portalEditPermission = portalConfig.getEditPermission();
                if (!aclForAdmins.containsKey(portalEditPermission)) {
                    PermissionEntry portalPermissionEntry = new PermissionEntry(portalEditPermission, "", IDType.MEMBERSHIP, permissions);
                    permissionEntries.add(portalPermissionEntry);
                }
                if ((portalAccessPermissions = portalConfig.getAccessPermissions()) == null || portalAccessPermissions.length <= 0) return permissionEntries;
                Permission[] viewPermissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, false)};
                for (String portalAccessPermissionExpression : portalAccessPermissions) {
                    if (StringUtils.equals((CharSequence)portalAccessPermissionExpression, (CharSequence)portalEditPermission) || aclForAdmins.containsKey(portalAccessPermissionExpression)) continue;
                    IDType idType = null;
                    if (StringUtils.equals((CharSequence)"Everyone", (CharSequence)portalAccessPermissionExpression)) {
                        if (!StringUtils.equals((CharSequence)"*:/platform/users", (CharSequence)portalEditPermission) && !aclForAdmins.containsKey("*:/platform/users")) {
                            PermissionEntry internalUsersPermissionEntry = new PermissionEntry("/platform/users", "", IDType.GROUP, viewPermissions);
                            permissionEntries.add(internalUsersPermissionEntry);
                        }
                        if (StringUtils.equals((CharSequence)"*:/platform/externals", (CharSequence)portalEditPermission) || aclForAdmins.containsKey("*:/platform/externals")) continue;
                        PermissionEntry externalUsersPermissionEntry = new PermissionEntry("/platform/externals", "", IDType.GROUP, viewPermissions);
                        permissionEntries.add(externalUsersPermissionEntry);
                        continue;
                    }
                    idType = StringUtils.contains((CharSequence)portalAccessPermissionExpression, (CharSequence)"/") && StringUtils.contains((CharSequence)portalAccessPermissionExpression, (CharSequence)":") ? IDType.MEMBERSHIP : (StringUtils.contains((CharSequence)portalAccessPermissionExpression, (CharSequence)"/") ? IDType.GROUP : IDType.USER);
                    PermissionEntry accessPermissionEntry = new PermissionEntry(portalAccessPermissionExpression, "", idType, viewPermissions);
                    permissionEntries.add(accessPermissionEntry);
                }
                return permissionEntries;
            }
            catch (Exception e) {
                throw new WikiException("Cannot get user portal config for wiki " + wikiType + ":" + wikiOwner + " - Cause : " + e.getMessage(), e);
            }
        } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
            PermissionEntry groupPermissionEntry = new PermissionEntry(wikiOwner, "", IDType.GROUP, permissions);
            permissionEntries.add(groupPermissionEntry);
            return permissionEntries;
        } else {
            if (!PortalConfig.USER_TYPE.equals(wikiType)) return permissionEntries;
            PermissionEntry ownerPermissionEntry = new PermissionEntry(wikiOwner, "", IDType.USER, permissions);
            permissionEntries.add(ownerPermissionEntry);
        }
        return permissionEntries;
    }

    private String getDownloadURL(String wikiType, String wikiOwner, String pageName, Attachment attachment) {
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.getDefaultRestBaseURI()).append("/wiki/attachments/").append(wikiType).append("/").append("space").append("/").append(wikiOwner).append("/").append("page").append("/").append(pageName);
        try {
            sb.append("/").append(URLEncoder.encode(attachment.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            sb.append("/").append(attachment.getName());
        }
        return sb.toString();
    }

    @Override
    public List<PageHistory> getPageHistoryVersionsByPageIdAndLang(Long pageId, String lang) {
        if (pageId == null) {
            throw new IllegalArgumentException("pageId argument is null");
        }
        return EntityConverter.toPageHistoryVersions(this.pageVersionDAO.findPageVersionsByPageIdAndLang(pageId, lang));
    }

    @Override
    public DraftPage getLatestDraftPageByUserAndTargetPageAndLang(Long targetPageId, String username, String lang) {
        if (username == null) {
            throw new IllegalArgumentException("username argument is null");
        }
        if (targetPageId == null) {
            throw new IllegalArgumentException("targetPageId argument is null");
        }
        return EntityConverter.convertDraftPageEntityToDraftPage(this.draftPageDAO.findLatestDraftPageByUserAndTargetPageAndLang(targetPageId, username, lang));
    }

    @Override
    public PageVersion getPublishedVersionByPageIdAndLang(Long pageId, String lang) {
        if (pageId == null) {
            throw new IllegalArgumentException("targetPageId argument is null");
        }
        return EntityConverter.convertPageVersionEntityToPageVersion(this.pageVersionDAO.findLatestVersionByPageIdAndLang(pageId, lang));
    }

    @Override
    public List<String> getPageAvailableTranslationLanguages(Long pageId) {
        if (pageId == null) {
            throw new IllegalArgumentException("pageId argument is null");
        }
        return this.pageVersionDAO.findPageAvailableTranslationLanguages(pageId);
    }

    @Override
    @ExoTransactional
    public void deleteVersionsByNoteIdAndLang(Long noteId, String lang) throws WikiException {
        Long l = noteId;
        String string = lang;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)l, (Object)string);
        Object[] objectArray = new Object[]{this, l, string, joinPoint};
        JPADataStorage$AjcClosure21 jPADataStorage$AjcClosure21 = new JPADataStorage$AjcClosure21(objectArray);
        ExoTransactionalAspect.aspectOf().around(jPADataStorage$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    static {
        JPADataStorage.ajc$preClinit();
    }

    static /* synthetic */ Wiki createWiki_aroundBody0(JPADataStorage ajc$this, Wiki wiki, JoinPoint joinPoint) {
        WikiEntity createdWikiEntity = (WikiEntity)ajc$this.wikiDAO.create(EntityConverter.convertWikiToWikiEntity(wiki, ajc$this.wikiDAO));
        Wiki createdWiki = EntityConverter.convertWikiEntityToWiki(createdWikiEntity);
        Page wikiHomePage = new Page();
        wikiHomePage.setWikiType(wiki.getType());
        wikiHomePage.setWikiOwner(wiki.getOwner());
        wikiHomePage.setName("Home");
        wikiHomePage.setTitle("Home");
        Date now = Calendar.getInstance().getTime();
        wikiHomePage.setCreatedDate(now);
        wikiHomePage.setUpdatedDate(now);
        wikiHomePage.setContent("");
        wikiHomePage.setSyntax(createdWiki.getPreferences().getWikiPreferencesSyntax().getDefaultSyntax());
        List<PermissionEntry> homePagePermissions = ajc$this.getWikiHomePageDefaultPermissions(wiki.getType(), wiki.getOwner());
        wikiHomePage.setPermissions(homePagePermissions);
        Page createdWikiHomePage = ajc$this.createPage(createdWiki, null, wikiHomePage);
        createdWiki.setWikiHome(createdWikiHomePage);
        return createdWiki;
    }

    static /* synthetic */ Page createPage_aroundBody2(JPADataStorage ajc$this, Wiki wiki, Page parentPage, Page page, JoinPoint joinPoint) {
        WikiEntity wikiEntity = ajc$this.wikiDAO.getWikiByTypeAndOwner(wiki.getType(), wiki.getOwner());
        if (wikiEntity == null) {
            throw new WikiException("Cannot create page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName() + " because wiki does not exist.");
        }
        PageEntity parentPageEntity = null;
        if (parentPage != null && (parentPageEntity = ajc$this.pageDAO.getPageOfWikiByName(wiki.getType(), wiki.getOwner(), parentPage.getName())) == null) {
            throw new WikiException("Cannot create page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName() + " because parent page " + parentPage.getName() + " does not exist.");
        }
        PageEntity pageEntity = EntityConverter.convertPageToPageEntity(page, ajc$this.wikiDAO);
        pageEntity.setWiki(wikiEntity);
        pageEntity.setParentPage(parentPageEntity);
        Date now = GregorianCalendar.getInstance().getTime();
        if (pageEntity.getCreatedDate() == null) {
            pageEntity.setCreatedDate(now);
        }
        if (pageEntity.getUpdatedDate() == null) {
            pageEntity.setUpdatedDate(now);
        }
        pageEntity.setDeleted(false);
        PageEntity createdPageEntity = (PageEntity)ajc$this.pageDAO.create(pageEntity);
        if (parentPage == null) {
            wikiEntity.setWikiHome(createdPageEntity);
            ajc$this.wikiDAO.update(wikiEntity);
        }
        return EntityConverter.convertPageEntityToPage(createdPageEntity);
    }

    static /* synthetic */ void deletePage_aroundBody4(JPADataStorage ajc$this, String wikiType, String wikiOwner, String pageName, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete page " + wikiType + ":" + wikiOwner + ":" + pageName + " because page does not exist.");
        }
        ajc$this.deletePageEntity(pageEntity);
    }

    static /* synthetic */ void renamePage_aroundBody6(JPADataStorage ajc$this, String wikiType, String wikiOwner, String pageName, String newName, String newTitle, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (pageEntity == null) {
            throw new WikiException("Cannot rename page " + wikiType + ":" + wikiOwner + ":" + pageName + " because page does not exist.");
        }
        List<PageMoveEntity> pageMoves = pageEntity.getMoves();
        if (pageMoves == null) {
            pageMoves = new ArrayList<PageMoveEntity>();
        }
        PageMoveEntity move = new PageMoveEntity(wikiType, wikiOwner, pageName, Calendar.getInstance().getTime());
        move.setPage(pageEntity);
        pageMoves.add(move);
        ajc$this.pageMoveDAO.create(move);
        pageEntity.setName(newName);
        pageEntity.setTitle(newTitle);
        pageEntity.setMoves(pageMoves);
        ajc$this.pageDAO.update(pageEntity);
    }

    static /* synthetic */ void movePage_aroundBody8(JPADataStorage ajc$this, WikiPageParams currentLocationParams, WikiPageParams newLocationParams, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
        if (pageEntity == null) {
            throw new WikiException("Cannot move page " + currentLocationParams.getType() + ":" + currentLocationParams.getOwner() + ":" + currentLocationParams.getPageName() + " because page does not exist.");
        }
        PageEntity destinationPageEntity = ajc$this.pageDAO.getPageOfWikiByName(newLocationParams.getType(), newLocationParams.getOwner(), newLocationParams.getPageName());
        if (destinationPageEntity == null) {
            throw new WikiException("Cannot move page " + currentLocationParams.getType() + ":" + currentLocationParams.getOwner() + ":" + currentLocationParams.getPageName() + " to page " + newLocationParams.getType() + ":" + newLocationParams.getOwner() + ":" + newLocationParams.getPageName() + " because destination page does not exist.");
        }
        List<PageMoveEntity> pageMoves = pageEntity.getMoves();
        if (pageMoves == null) {
            pageMoves = new ArrayList<PageMoveEntity>();
        }
        PageMoveEntity move = new PageMoveEntity(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName(), Calendar.getInstance().getTime());
        move.setPage(pageEntity);
        ajc$this.pageMoveDAO.create(move);
        pageEntity.setParentPage(destinationPageEntity);
        ajc$this.updateWikiOfPageTree(destinationPageEntity.getWiki(), pageEntity);
        pageMoves.add(move);
        pageEntity.setMoves(pageMoves);
        ajc$this.pageDAO.update(pageEntity);
    }

    static /* synthetic */ void addAttachmentToPage_aroundBody10(JPADataStorage ajc$this, Attachment attachment, Page page, JoinPoint joinPoint) {
        if (page.isDraftPage()) {
            DraftPageEntity draftPageEntity;
            DraftPageAttachmentEntity attachmentEntity = EntityConverter.convertAttachmentToDraftPageAttachmentEntity(ajc$this.fileService, attachment);
            Date now = GregorianCalendar.getInstance().getTime();
            if (attachmentEntity.getCreatedDate() == null) {
                attachmentEntity.setCreatedDate(now);
            }
            if ((draftPageEntity = ajc$this.draftPageDAO.findLatestDraftPageByUserAndName(Utils.getCurrentUser(), page.getName())) == null) {
                throw new WikiException("Cannot add an attachment to draft page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because draft page does not exist.");
            }
            attachmentEntity.setDraftPage(draftPageEntity);
            ajc$this.draftPageAttachmentDAO.create(attachmentEntity);
            List<DraftPageAttachmentEntity> attachmentsEntities = draftPageEntity.getAttachments();
            if (attachmentsEntities == null) {
                attachmentsEntities = new ArrayList<DraftPageAttachmentEntity>();
            }
            DraftPageAttachmentEntity draftPageAttachmentEntity = attachmentEntity;
            draftPageAttachmentEntity.setDraftPage(draftPageEntity);
            attachmentsEntities.add(draftPageAttachmentEntity);
            draftPageEntity.setAttachments(attachmentsEntities);
            ajc$this.draftPageDAO.update(draftPageEntity);
        } else {
            PageEntity pageEntity;
            PageAttachmentEntity attachmentEntity = EntityConverter.convertAttachmentToPageAttachmentEntity(ajc$this.fileService, attachment);
            Date now = GregorianCalendar.getInstance().getTime();
            if (attachmentEntity.getCreatedDate() == null) {
                attachmentEntity.setCreatedDate(now);
            }
            if ((pageEntity = ajc$this.fetchPageEntity(page)) == null) {
                throw new WikiException("Cannot add an attachment to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            attachmentEntity.setPage(pageEntity);
            ajc$this.pageAttachmentDAO.create(attachmentEntity);
            List<PageAttachmentEntity> attachmentsEntities = pageEntity.getAttachments();
            if (attachmentsEntities == null) {
                attachmentsEntities = new ArrayList<PageAttachmentEntity>();
            }
            PageAttachmentEntity pageAttachmentEntity = attachmentEntity;
            pageAttachmentEntity.setPage(pageEntity);
            attachmentsEntities.add(pageAttachmentEntity);
            pageEntity.setAttachments(attachmentsEntities);
            ajc$this.pageDAO.update(pageEntity);
        }
    }

    static /* synthetic */ void deleteAttachmentOfPage_aroundBody12(JPADataStorage ajc$this, String attachmentName, Page page, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.fetchPageEntity(page);
        DraftPageEntity draftPageEntity = null;
        if (pageEntity == null) {
            draftPageEntity = ajc$this.draftPageDAO.findLatestDraftPageByUserAndName(Utils.getCurrentUser(), page.getName());
        }
        if (pageEntity == null && draftPageEntity == null) {
            throw new WikiException("Cannot delete an attachment of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        boolean attachmentFound = false;
        attachmentFound = pageEntity == null && draftPageEntity != null ? ajc$this.deleteDraftPageAttachementEntity(attachmentName, draftPageEntity, attachmentFound) : ajc$this.deletePageAttachementEntity(attachmentName, pageEntity, attachmentFound);
        if (!attachmentFound) {
            throw new WikiException("Cannot delete the attachment " + attachmentName + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because attachment does not exist.");
        }
    }

    static /* synthetic */ void addPageVersion_aroundBody14(JPADataStorage ajc$this, Page page, String userName, JoinPoint joinPoint) {
        List<PageVersionEntity> pageVersionEntities;
        PageVersionEntity pageVersionEntity;
        PageEntity pageEntity;
        if (page != null) {
            pageEntity = ajc$this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot add version of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            pageVersionEntity = new PageVersionEntity();
            Long versionNumber = ajc$this.pageVersionDAO.getLastversionNumberOfPage(pageEntity.getId());
            versionNumber = versionNumber == null ? Long.valueOf(1L) : Long.valueOf(versionNumber + 1L);
            pageVersionEntity.setPage(pageEntity);
            pageVersionEntity.setVersionNumber(versionNumber);
            pageVersionEntity.setName(page.getName());
            pageVersionEntity.setTitle(page.getTitle());
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                pageVersionEntity.setAuthor(userName);
            } else {
                pageVersionEntity.setAuthor(pageEntity.getAuthor());
            }
            pageVersionEntity.setContent(page.getContent());
            pageVersionEntity.setSyntax(pageEntity.getSyntax());
            pageVersionEntity.setMinorEdit(pageEntity.isMinorEdit());
            pageVersionEntity.setComment(pageEntity.getComment());
            Date now = Calendar.getInstance().getTime();
            pageVersionEntity.setCreatedDate(now);
            pageVersionEntity.setUpdatedDate(now);
            pageVersionEntity.setLang(page.getLang());
            ajc$this.pageVersionDAO.create(pageVersionEntity);
            pageVersionEntities = pageEntity.getVersions();
            if (pageVersionEntities == null) {
                pageVersionEntities = new ArrayList<PageVersionEntity>();
            }
        } else {
            throw new WikiException("Cannot create version of a page null");
        }
        pageVersionEntities.add(pageVersionEntity);
        pageEntity.setVersions(pageVersionEntities);
        ajc$this.pageDAO.update(pageEntity);
    }

    static /* synthetic */ Page updatePage_aroundBody16(JPADataStorage ajc$this, Page page, JoinPoint joinPoint) {
        if (page.isDraftPage()) {
            DraftPageEntity draftPageEntity = ajc$this.draftPageDAO.findLatestDraftPageByUserAndName(page.getAuthor(), page.getName());
            if (draftPageEntity == null) {
                throw new WikiException("Cannot add an attachment to draft page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because draft page does not exist.");
            }
            draftPageEntity.setTitle(page.getTitle());
            draftPageEntity.setContent(page.getContent());
            draftPageEntity.setUpdatedDate(page.getUpdatedDate());
            return EntityConverter.convertDraftPageEntityToDraftPage((DraftPageEntity)ajc$this.draftPageDAO.update(draftPageEntity));
        }
        PageEntity pageEntity = ajc$this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot update page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        pageEntity.setName(page.getName());
        pageEntity.setTitle(page.getTitle());
        pageEntity.setAuthor(page.getAuthor());
        pageEntity.setContent(page.getContent());
        pageEntity.setSyntax(page.getSyntax());
        pageEntity.setCreatedDate(page.getCreatedDate());
        pageEntity.setUpdatedDate(page.getUpdatedDate());
        pageEntity.setMinorEdit(page.isMinorEdit());
        pageEntity.setComment(page.getComment());
        pageEntity.setUrl(page.getUrl());
        pageEntity.setPermissions(EntityConverter.convertPermissionEntriesToPermissionEntities(page.getPermissions()));
        pageEntity.setActivityId(page.getActivityId());
        return EntityConverter.convertPageEntityToPage((PageEntity)ajc$this.pageDAO.update(pageEntity));
    }

    static /* synthetic */ void deleteAttachmentsOfDraftPage_aroundBody18(JPADataStorage ajc$this, DraftPageEntity page, JoinPoint joinPoint) {
        List<DraftPageAttachmentEntity> attachmentsEntities = page.getAttachments();
        if (attachmentsEntities != null) {
            for (int i = 0; i < attachmentsEntities.size(); ++i) {
                AttachmentEntity attachmentEntity = attachmentsEntities.get(i);
                attachmentsEntities.remove(i);
                ajc$this.fileService.deleteFile(attachmentEntity.getAttachmentFileID().longValue());
                ajc$this.draftPageAttachmentDAO.delete((DraftPageAttachmentEntity)attachmentEntity);
            }
            page.setAttachments(attachmentsEntities);
            ajc$this.draftPageDAO.update(page);
        }
    }

    static /* synthetic */ void deleteVersionsByNoteIdAndLang_aroundBody20(JPADataStorage ajc$this, Long noteId, String lang, JoinPoint joinPoint) {
        if (noteId == null) {
            throw new IllegalArgumentException("noteId argument is null");
        }
        PageEntity pageEntity = (PageEntity)ajc$this.pageDAO.find(noteId);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete versions of page with: " + noteId + "for language:" + lang + " because page does not exist.");
        }
        List<PageVersionEntity> history = ajc$this.pageVersionDAO.findPageVersionsByPageIdAndLang(noteId, lang);
        ajc$this.pageVersionDAO.deleteAll(history);
        history = pageEntity.getVersions();
        history.removeIf(version -> StringUtils.isNotEmpty((CharSequence)version.getLang()) && version.getLang().equals(lang));
        pageEntity.setVersions(history);
        ajc$this.pageDAO.update(pageEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPADataStorage.java", JPADataStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWiki", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.model.Wiki", WIKI_FILES_NAMESPACE_NAME, "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.model.Wiki"), 158);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createPage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.model.Wiki:org.exoplatform.wiki.model.Page:org.exoplatform.wiki.model.Page", "wiki:parentPage:page", "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.model.Page"), 186);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteVersionsByNoteIdAndLang", "org.exoplatform.wiki.jpa.JPADataStorage", "java.lang.Long:java.lang.String", "noteId:lang", "org.exoplatform.wiki.WikiException", "void"), 1527);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePage", "org.exoplatform.wiki.jpa.JPADataStorage", "java.lang.String:java.lang.String:java.lang.String", "wikiType:wikiOwner:pageName", "org.exoplatform.wiki.WikiException", "void"), 303);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "renamePage", "org.exoplatform.wiki.jpa.JPADataStorage", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "wikiType:wikiOwner:pageName:newName:newTitle", "org.exoplatform.wiki.WikiException", "void"), 366);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "movePage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.service.WikiPageParams:org.exoplatform.wiki.service.WikiPageParams", "currentLocationParams:newLocationParams", "org.exoplatform.wiki.WikiException", "void"), 393);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addAttachmentToPage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.model.Attachment:org.exoplatform.wiki.model.Page", "attachment:page", "org.exoplatform.wiki.WikiException", "void"), 824);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAttachmentOfPage", "org.exoplatform.wiki.jpa.JPADataStorage", "java.lang.String:org.exoplatform.wiki.model.Page", "attachmentName:page", "org.exoplatform.wiki.WikiException", "void"), 888);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPageVersion", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.model.Page:java.lang.String", "page:userName", "org.exoplatform.wiki.WikiException", "void"), 1124);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updatePage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.model.Page", "page", "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.model.Page"), 1202);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAttachmentsOfDraftPage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.jpa.entity.DraftPageEntity", "page", "org.exoplatform.wiki.WikiException", "void"), 1309);
    }
}

