/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.PhraseSuggestOption;
import co.elastic.clients.elasticsearch.core.search.SuggestBase;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.elasticsearch.core.search.SuggestionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PhraseSuggest
extends SuggestBase
implements SuggestionVariant {
    private final List<PhraseSuggestOption> options;
    public static final JsonpDeserializer<PhraseSuggest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PhraseSuggest::setupPhraseSuggestDeserializer);

    private PhraseSuggest(Builder builder) {
        super(builder);
        this.options = ApiTypeHelper.unmodifiableRequired(builder.options, (Object)this, "options");
    }

    public static PhraseSuggest of(Function<Builder, ObjectBuilder<PhraseSuggest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Suggestion.Kind _suggestionKind() {
        return Suggestion.Kind.Phrase;
    }

    public final List<PhraseSuggestOption> options() {
        return this.options;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartArray();
            for (PhraseSuggestOption item0 : this.options) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPhraseSuggestDeserializer(ObjectDeserializer<Builder> op) {
        SuggestBase.setupSuggestBaseDeserializer(op);
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(PhraseSuggestOption._DESERIALIZER), "options");
    }

    public static class Builder
    extends SuggestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PhraseSuggest> {
        private List<PhraseSuggestOption> options;

        public final Builder options(List<PhraseSuggestOption> list) {
            this.options = Builder._listAddAll(this.options, list);
            return this;
        }

        public final Builder options(PhraseSuggestOption value, PhraseSuggestOption ... values) {
            this.options = Builder._listAdd(this.options, value, values);
            return this;
        }

        public final Builder options(Function<PhraseSuggestOption.Builder, ObjectBuilder<PhraseSuggestOption>> fn) {
            return this.options(fn.apply(new PhraseSuggestOption.Builder()).build(), new PhraseSuggestOption[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PhraseSuggest build() {
            this._checkSingleUse();
            return new PhraseSuggest(this);
        }
    }
}

