/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.model.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.filter.AbstractAnalyticsFilter;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregationType;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilter;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilterType;

public class AnalyticsFilter
extends AbstractAnalyticsFilter {
    private static final long serialVersionUID = 5699550622069979910L;
    private String chartType;
    private List<String> colors;
    private List<AnalyticsFieldFilter> filters = new ArrayList<AnalyticsFieldFilter>();
    private String multipleChartsField = null;
    private List<AnalyticsAggregation> xAxisAggregations = new ArrayList<AnalyticsAggregation>();
    private AnalyticsAggregation yAxisAggregation = null;
    private String lang = null;
    private long offset = 0L;
    private long limit = 0L;

    public AnalyticsFilter(String title, String timeZone, String chartType, List<String> colors, List<AnalyticsFieldFilter> cloneFilters, String multipleChartsField, List<AnalyticsAggregation> cloneXAggs, AnalyticsAggregation cloneyAggregation, String lang, long offset, long limit) {
        this(chartType, colors, cloneFilters, multipleChartsField, cloneXAggs, cloneyAggregation, lang, offset, limit);
        this.setTitle(title);
        this.setTimeZone(timeZone);
    }

    public AnalyticsFilter(String title, String chartType, List<String> colors, List<AnalyticsFieldFilter> cloneFilters, String multipleChartsField, List<AnalyticsAggregation> cloneXAggs, AnalyticsAggregation cloneyAggregation, String lang, long offset, long limit) {
        this(chartType, colors, cloneFilters, multipleChartsField, cloneXAggs, cloneyAggregation, lang, offset, limit);
        this.setTitle(title);
    }

    public List<AnalyticsAggregation> getAggregations() {
        AnalyticsAggregation lastAggregation;
        ArrayList<AnalyticsAggregation> aggregations = new ArrayList<AnalyticsAggregation>();
        AnalyticsAggregation multipleChartsAggregation = this.getMultipleChartsAggregation();
        if (multipleChartsAggregation != null) {
            if (multipleChartsAggregation.getType() == AnalyticsAggregationType.COUNT) {
                multipleChartsAggregation.setType(AnalyticsAggregationType.TERMS);
            }
            aggregations.add(multipleChartsAggregation);
        }
        for (AnalyticsAggregation analyticsAggregation : this.xAxisAggregations) {
            if (analyticsAggregation.getType() != AnalyticsAggregationType.COUNT) continue;
            analyticsAggregation.setType(AnalyticsAggregationType.TERMS);
        }
        aggregations.addAll(this.xAxisAggregations);
        AnalyticsAggregation analyticsAggregation = lastAggregation = aggregations.isEmpty() ? null : (AnalyticsAggregation)aggregations.get(aggregations.size() - 1);
        if (this.yAxisAggregation != null) {
            if (lastAggregation != null && StringUtils.isBlank((CharSequence)this.yAxisAggregation.getField())) {
                this.yAxisAggregation.setField(lastAggregation.getField());
                this.yAxisAggregation.setType(AnalyticsAggregationType.COUNT);
            }
            aggregations.add(this.yAxisAggregation);
        }
        return Collections.unmodifiableList(aggregations);
    }

    public AnalyticsAggregation getMultipleChartsAggregation() {
        if (this.isMultipleCharts()) {
            return new AnalyticsAggregation(this.multipleChartsField);
        }
        return null;
    }

    public void addXAxisAggregation(AnalyticsAggregation aggregation) {
        this.xAxisAggregations.add(aggregation);
    }

    public boolean isMultipleCharts() {
        return StringUtils.isNotBlank((CharSequence)this.multipleChartsField);
    }

    public void addNotEqualFilter(String field, String value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.NOT_EQUAL, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public void addEqualFilter(String field, String value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.EQUAL, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public void addInSetFilter(String field, String ... values) {
        if (values != null && values.length > 0) {
            AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.IN_SET, StringUtils.join((Object[])values, (String)","));
            this.filters.add(fieldFilter);
        }
    }

    public void addNotInSetFilter(String field, String ... values) {
        if (values != null && values.length > 0) {
            AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.NOT_IN_SET, StringUtils.join((Object[])values, (String)","));
            this.filters.add(fieldFilter);
        }
    }

    public void addRangeFilter(String field, String start, String end) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.RANGE, new Range(start, end));
        this.filters.add(fieldFilter);
    }

    public void addGreaterFilter(String field, long value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.GREATER, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public void addLessFilter(String field, long value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.LESS, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public AnalyticsFilter clone() {
        List<AnalyticsFieldFilter> cloneFilters = new ArrayList<AnalyticsFieldFilter>(this.filters).stream().map(AnalyticsFieldFilter::clone).collect(Collectors.toList());
        List<AnalyticsAggregation> cloneXAggs = new ArrayList<AnalyticsAggregation>(this.xAxisAggregations).stream().map(AnalyticsAggregation::clone).collect(Collectors.toList());
        AnalyticsAggregation cloneyAggregation = this.yAxisAggregation == null ? null : this.yAxisAggregation.clone();
        return new AnalyticsFilter(this.getTitle(), this.getTimeZone(), this.chartType, this.colors, cloneFilters, this.multipleChartsField, cloneXAggs, cloneyAggregation, this.lang, this.offset, this.limit);
    }

    public String getChartType() {
        return this.chartType;
    }

    public List<String> getColors() {
        return this.colors;
    }

    public List<AnalyticsFieldFilter> getFilters() {
        return this.filters;
    }

    public String getMultipleChartsField() {
        return this.multipleChartsField;
    }

    public List<AnalyticsAggregation> getXAxisAggregations() {
        return this.xAxisAggregations;
    }

    public AnalyticsAggregation getYAxisAggregation() {
        return this.yAxisAggregation;
    }

    public String getLang() {
        return this.lang;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    public void setFilters(List<AnalyticsFieldFilter> filters) {
        this.filters = filters;
    }

    public void setMultipleChartsField(String multipleChartsField) {
        this.multipleChartsField = multipleChartsField;
    }

    public void setXAxisAggregations(List<AnalyticsAggregation> xAxisAggregations) {
        this.xAxisAggregations = xAxisAggregations;
    }

    public void setYAxisAggregation(AnalyticsAggregation yAxisAggregation) {
        this.yAxisAggregation = yAxisAggregation;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public String toString() {
        return "AnalyticsFilter(super=" + super.toString() + ", chartType=" + this.getChartType() + ", colors=" + String.valueOf(this.getColors()) + ", filters=" + String.valueOf(this.getFilters()) + ", multipleChartsField=" + this.getMultipleChartsField() + ", xAxisAggregations=" + String.valueOf(this.getXAxisAggregations()) + ", yAxisAggregation=" + String.valueOf(this.getYAxisAggregation()) + ", lang=" + this.getLang() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsFilter)) {
            return false;
        }
        AnalyticsFilter other = (AnalyticsFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        String this$chartType = this.getChartType();
        String other$chartType = other.getChartType();
        if (this$chartType == null ? other$chartType != null : !this$chartType.equals(other$chartType)) {
            return false;
        }
        List<String> this$colors = this.getColors();
        List<String> other$colors = other.getColors();
        if (this$colors == null ? other$colors != null : !((Object)this$colors).equals(other$colors)) {
            return false;
        }
        List<AnalyticsFieldFilter> this$filters = this.getFilters();
        List<AnalyticsFieldFilter> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        String this$multipleChartsField = this.getMultipleChartsField();
        String other$multipleChartsField = other.getMultipleChartsField();
        if (this$multipleChartsField == null ? other$multipleChartsField != null : !this$multipleChartsField.equals(other$multipleChartsField)) {
            return false;
        }
        List<AnalyticsAggregation> this$xAxisAggregations = this.getXAxisAggregations();
        List<AnalyticsAggregation> other$xAxisAggregations = other.getXAxisAggregations();
        if (this$xAxisAggregations == null ? other$xAxisAggregations != null : !((Object)this$xAxisAggregations).equals(other$xAxisAggregations)) {
            return false;
        }
        AnalyticsAggregation this$yAxisAggregation = this.getYAxisAggregation();
        AnalyticsAggregation other$yAxisAggregation = other.getYAxisAggregation();
        if (this$yAxisAggregation == null ? other$yAxisAggregation != null : !((Object)this$yAxisAggregation).equals(other$yAxisAggregation)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        return !(this$lang == null ? other$lang != null : !this$lang.equals(other$lang));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        String $chartType = this.getChartType();
        result = result * 59 + ($chartType == null ? 43 : $chartType.hashCode());
        List<String> $colors = this.getColors();
        result = result * 59 + ($colors == null ? 43 : ((Object)$colors).hashCode());
        List<AnalyticsFieldFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        String $multipleChartsField = this.getMultipleChartsField();
        result = result * 59 + ($multipleChartsField == null ? 43 : $multipleChartsField.hashCode());
        List<AnalyticsAggregation> $xAxisAggregations = this.getXAxisAggregations();
        result = result * 59 + ($xAxisAggregations == null ? 43 : ((Object)$xAxisAggregations).hashCode());
        AnalyticsAggregation $yAxisAggregation = this.getYAxisAggregation();
        result = result * 59 + ($yAxisAggregation == null ? 43 : ((Object)$yAxisAggregation).hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        return result;
    }

    public AnalyticsFilter() {
    }

    public AnalyticsFilter(String chartType, List<String> colors, List<AnalyticsFieldFilter> filters, String multipleChartsField, List<AnalyticsAggregation> xAxisAggregations, AnalyticsAggregation yAxisAggregation, String lang, long offset, long limit) {
        this.chartType = chartType;
        this.colors = colors;
        this.filters = filters;
        this.multipleChartsField = multipleChartsField;
        this.xAxisAggregations = xAxisAggregations;
        this.yAxisAggregation = yAxisAggregation;
        this.lang = lang;
        this.offset = offset;
        this.limit = limit;
    }

    public static class Range
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 570632355720481459L;
        private String min;
        private String max;

        public Range(long min, long max) {
            this.min = String.valueOf(min);
            this.max = String.valueOf(max);
        }

        public Range clone() {
            return new Range(this.min, this.max);
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public void setMin(String min) {
            this.min = min;
        }

        public void setMax(String max) {
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$min = this.getMin();
            String other$min = other.getMin();
            if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
                return false;
            }
            String this$max = this.getMax();
            String other$max = other.getMax();
            return !(this$max == null ? other$max != null : !this$max.equals(other$max));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Range;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : $min.hashCode());
            String $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : $max.hashCode());
            return result;
        }

        public String toString() {
            return "AnalyticsFilter.Range(min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }

        public Range() {
        }

        public Range(String min, String max) {
            this.min = min;
            this.max = max;
        }
    }
}

