/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.rest.provider.EntityProvider;

@Provider
@Consumes(value={"application/xml", "text/xml", "application/xhtml+xml"})
@Produces(value={"application/xml", "text/xml", "application/xhtml+xml"})
public class StreamSourceEntityProvider
implements EntityProvider<StreamSource> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == StreamSource.class;
    }

    public StreamSource readFrom(Class<StreamSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return new StreamSource(entityStream);
    }

    public long getSize(StreamSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return StreamSource.class.isAssignableFrom(type);
    }

    public void writeTo(StreamSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        StreamResult out = new StreamResult(entityStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(t, out);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Can't write to output stream " + String.valueOf(e), e);
        }
        catch (TransformerException e) {
            throw new IOException("Can't write to output stream " + String.valueOf(e), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IOException("Can't write to output stream " + String.valueOf(e), e);
        }
    }
}

