/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.remoting.transport.Address;

public class DistributedExecutionCompletionService<V>
implements CompletionService<V> {
    protected final DistributedExecutorService executor;
    protected final BlockingQueue<NotifyingFuture<V>> completionQueue;
    protected final QueueingListener listener;

    public DistributedExecutionCompletionService(DistributedExecutorService executor) {
        this(executor, null);
    }

    public DistributedExecutionCompletionService(DistributedExecutorService executor, BlockingQueue<NotifyingFuture<V>> completionQueue) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue == null ? new LinkedBlockingQueue<NotifyingFuture<V>>() : completionQueue;
        this.listener = new QueueingListener();
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        NotifyingFuture f = (NotifyingFuture)this.executor.submit(task);
        f.attachListener((FutureListener)this.listener);
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        NotifyingFuture f = (NotifyingFuture)this.executor.submit(task, result);
        f.attachListener((FutureListener)this.listener);
        return f;
    }

    @Override
    public NotifyingFuture<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public NotifyingFuture<V> poll() {
        return (NotifyingFuture)this.completionQueue.poll();
    }

    @Override
    public NotifyingFuture<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    public <K> Future<V> submit(Callable<V> task, K ... input) {
        NotifyingFuture<V> f = this.executor.submit(task, input);
        f.attachListener((FutureListener)this.listener);
        return f;
    }

    public List<Future<V>> submitEverywhere(Callable<V> task) {
        List<Future<V>> fl = this.executor.submitEverywhere(task);
        for (Future<V> f : fl) {
            ((NotifyingFuture)f).attachListener((FutureListener)this.listener);
        }
        return fl;
    }

    public <K> List<Future<V>> submitEverywhere(Callable<V> task, K ... input) {
        List<Future<V>> fl = this.executor.submitEverywhere(task, input);
        for (Future<V> f : fl) {
            ((NotifyingFuture)f).attachListener((FutureListener)this.listener);
        }
        return fl;
    }

    public <K> Future<V> submit(Address target, Callable<V> task) {
        NotifyingFuture<V> f = this.executor.submit(target, task);
        f.attachListener((FutureListener)this.listener);
        return f;
    }

    protected class QueueingListener
    implements FutureListener<V> {
        protected QueueingListener() {
        }

        public void futureDone(Future<V> future) {
            DistributedExecutionCompletionService.this.completionQueue.add((NotifyingFuture)future);
        }
    }
}

