/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.annotation.Table;

public class DBObjectQuery<T extends DBObject> {
    private static DateTimeFormatter ft_ = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private Class<? extends DBObject> type_;
    private String orderBy_;
    private String groupBy_;
    private List<Parameter> parameters_;
    private List<Parameter> selectParameter_;

    public DBObjectQuery(Class<T> type) {
        this.type_ = type;
        this.parameters_ = new ArrayList<Parameter>(3);
        this.selectParameter_ = new ArrayList<Parameter>(10);
    }

    public DBObjectQuery<T> addEQ(String field, Object value) {
        if (value == null) {
            return this;
        }
        this.parameters_.add(new Parameter(field, " = ", value));
        return this;
    }

    public DBObjectQuery<T> addGT(String field, Object value) {
        if (value == null) {
            return this;
        }
        this.parameters_.add(new Parameter(field, " > ", value));
        return this;
    }

    public DBObjectQuery<T> addLT(String field, Object value) {
        if (value == null) {
            return this;
        }
        this.parameters_.add(new Parameter(field, " < ", value));
        return this;
    }

    public DBObjectQuery<T> addLIKE(String field, String value) {
        if (value == null || value.length() < 1) {
            return this;
        }
        this.parameters_.add(new Parameter(field, " LIKE ", this.optimizeInputString(value)));
        return this;
    }

    public DBObjectQuery<T> addSUM(String field) {
        this.selectParameter_.add(new Parameter("SUM", field));
        return this;
    }

    public DBObjectQuery<T> addSelect(String field, String value) {
        this.selectParameter_.add(new Parameter(field, " AS ", value));
        return this;
    }

    public DBObjectQuery<T> addSelect(String ... fields) {
        for (String field : fields) {
            this.selectParameter_.add(new Parameter(field, null, null));
        }
        return this;
    }

    public DBObjectQuery<T> addSelect(String field) {
        this.selectParameter_.add(new Parameter(field, null, null));
        return this;
    }

    public DBObjectQuery<T> addSelectCount(String type) {
        this.selectParameter_.add(new Parameter("countselect", type));
        return this;
    }

    public DBObjectQuery<T> addSelectMaxMin(String op, String field) {
        this.selectParameter_.add(new Parameter(op, field));
        return this;
    }

    public DBObjectQuery<T> setAscOrderBy(String field) {
        this.orderBy_ = " ORDER BY " + field + " ASC";
        return this;
    }

    public DBObjectQuery<T> setDescOrderBy(String field) {
        this.orderBy_ = " ORDER BY " + field + " DESC";
        return this;
    }

    public DBObjectQuery setGroupBy(String field) {
        this.groupBy_ = " GROUP BY " + field;
        return this;
    }

    public String toQuery() {
        return this.constuctQuery(false);
    }

    public String toQueryUseOR() {
        return this.constuctQuery(true);
    }

    private String constuctQuery(boolean useOR) {
        StringBuilder builder = new StringBuilder("SELECT ");
        if (this.selectParameter_.size() > 0) {
            for (int i = 0; i < this.selectParameter_.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.parameters_.get(i).build(builder);
            }
        } else {
            builder.append(" * ");
        }
        Table table = this.type_.getAnnotation(Table.class);
        builder.append(" FROM ").append(table.name());
        if (this.parameters_.size() > 0) {
            builder.append(" WHERE ");
            for (int i = 0; i < this.parameters_.size(); ++i) {
                if (i > 0) {
                    builder.append(useOR ? " OR " : " AND ");
                }
                this.parameters_.get(i).build(builder);
            }
        }
        if (this.orderBy_ != null) {
            builder.append(this.orderBy_);
        }
        return builder.toString();
    }

    public String toCountQuery() {
        return this.consturctCountQuery(false);
    }

    public String toCountQueryUseOR() {
        return this.consturctCountQuery(true);
    }

    private String consturctCountQuery(boolean useOR) {
        StringBuilder builder = new StringBuilder();
        Table table = this.type_.getAnnotation(Table.class);
        builder.append("SELECT COUNT(*) FROM  ").append(table.name());
        if (this.parameters_.size() > 0) {
            builder.append(" WHERE ");
            for (int i = 0; i < this.parameters_.size(); ++i) {
                if (i > 0) {
                    builder.append(useOR ? " OR " : " AND ");
                }
                this.parameters_.get(i).build(builder);
            }
        }
        return builder.toString();
    }

    public String optimizeInputString(String value) {
        value = value.replace('*', '%');
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("<", "&#60;");
        value = value.replaceAll(">", "&#62;");
        return value;
    }

    public List<Parameter> getParameters() {
        return this.parameters_;
    }

    public static class Parameter {
        String op_;
        String field_;
        String label_;
        Object value_;

        public Parameter(String field, String op, Object value) {
            this.op_ = op;
            this.field_ = field;
            this.value_ = value;
        }

        public Parameter(String op, String field) {
            this.op_ = op;
            this.field_ = field;
        }

        void build(StringBuilder builder) {
            builder.append(' ').append(this.field_).append(this.op_);
            if (this.op_ == null || this.op_.trim().length() < 1 || this.value_ == null) {
                return;
            }
            builder.append(' ');
            if (CharSequence.class.isInstance(this.value_)) {
                builder.append('\'').append(this.value_).append('\'');
            } else if (this.value_ instanceof Date) {
                LocalDateTime ldt = LocalDateTime.ofInstant(((Date)this.value_).toInstant(), ZoneId.systemDefault());
                String value = ldt.format(ft_);
                builder.append("'").append(value).append("'");
            } else {
                builder.append(this.value_);
            }
        }
    }
}

