/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.PortletDescriptor;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletService;
import io.meeds.layout.storage.PortletInstanceCategoryStorage;
import io.meeds.layout.storage.PortletInstanceLayoutStorage;
import io.meeds.layout.storage.PortletInstanceStorage;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortletInstanceService {
    public static final String INSTANCE_CREATED_EVENT = "layout.portletInstance.created";
    public static final String INSTANCE_UPDATED_EVENT = "layout.portletInstance.updated";
    public static final String INSTANCE_DELETED_EVENT = "layout.portletInstance.deleted";
    public static final String CATEGORY_CREATED_EVENT = "layout.portletInstanceCategory.created";
    public static final String CATEGORY_UPDATED_EVENT = "layout.portletInstanceCategory.updated";
    public static final String CATEGORY_DELETED_EVENT = "layout.portletInstanceCategory.deleted";
    private static final List<String> EVERYONE_PERMISSIONS_LIST = Collections.singletonList("Everyone");
    private static final Log LOG = ExoLogger.getLogger(PortletInstanceService.class);
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private PortletInstanceCategoryStorage portletInstanceCategoryStorage;
    @Autowired
    private PortletInstanceStorage portletInstanceStorage;
    @Autowired
    private PortletInstanceLayoutStorage portletInstanceLayoutStorage;
    @Autowired
    private PortletService portletService;
    @Autowired
    private ListenerService listenerService;
    private Map<String, PortletInstancePreferencePlugin> preferencePlugins = new ConcurrentHashMap<String, PortletInstancePreferencePlugin>();

    public void addPortletInstancePreferencePlugin(PortletInstancePreferencePlugin plugin) {
        this.preferencePlugins.put(plugin.getPortletName(), plugin);
    }

    public void removePortletInstancePreferencePlugin(String portletName) {
        this.preferencePlugins.remove(portletName);
    }

    public List<PortletInstance> getPortletInstances(long categoryId, String username, Locale locale, boolean expand) {
        List<PortletInstance> portletInstances = categoryId < 1L ? this.portletInstanceStorage.getPortletInstances() : this.portletInstanceStorage.getPortletInstances(categoryId);
        portletInstances = portletInstances.stream().filter(p -> this.hasPermission((PortletInstance)p, username)).toList();
        if (expand) {
            portletInstances.stream().forEach(portletInstance -> this.computePortletInstanceAttributes(locale, (PortletInstance)portletInstance));
        }
        return portletInstances;
    }

    public List<PortletInstanceCategory> getPortletInstanceCategories() {
        return this.portletInstanceCategoryStorage.getPortletInstanceCategories();
    }

    public List<PortletInstanceCategory> getPortletInstanceCategories(String username, Locale locale, boolean expand) {
        List<PortletInstanceCategory> portletInstanceCategories = this.portletInstanceCategoryStorage.getPortletInstanceCategories();
        portletInstanceCategories = portletInstanceCategories.stream().filter(c -> this.hasPermission((PortletInstanceCategory)c, username)).toList();
        if (expand && locale != null) {
            portletInstanceCategories.stream().forEach(c -> this.computePortletInstanceCategoryAttributes(locale, (PortletInstanceCategory)c));
        }
        return portletInstanceCategories;
    }

    public PortletInstance getPortletInstance(long id, String username, Locale locale, boolean expand) throws IllegalAccessException, ObjectNotFoundException {
        PortletInstance portletInstance = this.portletInstanceStorage.getPortletInstance(id);
        if (portletInstance == null) {
            throw new ObjectNotFoundException("Portlet instance not found");
        }
        if (!this.hasPermission(portletInstance, username)) {
            throw new IllegalAccessException();
        }
        if (expand && locale != null) {
            this.computePortletInstanceAttributes(locale, portletInstance);
        }
        return portletInstance;
    }

    public PortletInstanceCategory getPortletInstanceCategory(long id) {
        return this.portletInstanceCategoryStorage.getPortletInstanceCategory(id);
    }

    public PortletInstanceCategory getPortletInstanceCategory(long id, String username, Locale locale, boolean expand) throws ObjectNotFoundException, IllegalAccessException {
        PortletInstanceCategory portletInstanceCategory = this.portletInstanceCategoryStorage.getPortletInstanceCategory(id);
        if (portletInstanceCategory == null) {
            throw new ObjectNotFoundException("Portlet instance category not found");
        }
        if (!this.hasPermission(portletInstanceCategory, username)) {
            throw new IllegalAccessException();
        }
        if (expand) {
            this.computePortletInstanceCategoryAttributes(locale, portletInstanceCategory);
        }
        return portletInstanceCategory;
    }

    public PortletInstance getPortletInstance(long id) {
        return this.portletInstanceStorage.getPortletInstance(id);
    }

    public PortletInstance createPortletInstance(PortletInstance portletInstance, String username) throws IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to create a Portlet instance");
        }
        PortletInstance createdPortletInstance = this.portletInstanceStorage.createPortletInstance(portletInstance);
        this.listenerService.broadcast(INSTANCE_CREATED_EVENT, (Object)username, (Object)createdPortletInstance);
        return createdPortletInstance;
    }

    public PortletInstance createPortletInstance(PortletInstance portletInstance) {
        PortletInstance createdPortletInstance = this.portletInstanceStorage.createPortletInstance(portletInstance);
        this.listenerService.broadcast(INSTANCE_CREATED_EVENT, null, (Object)createdPortletInstance);
        return createdPortletInstance;
    }

    public PortletInstanceCategory createPortletInstanceCategory(PortletInstanceCategory portletInstanceCategory, String username) throws IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to create a Portlet instance Category");
        }
        PortletInstanceCategory createdPortletInstanceCategory = this.portletInstanceCategoryStorage.createPortletInstanceCategory(portletInstanceCategory);
        this.listenerService.broadcast(CATEGORY_CREATED_EVENT, (Object)username, (Object)createdPortletInstanceCategory);
        return createdPortletInstanceCategory;
    }

    public PortletInstanceCategory createPortletInstanceCategory(PortletInstanceCategory category) {
        PortletInstanceCategory createdPortletInstanceCategory = this.portletInstanceCategoryStorage.createPortletInstanceCategory(category);
        this.listenerService.broadcast(CATEGORY_CREATED_EVENT, null, (Object)createdPortletInstanceCategory);
        return createdPortletInstanceCategory;
    }

    public void deletePortletInstance(long id, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to delete a Portlet instance");
        }
        PortletInstance portletInstance = this.getPortletInstance(id);
        if (portletInstance == null) {
            throw new ObjectNotFoundException("Portlet instance doesn't exist");
        }
        if (portletInstance.isSystem()) {
            throw new IllegalAccessException("Can't delete a system Portlet instance");
        }
        this.deletePortletInstanceFromStore(id);
        this.listenerService.broadcast(INSTANCE_DELETED_EVENT, (Object)username, (Object)portletInstance);
    }

    public void deletePortletInstance(long id) throws ObjectNotFoundException {
        PortletInstance portletInstance = this.getPortletInstance(id);
        if (portletInstance == null) {
            throw new ObjectNotFoundException("Portlet instance doesn't exist");
        }
        this.deletePortletInstanceFromStore(id);
        this.listenerService.broadcast(INSTANCE_DELETED_EVENT, null, (Object)portletInstance);
    }

    public void deletePortletInstanceCategory(long id, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to create a Portlet instance Category");
        }
        PortletInstanceCategory portletInstanceCategory = this.getPortletInstanceCategory(id);
        if (portletInstanceCategory == null) {
            throw new ObjectNotFoundException("Portlet instance Category doesn't exist");
        }
        if (portletInstanceCategory.isSystem()) {
            throw new IllegalAccessException("Can't delete a system Portlet instance Category");
        }
        this.deletePortletInstanceCategoryFromStore(id);
        this.listenerService.broadcast(CATEGORY_DELETED_EVENT, (Object)username, (Object)portletInstanceCategory);
    }

    public void deletePortletInstanceCategory(long id) throws ObjectNotFoundException {
        PortletInstanceCategory portletInstanceCategory = this.getPortletInstanceCategory(id);
        if (portletInstanceCategory == null) {
            throw new ObjectNotFoundException("Portlet instance Category doesn't exist");
        }
        this.deletePortletInstanceCategoryFromStore(id);
        this.listenerService.broadcast(CATEGORY_DELETED_EVENT, null, (Object)portletInstanceCategory);
    }

    public PortletInstance updatePortletInstance(PortletInstance portletInstance, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to update a Portlet instance");
        }
        PortletInstance updatedPortletInstance = this.portletInstanceStorage.updatePortletInstance(portletInstance);
        this.listenerService.broadcast(INSTANCE_UPDATED_EVENT, (Object)username, (Object)updatedPortletInstance);
        return updatedPortletInstance;
    }

    public PortletInstance updatePortletInstance(PortletInstance portletInstance) throws ObjectNotFoundException {
        PortletInstance updatedPortletInstance = this.portletInstanceStorage.updatePortletInstance(portletInstance);
        this.listenerService.broadcast(INSTANCE_UPDATED_EVENT, null, (Object)updatedPortletInstance);
        return updatedPortletInstance;
    }

    public PortletInstanceCategory updatePortletInstanceCategory(PortletInstanceCategory portletInstanceCategory, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to update a Portlet instance category");
        }
        PortletInstanceCategory updatedPortletInstanceCategory = this.portletInstanceCategoryStorage.updatePortletInstanceCategory(portletInstanceCategory);
        this.listenerService.broadcast(CATEGORY_UPDATED_EVENT, (Object)username, (Object)updatedPortletInstanceCategory);
        return updatedPortletInstanceCategory;
    }

    public PortletInstanceCategory updatePortletInstanceCategory(PortletInstanceCategory portletInstanceCategory) throws ObjectNotFoundException {
        PortletInstanceCategory updatedPortletInstanceCategory = this.portletInstanceCategoryStorage.updatePortletInstanceCategory(portletInstanceCategory);
        this.listenerService.broadcast(CATEGORY_UPDATED_EVENT, null, (Object)updatedPortletInstanceCategory);
        return updatedPortletInstanceCategory;
    }

    public Application<Portlet> getPortletInstanceApplication(long portletInstanceId, long applicationStorageId, String username) throws IllegalAccessException, ObjectNotFoundException {
        PortletInstance portletInstance = portletInstanceId <= 0L ? null : this.getPortletInstance(portletInstanceId, username, null, false);
        return this.portletInstanceLayoutStorage.getPortletInstanceApplication(portletInstance, applicationStorageId);
    }

    public List<PortletInstancePreference> getPortletInstancePreferences(long portletInstanceId, String username) throws IllegalAccessException, ObjectNotFoundException {
        PortletInstance portletInstance = this.getPortletInstance(portletInstanceId, username, null, false);
        return this.getPortletInstancePreferences(portletInstance);
    }

    public List<PortletInstancePreference> getApplicationPreferences(long applicationId, String username) throws IllegalAccessException, ObjectNotFoundException {
        Application<Portlet> application = this.portletInstanceLayoutStorage.getApplication(applicationId);
        if (application == null) {
            throw new ObjectNotFoundException(String.format("Application with id %s wasn't found", applicationId));
        }
        if (!this.layoutAclService.isAdministrator(username) && Arrays.stream(application.getAccessPermissions()).noneMatch(permission -> this.layoutAclService.isMemberOf(username, (String)permission))) {
            throw new IllegalAccessException(String.format("Application with id %s access denied", applicationId));
        }
        return this.getApplicationPreferences(application);
    }

    public long getApplicationPortletInstanceId(long applicationId) {
        return this.portletInstanceLayoutStorage.getApplicationPortletInstanceId(applicationId);
    }

    public long getPortletInstanceApplicationId(long portletInstanceId) {
        return this.portletInstanceLayoutStorage.getPortletInstanceApplicationId(portletInstanceId);
    }

    public List<PortletInstance> getPortletInstances() {
        return this.portletInstanceStorage.getPortletInstances();
    }

    private void deletePortletInstanceFromStore(long id) throws ObjectNotFoundException {
        try {
            this.attachmentService.deleteAttachments("portletInstance", String.valueOf(id));
        }
        catch (Exception e) {
            LOG.debug((Object)"Error while deleting attachments of deleted Portlet instance", (Throwable)e);
        }
        try {
            this.translationService.deleteTranslationLabels("portletInstance", id);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug((Object)"Error while deleting translation labels of deleted Portlet instance", (Throwable)e);
        }
        this.portletInstanceStorage.deletePortletInstance(id);
    }

    private void deletePortletInstanceCategoryFromStore(long id) throws ObjectNotFoundException {
        try {
            this.translationService.deleteTranslationLabels("portletInstanceCategory", id);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug((Object)"Error while deleting translation labels of deleted Portlet instance Category", (Throwable)e);
        }
        this.portletInstanceCategoryStorage.deletePortletInstanceCategory(id);
    }

    private void computePortletInstanceAttributes(Locale locale, PortletInstance portletInstance) {
        portletInstance.setName(this.getLabel("portletInstance", portletInstance.getId(), "title", locale));
        portletInstance.setDescription(this.getLabel("portletInstance", portletInstance.getId(), "description", locale));
        List attachmentFileIds = this.attachmentService.getAttachmentFileIds("portletInstance", String.valueOf(portletInstance.getId()));
        if (CollectionUtils.isNotEmpty((Collection)attachmentFileIds)) {
            portletInstance.setIllustrationId(Long.parseLong((String)attachmentFileIds.get(0)));
        }
        portletInstance.setApplicationId(this.getPortletInstanceApplicationId(portletInstance.getId()));
        PortletDescriptor portlet = this.portletService.getPortlet(portletInstance.getContentId());
        if (portlet != null) {
            portletInstance.setEditable(portlet.isEditable());
        }
    }

    private void computePortletInstanceCategoryAttributes(Locale locale, PortletInstanceCategory portletInstanceCategory) {
        portletInstanceCategory.setName(this.getLabel("portletInstanceCategory", portletInstanceCategory.getId(), "title", locale));
    }

    private List<PortletInstancePreference> getPortletInstancePreferences(PortletInstance portletInstance) throws ObjectNotFoundException {
        Application<Portlet> application = this.portletInstanceLayoutStorage.getOrCreatePortletInstanceApplication(portletInstance);
        if (application == null) {
            throw new ObjectNotFoundException(String.format("Portlet Instance with id %s wasn't found", portletInstance.getId()));
        }
        return this.getApplicationPreferences(application);
    }

    private List<PortletInstancePreference> getApplicationPreferences(Application<Portlet> application) {
        String portletName = this.portletInstanceLayoutStorage.getApplicationPortletName(application);
        Portlet preferences = this.portletInstanceLayoutStorage.getApplicationPreferences(Long.parseLong(application.getStorageId()));
        PortletInstancePreferencePlugin plugin = this.preferencePlugins.get(portletName);
        if (plugin == null) {
            if (preferences == null) {
                return Collections.emptyList();
            }
            ArrayList<PortletInstancePreference> instancePreferences = new ArrayList<PortletInstancePreference>();
            preferences.forEach(p -> instancePreferences.add(new PortletInstancePreference(p.getName(), p.getValue())));
            return instancePreferences;
        }
        return plugin.generatePreferences(application, preferences);
    }

    private String getLabel(String objectType, long objectId, String fieldName, Locale locale) {
        if (locale == null) {
            locale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
        }
        try {
            TranslationField translationField = this.translationService.getTranslationField(objectType, objectId, fieldName);
            if (translationField != null && MapUtils.isNotEmpty((Map)translationField.getLabels())) {
                String label = (String)translationField.getLabels().get(locale);
                if (label == null) {
                    Locale defaultLocale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
                    label = (String)translationField.getLabels().get(defaultLocale);
                }
                if (label == null) {
                    label = (String)translationField.getLabels().values().iterator().next();
                }
                return label;
            }
            return null;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    private boolean hasPermission(PortletInstance portletInstance, String username) {
        List<String> permissions = portletInstance.getPermissions();
        return CollectionUtils.isEmpty(permissions) || permissions.equals(EVERYONE_PERMISSIONS_LIST) || StringUtils.isNotBlank((CharSequence)username) && permissions.stream().anyMatch(p -> this.layoutAclService.isMemberOf(username, (String)p));
    }

    private boolean hasPermission(PortletInstanceCategory category, String username) {
        List<String> permissions = category.getPermissions();
        return CollectionUtils.isEmpty(permissions) || permissions.equals(EVERYONE_PERMISSIONS_LIST) || StringUtils.isNotBlank((CharSequence)username) && permissions.stream().anyMatch(p -> this.layoutAclService.isMemberOf(username, (String)p));
    }
}

