/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;

public class MappingModelHelper {
    private MappingModelHelper() {
    }

    public static boolean isCompatibleModelPart(ModelPart attribute1, ModelPart attribute2) {
        if (attribute1 == attribute2) {
            return true;
        }
        if (attribute1.getClass() != attribute2.getClass() || attribute1.getJavaType() != attribute2.getJavaType()) {
            return false;
        }
        if (attribute1 instanceof Association) {
            Association association1 = (Association)attribute1;
            Association association2 = (Association)attribute2;
            return association1.getForeignKeyDescriptor().getAssociationKey().equals(association2.getForeignKeyDescriptor().getAssociationKey());
        }
        if (attribute1 instanceof PluralAttributeMapping) {
            PluralAttributeMapping plural1 = (PluralAttributeMapping)attribute1;
            PluralAttributeMapping plural2 = (PluralAttributeMapping)attribute2;
            CollectionPart element1 = plural1.getElementDescriptor();
            CollectionPart element2 = plural2.getElementDescriptor();
            CollectionPart index1 = plural1.getIndexDescriptor();
            CollectionPart index2 = plural2.getIndexDescriptor();
            return plural1.getKeyDescriptor().getAssociationKey().equals(plural2.getKeyDescriptor().getAssociationKey()) && (index1 == null && index2 == null || MappingModelHelper.isCompatibleModelPart(index1, index2)) && MappingModelHelper.isCompatibleModelPart(element1, element2);
        }
        if (attribute1 instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embedded1 = (EmbeddableValuedModelPart)attribute1;
            EmbeddableValuedModelPart embedded2 = (EmbeddableValuedModelPart)attribute2;
            EmbeddableMappingType embeddableTypeDescriptor1 = embedded1.getEmbeddableTypeDescriptor();
            EmbeddableMappingType embeddableTypeDescriptor2 = embedded2.getEmbeddableTypeDescriptor();
            int numberOfAttributeMappings = embeddableTypeDescriptor1.getNumberOfAttributeMappings();
            if (numberOfAttributeMappings != embeddableTypeDescriptor2.getNumberOfAttributeMappings()) {
                return false;
            }
            for (int i = 0; i < numberOfAttributeMappings; ++i) {
                if (MappingModelHelper.isCompatibleModelPart(embeddableTypeDescriptor1.getAttributeMapping(i), embeddableTypeDescriptor2.getAttributeMapping(i))) continue;
                return false;
            }
            return true;
        }
        if (attribute1 instanceof BasicValuedModelPart) {
            BasicValuedModelPart basic1 = (BasicValuedModelPart)attribute1;
            BasicValuedModelPart basic2 = (BasicValuedModelPart)attribute2;
            if (!basic1.getSelectionExpression().equals(basic2.getSelectionExpression())) {
                return false;
            }
            if (basic1.getContainingTableExpression().equals(basic2.getContainingTableExpression())) {
                return true;
            }
            return attribute1.findContainingEntityMapping().getEntityPersister() instanceof UnionSubclassEntityPersister;
        }
        return false;
    }
}

