/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.notes.listener.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

public class NotesPageListener
extends PageWikiListener {
    private static final Log LOG = ExoLogger.getLogger(NotesPageListener.class);
    private static final String WIKI_ADD_PAGE_OPERATION = "noteCreated";
    private static final String WIKI_UPDATE_PAGE_OPERATION = "noteUpdated";
    private static final String WIKI_DELETE_PAGE_OPERATION = "noteDeleted";
    private static final String WIKI_OPEN_PAGE_TREE = "openNoteByTree";
    private static final String WIKI_OPEN_PAGE_BREAD_CRUMB = "openNoteByBreadCrumb";
    protected PortalContainer container = PortalContainer.getInstance();
    protected IdentityManager identityManager;
    protected SpaceService spaceService;

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_ADD_PAGE_OPERATION, null);
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        if (!(page instanceof DraftPage) && wikiUpdateType != null) {
            this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_UPDATE_PAGE_OPERATION, wikiUpdateType);
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_DELETE_PAGE_OPERATION, null);
    }

    public void postgetPagefromTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_OPEN_PAGE_TREE, null);
    }

    public void postgetPagefromBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        this.computeWikiPageStatistics(page, wikiType, wikiOwner, WIKI_OPEN_PAGE_BREAD_CRUMB, null);
    }

    private void computeWikiPageStatistics(Page page, String wikiType, String wikiOwner, String operation, PageUpdateType wikiUpdateType) {
        ConversationState conversationstate = ConversationState.getCurrent();
        String modifierUsername = conversationstate == null || conversationstate.getIdentity() == null ? null : conversationstate.getIdentity().getUserId();
        this.computeWikiPageStatisticsAsync(page, wikiType, wikiOwner, modifierUsername, operation, wikiUpdateType);
    }

    private void computeWikiPageStatisticsAsync(Page page, String wikiType, String wikiOwner, String modifierUsername, String operation, PageUpdateType wikiUpdateType) {
        CompletableFuture.supplyAsync(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                long userIdentityId = this.getUserIdentityId(modifierUsername);
                this.createWikiPageStatistic(page, wikiType, wikiOwner, userIdentityId, operation, wikiUpdateType);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error computing wiki statistics", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            return null;
        });
    }

    private void createWikiPageStatistic(Page page, String wikiType, String wikiOwner, long userIdentityId, String operation, PageUpdateType wikiUpdateType) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("Note");
        statisticData.setSubModule("Note");
        statisticData.setOperation(operation);
        statisticData.setUserId(userIdentityId);
        if (StringUtils.isNotBlank((CharSequence)wikiOwner) && StringUtils.equalsIgnoreCase((CharSequence)WikiType.GROUP.name(), (CharSequence)wikiType)) {
            Space space = this.getSpaceService().getSpaceByGroupId(wikiOwner);
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
        if (page != null) {
            statisticData.addParameter("wikiPageId", (Object)page.getId());
            statisticData.addParameter("wikiId", (Object)page.getWikiId());
            statisticData.addParameter("contentLength", (Object)(page.getContent() == null ? 0 : page.getContent().length()));
            statisticData.addParameter("titleLength", (Object)(page.getTitle() == null ? 0 : page.getTitle().length()));
            statisticData.addParameter("authorId", (Object)this.getUserIdentityId(page.getAuthor()));
            statisticData.addParameter("ownerId", (Object)this.getUserIdentityId(page.getOwner()));
            statisticData.addParameter("wikiType", (Object)page.getWikiType());
            statisticData.addParameter("createdDate", (Object)page.getCreatedDate());
        }
        if (wikiUpdateType != null) {
            statisticData.addParameter("updateType", (Object)wikiUpdateType.name());
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private long getUserIdentityId(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return 0L;
        }
        Identity userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", username);
        if (userIdentity == null) {
            return 0L;
        }
        return Long.parseLong(userIdentity.getId());
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }
}

