/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cache.future;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.cache.future.Retrieval;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class FutureCache<K, V, C> {
    final Loader<K, V, C> loader;
    private final ConcurrentMap<K, Retrieval<K, V, C>> futureEntries;
    private final Log log = ExoLogger.getLogger(FutureCache.class);

    protected FutureCache(Loader<K, V, C> loader) {
        this.loader = loader;
        this.futureEntries = new ConcurrentHashMap<K, Retrieval<K, V, C>>();
    }

    protected abstract V get(K var1);

    protected abstract void put(K var1, V var2);

    protected abstract void putOnly(K var1, V var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(C context, K key) {
        if (key == null) {
            return null;
        }
        V value = this.get(key);
        if (value == null) {
            Retrieval retrieval = new Retrieval(context, key, this);
            boolean inserted = true;
            try {
                Retrieval phantom = this.futureEntries.putIfAbsent(key, retrieval);
                if (phantom != null) {
                    retrieval = phantom;
                    inserted = false;
                } else {
                    try {
                        retrieval.current = Thread.currentThread();
                        retrieval.future.run();
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Retrieval of resource " + String.valueOf(key) + " threw an exception"), (Throwable)e);
                    }
                    finally {
                        retrieval.current = null;
                    }
                }
                if (retrieval.current == Thread.currentThread()) {
                    throw new IllegalStateException("Reentrancy detected when obtaining key " + String.valueOf(key) + " with context " + String.valueOf(context) + " detected");
                }
                try {
                    value = retrieval.future.get();
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException("Error retrieving value with key " + String.valueOf(key), e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                if (inserted) {
                    this.futureEntries.remove(key, retrieval);
                }
            }
        }
        return value;
    }

    public Loader<K, V, C> getLoader() {
        return this.loader;
    }
}

