/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.suggest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure1;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure11;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure13;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure3;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure5;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure7;
import org.exoplatform.social.rest.suggest.SpaceRestServices$AjcClosure9;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/homepage/intranet/spaces/")
@Produces(value={"application/json"})
@Deprecated
public class SpaceRestServices
implements ResourceContainer {
    private static final Log LOG;
    private static final CacheControl cacheControl;
    private static final String SPACE_NAME = "name";
    private static final String SPACE_ID = "spaceId";
    private static final String SPACE_DISPLAY_NAME = "displayName";
    private static final String SPACE_URL = "spaceUrl";
    private static final String SPACE_AVATAR_URL = "spaceAvatarUrl";
    private static final String SPACE_REGISTRATION = "registration";
    private static final String SPACE_MEMBERS = "members";
    private static final String SPACE_PRIVACY = "privacy";
    private static final String NUMBER = "number";
    private static final String SPACE_CREATED_DATE = "createdDate";
    private static final String ITEMS = "items";
    private final ExoContainer container;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public SpaceRestServices(ExoContainerContext ctx) {
        this.container = ctx.getContainer();
    }

    @GET
    @Path(value="suggestions")
    @DeprecatedAPI(value="Use SpaceRestResourcesV1.getSpaces instead")
    public Response getSuggestions(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)securityContext, (Object)uriInfo2);
        Object[] objectArray = new Object[]{this, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure1 spaceRestServices$AjcClosure1 = new SpaceRestServices$AjcClosure1(objectArray);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private JSONObject buildJSONObject(Space space, int k) throws JSONException {
        String avatar = space.getAvatarUrl();
        if (avatar == null) {
            avatar = "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
        }
        String spaceType = "";
        spaceType = space.getRegistration() == null || space.getRegistration().equals("open") ? "Public" : "Private";
        JSONObject json = new JSONObject();
        json.put(SPACE_NAME, (Object)space.getPrettyName());
        json.put(SPACE_ID, (Object)space.getId());
        json.put(SPACE_DISPLAY_NAME, (Object)space.getDisplayName());
        json.put(SPACE_URL, (Object)space.getUrl());
        json.put(SPACE_AVATAR_URL, (Object)avatar);
        json.put(SPACE_REGISTRATION, (Object)space.getRegistration());
        json.put(SPACE_MEMBERS, space.getMembers() == null ? 0 : space.getMembers().length);
        json.put(SPACE_PRIVACY, (Object)spaceType);
        json.put(NUMBER, k);
        json.put(SPACE_CREATED_DATE, space.getCreatedTime());
        return json;
    }

    @GET
    @Path(value="accept/{spaceName}")
    @DeprecatedAPI(value="Use SpaceMembershipRestResourcesV1.updateSpaceMembershipById instead")
    public Response accept(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        String string = spaceName;
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        Object[] objectArray = new Object[]{string, securityContext, uriInfo2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure3 spaceRestServices$AjcClosure3 = new SpaceRestServices$AjcClosure3(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="deny/{spaceName}")
    @DeprecatedAPI(value="Use SpaceMembershipRestResourcesV1.updateSpaceMembershipById instead")
    public Response deny(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        String string = spaceName;
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        Object[] objectArray = new Object[]{string, securityContext, uriInfo2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure5 spaceRestServices$AjcClosure5 = new SpaceRestServices$AjcClosure5(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="request/{spaceName}")
    @DeprecatedAPI(value="Use SpaceMembershipRestResourcesV1.updateSpaceMembershipById instead")
    public Response request(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        String string = spaceName;
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        Object[] objectArray = new Object[]{string, securityContext, uriInfo2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure7 spaceRestServices$AjcClosure7 = new SpaceRestServices$AjcClosure7(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @DELETE
    @Path(value="leave/{spaceId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="A user leaves a space", method="POST", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="404", description="Space not found")})
    @DeprecatedAPI(value="Use SpaceMembershipRestResourcesV1.updateSpaceMembershipById instead")
    public Response leave(@Parameter(description="Space technical identifier", required=true) @PathParam(value="spaceId") String spaceId, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        String string = spaceId;
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        Object[] objectArray = new Object[]{string, securityContext, uriInfo2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure9 spaceRestServices$AjcClosure9 = new SpaceRestServices$AjcClosure9(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @DELETE
    @Path(value="cancel/{spaceId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="A user cancels his request to join a space", method="POST", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="404", description="Space not found")})
    @DeprecatedAPI(value="Use SpaceMembershipRestResourcesV1.updateSpaceMembershipById instead")
    public Response cancel(@Parameter(description="Space technical identifier", required=true) @PathParam(value="spaceId") String spaceId, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        String string = spaceId;
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        Object[] objectArray = new Object[]{string, securityContext, uriInfo2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure11 spaceRestServices$AjcClosure11 = new SpaceRestServices$AjcClosure11(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="join/{spaceName}")
    @DeprecatedAPI(value="Use SpaceMembershipRestResourcesV1.addSpacesMemberships instead")
    public Response join(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        String string = spaceName;
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        Object[] objectArray = new Object[]{string, securityContext, uriInfo2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, securityContext, uriInfo2, joinPoint};
        SpaceRestServices$AjcClosure13 spaceRestServices$AjcClosure13 = new SpaceRestServices$AjcClosure13(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestServices$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        SpaceRestServices.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceRestServices.class);
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    static final /* synthetic */ Response getSuggestions_aroundBody0(SpaceRestServices ajc$this, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            HashMap<Space, Integer> spacesWithMemberNum;
            String userId;
            JSONObject jsonGlobal;
            JSONArray jsonArray;
            block17: {
                Space[] suggestedSpaces;
                Identity[] connections;
                jsonArray = new JSONArray();
                jsonGlobal = new JSONObject();
                userId = ajc$this.getUserId(sc, uriInfo);
                if (userId == null) {
                    return Response.status((int)500).cacheControl(cacheControl).build();
                }
                SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
                ListAccess suggestedSpacesLA = spaceService.getPublicSpacesWithListAccess(userId);
                int size = suggestedSpacesLA.getSize();
                if (size == 0) {
                    jsonGlobal.put(ITEMS, (Object)jsonArray);
                    jsonGlobal.put("noConnections", 0);
                    jsonGlobal.put("username", (Object)userId);
                    return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
                }
                IdentityManager identityManager = (IdentityManager)ajc$this.container.getComponentInstanceOfType(IdentityManager.class);
                RelationshipManager relationshipManager = (RelationshipManager)ajc$this.container.getComponentInstanceOfType(RelationshipManager.class);
                Identity identity = identityManager.getOrCreateIdentity("organization", userId, false);
                ListAccess connectionsLA = relationshipManager.getConnections(identity);
                spacesWithMemberNum = new HashMap<Space, Integer>();
                int maxConnectionsToLoad = 100;
                int maxSpacesToLoad = 50;
                int maxSuggestions = 10;
                int totalConnections = connectionsLA.getSize();
                Random random = new Random();
                if (totalConnections > maxConnectionsToLoad) {
                    int startIndex = random.nextInt(totalConnections - maxConnectionsToLoad);
                    connections = (Identity[])connectionsLA.load(startIndex, maxConnectionsToLoad);
                } else {
                    connections = (Identity[])connectionsLA.load(0, totalConnections);
                }
                if (size > maxSpacesToLoad) {
                    int startIndex = random.nextInt(size - maxSpacesToLoad);
                    suggestedSpaces = (Space[])suggestedSpacesLA.load(startIndex, maxSpacesToLoad);
                } else {
                    suggestedSpaces = (Space[])suggestedSpacesLA.load(0, size);
                }
                for (Space space : suggestedSpaces) {
                    if (spaceService.isMember(space, identity.getRemoteId())) continue;
                    for (Identity connector : connections) {
                        if ("hidden".equals(space.getVisibility()) || "closed".equals(space.getRegistration()) || !spaceService.isMember(space, connector.getRemoteId()) || !spaceService.isIgnored(space, connector.getRemoteId())) continue;
                        Integer value = (Integer)spacesWithMemberNum.get(space);
                        value = value == null ? new Integer(1) : new Integer(value + 1);
                        spacesWithMemberNum.put(space, value);
                    }
                }
                if (!spacesWithMemberNum.isEmpty()) {
                    ArrayList<Space> spaces;
                    TreeMap<Integer, ArrayList<Space>> groupByCommonConnections = new TreeMap<Integer, ArrayList<Space>>();
                    for (Space space : spacesWithMemberNum.keySet()) {
                        Integer commonSpaces = (Integer)spacesWithMemberNum.get(space);
                        spaces = (ArrayList<Space>)groupByCommonConnections.get(commonSpaces);
                        if (spaces == null) {
                            spaces = new ArrayList<Space>();
                            groupByCommonConnections.put(commonSpaces, spaces);
                        }
                        spaces.add(space);
                    }
                    int suggestionLeft = maxSuggestions;
                    for (Integer key : groupByCommonConnections.descendingKeySet()) {
                        spaces = (List)groupByCommonConnections.get(key);
                        for (Space space : spaces) {
                            JSONObject json = ajc$this.buildJSONObject(space, key);
                            jsonArray.put((Object)json);
                            if (--suggestionLeft != 0) continue;
                            break block17;
                        }
                    }
                } else {
                    List lastSpaces = spaceService.getLastSpaces(10);
                    for (Space space : lastSpaces) {
                        if ("hidden".equals(space.getVisibility()) || "closed".equals(space.getRegistration()) || spaceService.isMember(space, identity.getRemoteId()) || spaceService.isPendingUser(space, identity.getRemoteId()) || spaceService.isInvitedUser(space, identity.getRemoteId()) || spaceService.isIgnored(space, identity.getRemoteId())) continue;
                        JSONObject json = ajc$this.buildJSONObject(space, 0);
                        json.put("username", (Object)userId);
                        jsonArray.put((Object)json);
                    }
                }
            }
            jsonGlobal.put(ITEMS, (Object)jsonArray);
            jsonGlobal.put("noConnections", spacesWithMemberNum.size());
            jsonGlobal.put("username", (Object)userId);
            return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space invitation rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    static final /* synthetic */ Response accept_aroundBody2(SpaceRestServices ajc$this, String spaceName, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            String userId = ajc$this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
            if (spaceService.isInvitedUser(spaceService.getSpaceById(spaceName), userId)) {
                spaceService.addMember(spaceService.getSpaceById(spaceName), userId);
            }
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space accept rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    static final /* synthetic */ Response deny_aroundBody4(SpaceRestServices ajc$this, String spaceName, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            String userId = ajc$this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
            spaceService.removeInvitedUser(spaceService.getSpaceById(spaceName), userId);
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    static final /* synthetic */ Response request_aroundBody6(SpaceRestServices ajc$this, String spaceName, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            String userId = ajc$this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
            spaceService.addPendingUser(spaceService.getSpaceById(spaceName), userId);
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    static final /* synthetic */ Response leave_aroundBody8(SpaceRestServices ajc$this, String spaceId, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            String userId = ajc$this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).build();
            }
            SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                return Response.status((int)404).build();
            }
            if (spaceService.isMember(space, userId)) {
                spaceService.removeMember(space, userId);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    static final /* synthetic */ Response cancel_aroundBody10(SpaceRestServices ajc$this, String spaceId, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            String userId = ajc$this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).build();
            }
            SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                return Response.status((int)404).build();
            }
            if (spaceService.isPendingUser(space, userId)) {
                spaceService.removePendingUser(space, userId);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    static final /* synthetic */ Response join_aroundBody12(SpaceRestServices ajc$this, String spaceName, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            String userId = ajc$this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ajc$this.container.getComponentInstanceOfType(SpaceService.class);
            if (spaceService.getSpaceById(spaceName).getRegistration().equals("open")) {
                spaceService.addMember(spaceService.getSpaceById(spaceName), userId);
            }
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceRestServices.java", SpaceRestServices.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuggestions", "org.exoplatform.social.rest.suggest.SpaceRestServices", "javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "sc:uriInfo", "", "javax.ws.rs.core.Response"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "accept", "org.exoplatform.social.rest.suggest.SpaceRestServices", "java.lang.String:javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "spaceName:sc:uriInfo", "", "javax.ws.rs.core.Response"), 236);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deny", "org.exoplatform.social.rest.suggest.SpaceRestServices", "java.lang.String:javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "spaceName:sc:uriInfo", "", "javax.ws.rs.core.Response"), 261);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "request", "org.exoplatform.social.rest.suggest.SpaceRestServices", "java.lang.String:javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "spaceName:sc:uriInfo", "", "javax.ws.rs.core.Response"), 283);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "leave", "org.exoplatform.social.rest.suggest.SpaceRestServices", "java.lang.String:javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "spaceId:sc:uriInfo", "", "javax.ws.rs.core.Response"), 311);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancel", "org.exoplatform.social.rest.suggest.SpaceRestServices", "java.lang.String:javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "spaceId:sc:uriInfo", "", "javax.ws.rs.core.Response"), 344);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "join", "org.exoplatform.social.rest.suggest.SpaceRestServices", "java.lang.String:javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "spaceName:sc:uriInfo", "", "javax.ws.rs.core.Response"), 373);
    }
}

