/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.spi;

import java.time.Instant;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;

public interface SpaceService {
    public Space getSpaceByDisplayName(String var1);

    public Space getSpaceByPrettyName(String var1);

    public Space getSpaceByGroupId(String var1);

    public Space getSpaceById(String var1);

    public Space getSpaceByUrl(String var1);

    public ListAccess<Space> getAllSpacesWithListAccess();

    public ListAccess<Space> getAllSpacesByFilter(SpaceFilter var1);

    default public ListAccess<Space> getManagerSpaces(String username) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getManagerSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    public ListAccess<Space> getMemberSpaces(String var1);

    public ListAccess<Space> getMemberSpacesByFilter(String var1, SpaceFilter var2);

    default public ListAccess<Space> getFavoriteSpacesByFilter(String username, SpaceFilter spaceFilter) {
        throw new UnsupportedOperationException();
    }

    public ListAccess<Space> getAccessibleSpacesWithListAccess(String var1);

    public ListAccess<Space> getAccessibleSpacesByFilter(String var1, SpaceFilter var2);

    public ListAccess<Space> getSettingableSpaces(String var1);

    public ListAccess<Space> getSettingabledSpacesByFilter(String var1, SpaceFilter var2);

    public ListAccess<Space> getInvitedSpacesWithListAccess(String var1);

    public ListAccess<Space> getInvitedSpacesByFilter(String var1, SpaceFilter var2);

    public ListAccess<Space> getPublicSpacesWithListAccess(String var1);

    public ListAccess<Space> getPublicSpacesByFilter(String var1, SpaceFilter var2);

    public ListAccess<Space> getPendingSpacesWithListAccess(String var1);

    public ListAccess<Space> getPendingSpacesByFilter(String var1, SpaceFilter var2);

    public Space createSpace(Space var1, String var2);

    default public Space updateSpace(Space existingSpace, List<Identity> identitiesToInvite) {
        throw new UnsupportedOperationException();
    }

    public Space updateSpace(Space var1);

    public Space updateSpaceAvatar(Space var1, String var2);

    public Space updateSpaceBanner(Space var1, String var2);

    public void deleteSpace(Space var1);

    default public void deleteSpace(Space space, boolean deleteGroup) {
    }

    public void addPendingUser(Space var1, String var2);

    public void removePendingUser(Space var1, String var2);

    public boolean isPendingUser(Space var1, String var2);

    public void addInvitedUser(Space var1, String var2);

    public void removeInvitedUser(Space var1, String var2);

    public boolean isInvitedUser(Space var1, String var2);

    public void addMember(Space var1, String var2);

    public void removeMember(Space var1, String var2);

    public boolean isMember(Space var1, String var2);

    default public void addRedactor(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void removeRedactor(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isRedactor(Space space, String username) {
        return false;
    }

    default public void addPublisher(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public void removePublisher(Space space, String username) {
        throw new UnsupportedOperationException();
    }

    default public boolean isPublisher(Space space, String username) {
        return false;
    }

    default public boolean hasRedactor(Space space) {
        return false;
    }

    default public boolean canRedactOnSpace(Space space, org.exoplatform.services.security.Identity viewer) {
        return viewer != null && this.canRedactOnSpace(space, viewer.getUserId());
    }

    default public boolean canRedactOnSpace(Space space, String username) {
        if (username == null) {
            return false;
        }
        if (this.isMember(space, username) && (!this.hasRedactor(space) || this.isRedactor(space, username) || this.isManager(space, username))) {
            return true;
        }
        return this.isSuperManager(username);
    }

    default public boolean canPublishOnSpace(Space space, String username) {
        if (username == null) {
            return false;
        }
        if (this.isMember(space, username) && (this.isPublisher(space, username) || this.isManager(space, username))) {
            return true;
        }
        return this.isSuperManager(username) || this.isContentPublisher(username);
    }

    default public boolean canManageSpace(Space space, String username) {
        if (username == null) {
            return false;
        }
        if (this.isMember(space, username) && this.isManager(space, username)) {
            return true;
        }
        return this.isSuperManager(username);
    }

    default public boolean canViewSpace(Space space, String username) {
        if (username == null) {
            return false;
        }
        if (this.isMember(space, username)) {
            return true;
        }
        return this.isSuperManager(username);
    }

    public void setManager(Space var1, String var2, boolean var3);

    public boolean isManager(Space var1, String var2);

    public boolean isOnlyManager(Space var1, String var2);

    public boolean hasAccessPermission(Space var1, String var2);

    public boolean hasSettingPermission(Space var1, String var2);

    public void registerSpaceListenerPlugin(SpaceListenerPlugin var1);

    public void unregisterSpaceListenerPlugin(SpaceListenerPlugin var1);

    public List<Space> getVisibleSpaces(String var1, SpaceFilter var2) throws SpaceException;

    public SpaceListAccess getVisibleSpacesWithListAccess(String var1, SpaceFilter var2);

    public SpaceListAccess getUnifiedSearchSpacesWithListAccess(String var1, SpaceFilter var2);

    public Space createSpace(Space var1, String var2, List<Identity> var3) throws SpaceException;

    public void saveSpace(Space var1, boolean var2) throws SpaceException;

    public void renameSpace(Space var1, String var2) throws SpaceException;

    public void renameSpace(Space var1, String var2, String var3) throws SpaceException;

    @Deprecated
    public void deleteSpace(String var1) throws SpaceException;

    @Deprecated
    public void addMember(String var1, String var2) throws SpaceException;

    @Deprecated
    public void removeMember(String var1, String var2) throws SpaceException;

    @Deprecated
    public List<String> getMembers(Space var1) throws SpaceException;

    @Deprecated
    public List<String> getMembers(String var1) throws SpaceException;

    @Deprecated
    public boolean isMember(String var1, String var2) throws SpaceException;

    @Deprecated
    public boolean hasAccessPermission(String var1, String var2) throws SpaceException;

    @Deprecated
    public boolean hasEditPermission(Space var1, String var2) throws SpaceException;

    @Deprecated
    public boolean hasEditPermission(String var1, String var2) throws SpaceException;

    @Deprecated
    public boolean isInvited(Space var1, String var2) throws SpaceException;

    @Deprecated
    public boolean isInvited(String var1, String var2) throws SpaceException;

    @Deprecated
    public boolean isPending(Space var1, String var2) throws SpaceException;

    @Deprecated
    public boolean isPending(String var1, String var2) throws SpaceException;

    default public boolean isIgnored(Space space, String username) {
        return false;
    }

    default public void setIgnored(String spaceId, String username) {
    }

    default public void restoreSpacePageLayout(String spaceId, String appId, org.exoplatform.services.security.Identity identity) throws IllegalAccessException, SpaceException {
        throw new UnsupportedOperationException();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public void installApplication(Space var1, String var2) throws SpaceException;

    @Deprecated(since="7.0", forRemoval=true)
    public void activateApplication(Space var1, String var2) throws SpaceException;

    @Deprecated(since="7.0", forRemoval=true)
    public void activateApplication(String var1, String var2) throws SpaceException;

    @Deprecated(since="7.0", forRemoval=true)
    public void deactivateApplication(Space var1, String var2) throws SpaceException;

    @Deprecated(since="7.0", forRemoval=true)
    public void deactivateApplication(String var1, String var2) throws SpaceException;

    @Deprecated(since="7.0", forRemoval=true)
    public void removeApplication(Space var1, String var2, String var3) throws SpaceException;

    @Deprecated(since="7.0", forRemoval=true)
    public void removeApplication(String var1, String var2, String var3) throws SpaceException;

    public void updateSpaceAccessed(String var1, Space var2) throws SpaceException;

    public List<Space> getLastAccessedSpace(String var1, String var2, int var3, int var4) throws SpaceException;

    public List<Space> getLastSpaces(int var1);

    public ListAccess<Space> getLastAccessedSpace(String var1, String var2);

    @Deprecated(since="4.0", forRemoval=true)
    public void requestJoin(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void requestJoin(String var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void revokeRequestJoin(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void revokeRequestJoin(String var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void inviteMember(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void inviteMember(String var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void revokeInvitation(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void revokeInvitation(String var1, String var2) throws SpaceException;

    @Deprecated
    public void acceptInvitation(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void acceptInvitation(String var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void denyInvitation(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void denyInvitation(String var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void validateRequest(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void validateRequest(String var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void declineRequest(Space var1, String var2) throws SpaceException;

    @Deprecated(since="4.0", forRemoval=true)
    public void declineRequest(String var1, String var2) throws SpaceException;

    public void registerSpaceLifeCycleListener(SpaceLifeCycleListener var1);

    public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener var1);

    public ListAccess<Space> getVisitedSpaces(String var1, String var2);

    public boolean isSuperManager(String var1);

    default public boolean isContentManager(String username) {
        return this.isSuperManager(username);
    }

    default public boolean isContentPublisher(String username) {
        return this.isSuperManager(username);
    }

    default public void inviteIdentities(Space space, List<Identity> identitiesToInvite) {
        throw new UnsupportedOperationException();
    }

    default public boolean isSpaceContainsExternals(Long spaceId) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getPendingSpaceRequestsToManage(String remoteId) {
        throw new UnsupportedOperationException();
    }

    default public void moveApplication(String spaceId, String appId, int transition) throws SpaceException {
        throw new UnsupportedOperationException();
    }

    default public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String spaceId) {
        throw new UnsupportedOperationException();
    }

    default public void saveSpaceExternalInvitation(String spaceId, String email, String tokenId) {
        throw new UnsupportedOperationException();
    }

    default public SpaceExternalInvitation getSpaceExternalInvitationById(String invitationId) {
        throw new UnsupportedOperationException();
    }

    default public void deleteSpaceExternalInvitation(String invitationId) {
        throw new UnsupportedOperationException();
    }

    default public List<String> findExternalInvitationsSpacesByEmail(String email) {
        throw new UnsupportedOperationException();
    }

    default public void deleteExternalUserInvitations(String email) {
        throw new UnsupportedOperationException();
    }

    default public ListAccess<Space> getCommonSpaces(String username, String otherUsername) {
        throw new UnsupportedOperationException();
    }

    default public List<String> getMemberSpacesIds(String username, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    default public List<String> getManagerSpacesIds(String username, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    default public Instant getSpaceMembershipDate(long spaceId, String username) {
        throw new UnsupportedOperationException();
    }
}

