/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializerBuilder;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CircularFetchImpl
extends AbstractNonJoinedEntityFetch
implements BiDirectionalFetch {
    private final FetchTiming timing;
    private final NavigablePath referencedNavigablePath;

    public CircularFetchImpl(ToOneAttributeMapping referencedModelPart, FetchTiming timing, NavigablePath navigablePath, FetchParent fetchParent, boolean selectByUniqueKey, NavigablePath referencedNavigablePath, DomainResult<?> keyResult) {
        super(navigablePath, referencedModelPart, fetchParent, keyResult, selectByUniqueKey);
        this.timing = timing;
        this.referencedNavigablePath = referencedNavigablePath;
    }

    protected CircularFetchImpl(CircularFetchImpl original) {
        super(original.getNavigablePath(), original.getFetchedMapping(), original.getFetchParent(), original.getKeyResult(), original.isSelectByUniqueKey());
        this.timing = original.timing;
        this.referencedNavigablePath = original.referencedNavigablePath;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchTiming getTiming() {
        return this.timing;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new CircularFetchAssembler(this.getResultJavaType(), creationState.resolveInitializer(this, parentAccess, this).asEntityInitializer());
    }

    @Override
    public EntityInitializer createInitializer(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        if (this.timing == FetchTiming.IMMEDIATE) {
            return this.buildEntitySelectFetchInitializer(parentAccess, this.getFetchedMapping(), this.getFetchedMapping().getEntityMappingType().getEntityPersister(), this.getKeyResult(), this.getNavigablePath(), this.isSelectByUniqueKey(), creationState);
        }
        return this.buildEntityDelayedFetchInitializer(parentAccess, this.getNavigablePath(), this.getFetchedMapping(), this.isSelectByUniqueKey(), this.getKeyResult().createResultAssembler(parentAccess, creationState));
    }

    protected EntityInitializer buildEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping fetchable, EntityPersister entityPersister, DomainResult<?> keyResult, NavigablePath navigablePath, boolean selectByUniqueKey, AssemblerCreationState creationState) {
        return EntitySelectFetchInitializerBuilder.createInitializer(parentAccess, fetchable, entityPersister, keyResult, navigablePath, selectByUniqueKey, creationState);
    }

    protected EntityInitializer buildEntityDelayedFetchInitializer(FetchParentAccess parentAccess, NavigablePath referencedPath, ToOneAttributeMapping fetchable, boolean selectByUniqueKey, DomainResultAssembler<?> resultAssembler) {
        return new EntityDelayedFetchInitializer(parentAccess, referencedPath, fetchable, selectByUniqueKey, resultAssembler);
    }

    private static class CircularFetchAssembler
    implements DomainResultAssembler<Object> {
        private final EntityInitializer initializer;
        private final JavaType<Object> assembledJavaType;

        public CircularFetchAssembler(JavaType<?> assembledJavaType, EntityInitializer initializer) {
            this.assembledJavaType = assembledJavaType;
            this.initializer = initializer;
        }

        @Override
        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            this.initializer.resolveInstance(rowProcessingState);
            return this.initializer.getInitializedInstance();
        }

        @Override
        public @Nullable Initializer getInitializer() {
            return this.initializer;
        }

        @Override
        public JavaType<Object> getAssembledJavaType() {
            return this.assembledJavaType;
        }
    }
}

