/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public interface ConditionalHint {
    @Nullable
    public TypeReference getReachableType();

    default public boolean conditionMatches(ClassLoader classLoader) {
        TypeReference reachableType = this.getReachableType();
        if (reachableType != null) {
            return ClassUtils.isPresent(reachableType.getCanonicalName(), classLoader);
        }
        return true;
    }
}

