/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.util.Util;

public class Membership {
    private final List<Address> members = new LinkedList<Address>();

    public Membership() {
    }

    public Membership(Collection<Address> initial_members) {
        if (initial_members != null) {
            this.add(initial_members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getMembers() {
        List<Address> list = this.members;
        synchronized (list) {
            return new ArrayList<Address>(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership add(Address new_member) {
        List<Address> list = this.members;
        synchronized (list) {
            if (new_member != null && !this.members.contains(new_member)) {
                this.members.add(new_member);
            }
        }
        return this;
    }

    public Membership add(Address ... mbrs) {
        for (Address mbr : mbrs) {
            this.add(mbr);
        }
        return this;
    }

    public Membership add(Collection<Address> v) {
        if (v != null) {
            for (Address addr : v) {
                this.add(addr);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership remove(Address old_member) {
        if (old_member != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.remove(old_member);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership remove(Collection<Address> v) {
        if (v != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.removeAll(v);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership retainAll(Collection<Address> v) {
        if (v != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.retainAll(v);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership clear() {
        List<Address> list = this.members;
        synchronized (list) {
            this.members.clear();
        }
        return this;
    }

    public Membership set(Collection<Address> v) {
        this.clear();
        return this.add(v);
    }

    public Membership set(Membership m) {
        this.clear();
        if (m != null) {
            this.add(m.getMembers());
        }
        return this;
    }

    public Membership merge(Collection<Address> new_mems, Collection<Address> suspects) {
        this.remove(suspects);
        return this.add(new_mems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Address member) {
        if (member == null) {
            return false;
        }
        List<Address> list = this.members;
        synchronized (list) {
            return this.members.contains(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership sort() {
        List<Address> list = this.members;
        synchronized (list) {
            Collections.sort(this.members);
        }
        return this;
    }

    public Membership copy() {
        return new Membership(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<Address> list = this.members;
        synchronized (list) {
            return this.members.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address elementAt(int index) {
        List<Address> list = this.members;
        synchronized (list) {
            return this.members.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<Address> list = this.members;
        synchronized (list) {
            return Util.printListWithDelimiter(this.members, ",");
        }
    }
}

