/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin;

import io.meeds.pwa.model.PwaNotificationMessage;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.jsoup.Jsoup;

@FunctionalInterface
public interface PwaNotificationPlugin {
    public PwaNotificationMessage process(NotificationInfo var1, LocaleConfig var2);

    default public String getId() {
        return "default";
    }

    default public IdentityManager getIdentityManager() {
        throw new UnsupportedOperationException();
    }

    default public SpaceService getSpaceService() {
        throw new UnsupportedOperationException();
    }

    default public String getFullName(String username) {
        Identity poster = this.getIdentityManager().getOrCreateUserIdentity(username);
        return poster == null ? "" : poster.getProfile().getFullName();
    }

    default public String getSpaceName(String id) {
        Space space = this.getSpaceService().getSpaceById(id);
        return space == null ? "" : space.getDisplayName();
    }

    default public String htmlToText(String html) {
        return html == null ? "" : Jsoup.parse((String)html).text();
    }

    default public void handleAction(NotificationInfo notification, String action, String username) {
    }
}

