/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

public final class QuotingHelper {
    private QuotingHelper() {
    }

    public static String unquoteIdentifier(String text) {
        int end = text.length() - 1;
        assert (text.charAt(0) == '`' && text.charAt(end) == '`');
        StringBuilder sb = new StringBuilder(text.length() - 2);
        for (int i = 1; i < end; ++i) {
            int c = text.charAt(i);
            block0 : switch (c) {
                case 92: {
                    if (i + 1 >= end) break;
                    char nextChar = text.charAt(++i);
                    switch (nextChar) {
                        case 'b': {
                            c = 8;
                            break block0;
                        }
                        case 't': {
                            c = 9;
                            break block0;
                        }
                        case 'n': {
                            c = 10;
                            break block0;
                        }
                        case 'f': {
                            c = 12;
                            break block0;
                        }
                        case 'r': {
                            c = 13;
                            break block0;
                        }
                        case '\\': {
                            c = 92;
                            break block0;
                        }
                        case '\'': {
                            c = 39;
                            break block0;
                        }
                        case '\"': {
                            c = 34;
                            break block0;
                        }
                        case '`': {
                            c = 96;
                            break block0;
                        }
                        case 'u': {
                            c = (char)Integer.parseInt(text.substring(i + 1, i + 5), 16);
                            i += 4;
                            break block0;
                        }
                    }
                    sb.append('\\');
                    c = nextChar;
                    break;
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String unquoteStringLiteral(String text) {
        assert (text.length() > 1);
        int end = text.length() - 1;
        char delimiter = text.charAt(0);
        assert (delimiter == text.charAt(end));
        StringBuilder sb = new StringBuilder(text.length() - 2);
        for (int i = 1; i < end; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\'': {
                    if (delimiter != '\'') break;
                    ++i;
                    break;
                }
                case '\"': {
                    if (delimiter != '\"') break;
                    ++i;
                    break;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unquoteJavaStringLiteral(String text) {
        assert (text.length() > 1);
        char firstChar = text.charAt(0);
        int start = firstChar == 'j' || firstChar == 'J' ? 1 : 0;
        int end = text.length() - 1;
        char delimiter = text.charAt(start);
        assert (delimiter == text.charAt(end));
        StringBuilder sb = new StringBuilder(text.length() - (start + 2));
        for (int i = start + 1; i < end; ++i) {
            int c = text.charAt(i);
            if (c == 92 && i + 1 < end) {
                char nextChar = text.charAt(++i);
                switch (nextChar) {
                    case 'b': {
                        c = 8;
                        break;
                    }
                    case 't': {
                        c = 9;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        break;
                    }
                    case 'f': {
                        c = 12;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        break;
                    }
                    case '\\': {
                        c = 92;
                        break;
                    }
                    case '\'': {
                        c = 39;
                        break;
                    }
                    case '\"': {
                        c = 34;
                        break;
                    }
                    case '`': {
                        c = 96;
                        break;
                    }
                    case 'u': {
                        c = (char)Integer.parseInt(text.substring(i + 1, i + 5), 16);
                        i += 4;
                        break;
                    }
                    default: {
                        sb.append('\\');
                        c = nextChar;
                    }
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }
}

