/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.jakarta;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import org.apache.commons.chain.web.jakarta.ChainInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainListener
implements ServletContextListener {
    public static final String CONFIG_ATTR = "org.apache.commons.chain.CONFIG_ATTR";
    public static final String CONFIG_CLASS_RESOURCE = "org.apache.commons.chain.CONFIG_CLASS_RESOURCE";
    public static final String CONFIG_WEB_RESOURCE = "org.apache.commons.chain.CONFIG_WEB_RESOURCE";
    public static final String RULE_SET = "org.apache.commons.chain.RULE_SET";

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        ChainInit.destroy(context, context.getInitParameter(CONFIG_ATTR));
    }

    public void contextInitialized(ServletContextEvent event) {
        Logger logger = LoggerFactory.getLogger(ChainListener.class);
        logger.info("Initializing chain listener");
        ServletContext context = event.getServletContext();
        try {
            ChainInit.initialize(context, context.getInitParameter(CONFIG_ATTR), logger, true);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }
}

