/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.authorization;

import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AuthorizationManager
extends UserACL {
    private SpacesAdministrationService spacesAdministrationService;
    private SpaceService spaceService;
    private SpaceTemplateService spaceTemplateService;

    public AuthorizationManager(InitParams params) {
        super(params);
    }

    public boolean hasEditPermission(Identity identity, String ownerType, String ownerId, String expression) {
        if (PortalConfig.GROUP_TEMPLATE.equalsIgnoreCase(ownerType)) {
            SpaceTemplate spaceTemplate = this.getSpaceTemplateService().getSpaceTemplateByLayout(ownerId);
            return spaceTemplate == null ? this.isAdministrator(identity) : !spaceTemplate.isSystem() && this.isSpacesAdministrator(identity);
        }
        if (this.isSpaceSite(ownerType, ownerId)) {
            Space space = this.getSpaceService().getSpaceByGroupId(ownerId);
            return space != null && identity != null && this.getSpaceService().canManageSpaceLayout(space, identity.getUserId());
        }
        return this.isSpacesAdministrator(identity, ownerType, ownerId) || super.hasEditPermission(identity, ownerType, ownerId, expression);
    }

    public boolean hasAccessPermission(Identity identity, String ownerType, String ownerId, Stream<String> expressionsStream) {
        if (PortalConfig.GROUP_TEMPLATE.equalsIgnoreCase(ownerType)) {
            SpaceTemplate spaceTemplate = this.getSpaceTemplateService().getSpaceTemplateByLayout(ownerId);
            return spaceTemplate == null ? this.isAdministrator(identity) : this.isSpacesAdministrator(identity);
        }
        return this.isSpacesAdministrator(identity, ownerType, ownerId) || super.hasAccessPermission(identity, ownerType, ownerId, expressionsStream);
    }

    private boolean isSpacesAdministrator(Identity identity, String ownerType, String ownerId) {
        return this.isSpaceSite(ownerType, ownerId) && this.isSpacesAdministrator(identity);
    }

    private boolean isSpacesAdministrator(Identity identity) {
        if (this.isAdministrator(identity)) {
            return true;
        }
        List spacesAdministrators = this.getSpacesAdministrationService().getSpacesAdministratorsMemberships();
        return CollectionUtils.isNotEmpty((Collection)spacesAdministrators) && spacesAdministrators.stream().anyMatch(permission -> this.isMemberOf(identity, permission.toString()));
    }

    private boolean isSpaceSite(String ownerType, String ownerId) {
        return PortalConfig.GROUP_TYPE.equalsIgnoreCase(ownerType) && StringUtils.startsWith((CharSequence)ownerId, (CharSequence)"/spaces/");
    }

    private SpacesAdministrationService getSpacesAdministrationService() {
        if (this.spacesAdministrationService == null) {
            this.spacesAdministrationService = (SpacesAdministrationService)ExoContainerContext.getService(SpacesAdministrationService.class);
        }
        return this.spacesAdministrationService;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    public SpaceTemplateService getSpaceTemplateService() {
        if (this.spaceTemplateService == null) {
            this.spaceTemplateService = (SpaceTemplateService)ExoContainerContext.getService(SpaceTemplateService.class);
        }
        return this.spaceTemplateService;
    }

    @Generated
    public void setSpacesAdministrationService(SpacesAdministrationService spacesAdministrationService) {
        this.spacesAdministrationService = spacesAdministrationService;
    }

    @Generated
    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @Generated
    public void setSpaceTemplateService(SpaceTemplateService spaceTemplateService) {
        this.spaceTemplateService = spaceTemplateService;
    }
}

