/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import lombok.Generated;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.SiteBody;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.BodyData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.PageData;

public abstract class ModelObject {
    protected String storageId;
    protected String storageName;
    protected String width;
    protected String height;
    protected String cssClass;
    protected ModelStyle cssStyle;

    protected ModelObject(String storageId) {
        this.storageId = storageId;
    }

    protected ModelObject() {
        this.storageId = null;
    }

    public void checkStorage() throws ObjectNotFoundException {
    }

    public void resetStorage() throws ObjectNotFoundException {
        this.checkStorage();
        this.storageId = null;
        this.storageName = null;
    }

    public abstract ModelData build();

    public static ModelObject build(ModelData data) {
        if (data instanceof ContainerData) {
            ContainerData containerData = (ContainerData)data;
            return new Container(containerData);
        }
        if (data instanceof PageData) {
            PageData pageData = (PageData)data;
            return new Page(pageData);
        }
        if (data instanceof BodyData) {
            BodyData bodyData = (BodyData)data;
            switch (bodyData.getType()) {
                case PAGE: {
                    return new PageBody(data.getStorageId());
                }
                case SITE: {
                    return new SiteBody(data.getStorageId());
                }
            }
            throw new AssertionError();
        }
        if (data instanceof ApplicationData) {
            ApplicationData applicationData = (ApplicationData)data;
            return Application.createPortletApplication(applicationData);
        }
        return null;
    }

    @Generated
    public String getStorageId() {
        return this.storageId;
    }

    @Generated
    public String getStorageName() {
        return this.storageName;
    }

    @Generated
    public String getWidth() {
        return this.width;
    }

    @Generated
    public String getHeight() {
        return this.height;
    }

    @Generated
    public String getCssClass() {
        return this.cssClass;
    }

    @Generated
    public ModelStyle getCssStyle() {
        return this.cssStyle;
    }

    @Generated
    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    @Generated
    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    @Generated
    public void setWidth(String width) {
        this.width = width;
    }

    @Generated
    public void setHeight(String height) {
        this.height = height;
    }

    @Generated
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Generated
    public void setCssStyle(ModelStyle cssStyle) {
        this.cssStyle = cssStyle;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelObject)) {
            return false;
        }
        ModelObject other = (ModelObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$storageId = this.getStorageId();
        String other$storageId = other.getStorageId();
        if (this$storageId == null ? other$storageId != null : !this$storageId.equals(other$storageId)) {
            return false;
        }
        String this$storageName = this.getStorageName();
        String other$storageName = other.getStorageName();
        if (this$storageName == null ? other$storageName != null : !this$storageName.equals(other$storageName)) {
            return false;
        }
        String this$width = this.getWidth();
        String other$width = other.getWidth();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) {
            return false;
        }
        String this$height = this.getHeight();
        String other$height = other.getHeight();
        if (this$height == null ? other$height != null : !this$height.equals(other$height)) {
            return false;
        }
        String this$cssClass = this.getCssClass();
        String other$cssClass = other.getCssClass();
        if (this$cssClass == null ? other$cssClass != null : !this$cssClass.equals(other$cssClass)) {
            return false;
        }
        ModelStyle this$cssStyle = this.getCssStyle();
        ModelStyle other$cssStyle = other.getCssStyle();
        return !(this$cssStyle == null ? other$cssStyle != null : !this$cssStyle.equals(other$cssStyle));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $storageId = this.getStorageId();
        result = result * 59 + ($storageId == null ? 43 : $storageId.hashCode());
        String $storageName = this.getStorageName();
        result = result * 59 + ($storageName == null ? 43 : $storageName.hashCode());
        String $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : $width.hashCode());
        String $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : $height.hashCode());
        String $cssClass = this.getCssClass();
        result = result * 59 + ($cssClass == null ? 43 : $cssClass.hashCode());
        ModelStyle $cssStyle = this.getCssStyle();
        result = result * 59 + ($cssStyle == null ? 43 : $cssStyle.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModelObject(storageId=" + this.getStorageId() + ", storageName=" + this.getStorageName() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", cssClass=" + this.getCssClass() + ", cssStyle=" + String.valueOf(this.getCssStyle()) + ")";
    }
}

