/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.util.BitSet;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractEntityResultGraphNode
extends AbstractFetchParent
implements EntityResultGraphNode {
    private Fetch identifierFetch;
    private BasicFetch<?> discriminatorFetch;
    private DomainResult<Object> rowIdResult;
    private final EntityValuedModelPart fetchContainer;

    public AbstractEntityResultGraphNode(EntityValuedModelPart referencedModelPart, NavigablePath navigablePath) {
        super(navigablePath);
        this.fetchContainer = referencedModelPart;
    }

    @Override
    public void afterInitialize(FetchParent fetchParent, DomainResultCreationState creationState) {
        NavigablePath navigablePath = this.getNavigablePath();
        TableGroup entityTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        EntityResultGraphNode entityResultGraphNode = (EntityResultGraphNode)fetchParent;
        Fetch idFetch = creationState.visitIdentifierFetch(entityResultGraphNode);
        this.identifierFetch = navigablePath.getParent() == null && !creationState.forceIdentifierSelection() && (idFetch.asFetchParent() == null || !idFetch.asFetchParent().containsCollectionFetches()) ? null : idFetch;
        this.discriminatorFetch = creationState.visitDiscriminatorFetch(entityResultGraphNode);
        EntityRowIdMapping rowIdMapping = this.getEntityValuedModelPart().getEntityMappingType().getRowIdMapping();
        this.rowIdResult = rowIdMapping == null ? null : rowIdMapping.createDomainResult(navigablePath.append(rowIdMapping.getRowIdName()), entityTableGroup, "rowid_", creationState);
        super.afterInitialize(fetchParent, creationState);
    }

    @Override
    public EntityMappingType getReferencedMappingContainer() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.fetchContainer;
    }

    @Override
    public FetchableContainer getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getEntityValuedModelPart().getEntityMappingType().getMappedJavaType();
    }

    public Fetch getIdentifierFetch() {
        return this.identifierFetch;
    }

    public BasicFetch<?> getDiscriminatorFetch() {
        return this.discriminatorFetch;
    }

    public DomainResult<Object> getRowIdResult() {
        return this.rowIdResult;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        EntityPersister entityPersister = this.fetchContainer.getEntityMappingType().getEntityPersister();
        this.identifierFetch.collectValueIndexesToCache(valueIndexes);
        if (!entityPersister.useShallowQueryCacheLayout()) {
            if (this.discriminatorFetch != null) {
                this.discriminatorFetch.collectValueIndexesToCache(valueIndexes);
            }
            if (this.rowIdResult != null) {
                this.rowIdResult.collectValueIndexesToCache(valueIndexes);
            }
            super.collectValueIndexesToCache(valueIndexes);
        } else if (entityPersister.storeDiscriminatorInShallowQueryCacheLayout() && this.discriminatorFetch != null) {
            this.discriminatorFetch.collectValueIndexesToCache(valueIndexes);
        }
    }
}

