/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.pom.data.PortalData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class PortalConfig
extends ModelObject
implements Cloneable,
IUnmarshallable,
IMarshallable {
    public static final String USER_TYPE = SiteType.USER.getName();
    public static final String GROUP_TYPE = SiteType.GROUP.getName();
    public static final String PORTAL_TYPE = SiteType.PORTAL.getName();
    public static final String SPACE_TYPE = SiteType.SPACE.getName();
    public static final String GROUP_TEMPLATE = SiteType.GROUP_TEMPLATE.getName();
    public static final Container DEFAULT_LAYOUT = PortalConfig.initDefaultLayout();
    private String name;
    private String type;
    private String locale;
    private String label;
    private String description;
    private String[] accessPermissions;
    private String editPermission;
    private Properties properties;
    private String skin;
    private Container portalLayout;
    private boolean defaultLayout;
    private boolean displayed = true;
    private int displayOrder;
    private String bannerUploadId;
    private long bannerFileId;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.config.model.JiBX_bindingFactory|";

    public PortalConfig() {
        this(PORTAL_TYPE);
    }

    public PortalConfig(String type) {
        this(type, null);
    }

    public PortalConfig(String type, String ownerId) {
        this(type, ownerId, null);
    }

    public PortalConfig(String type, String ownerId, String storageId) {
        super(storageId);
        this.type = type;
        this.name = ownerId;
        this.portalLayout = new Container();
    }

    public PortalConfig(PortalData data) {
        super(data.getStorageId());
        this.name = data.getName();
        this.type = data.getType();
        this.locale = data.getLocale();
        this.label = data.getLabel();
        this.description = data.getDescription();
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
        this.editPermission = data.getEditPermission();
        this.properties = data.getProperties() == null ? new Properties() : new Properties(data.getProperties());
        this.skin = data.getSkin();
        this.portalLayout = new Container(data.getPortalLayout());
        this.defaultLayout = data.isDefaultLayout();
        this.displayed = data.isDisplayed();
        this.displayOrder = data.getDisplayOrder();
        this.bannerFileId = data.getBannerFileId();
    }

    public long getId() {
        if (StringUtils.contains((CharSequence)this.storageId, (CharSequence)"_")) {
            return Long.parseLong(this.storageId.split("_")[1]);
        }
        return 0L;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] s) {
        this.accessPermissions = s;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    public Container getPortalLayout() {
        return this.portalLayout;
    }

    public void setPortalLayout(Container container) {
        this.portalLayout = container;
    }

    public boolean isDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(boolean defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.properties == null || !this.properties.containsKey(name)) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void setProperty(String name, String value) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.setProperty(name, value);
    }

    public void removeProperty(String name) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.remove(name);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public String getBannerUploadId() {
        return this.bannerUploadId;
    }

    public void setBannerUploadId(String bannerUploadId) {
        this.bannerUploadId = bannerUploadId;
    }

    public long getBannerFileId() {
        return this.bannerFileId;
    }

    public void setBannerFileId(long bannerFileId) {
        this.bannerFileId = bannerFileId;
    }

    @Override
    public String toString() {
        return "PortalConfig[name=" + this.name + ",type=" + this.type + "]";
    }

    public PortalConfig clone() {
        return new PortalConfig(this.build());
    }

    private static Container initDefaultLayout() {
        Container container = new Container();
        ArrayList<ModelObject> children = new ArrayList<ModelObject>();
        children.add(new PageBody());
        container.setChildren(children);
        return container;
    }

    @Override
    public PortalData build() {
        return new PortalData(this.storageId, this.name, this.type, this.locale, this.label, this.description, this.accessPermissions == null ? Collections.emptyList() : Arrays.asList(this.accessPermissions), this.editPermission, this.properties == null ? Collections.emptyMap() : new Properties(this.properties), this.skin, this.portalLayout.build(), this.defaultLayout, this.displayed, this.displayOrder, this.bannerFileId);
    }

    @Override
    public void resetStorage() throws ObjectNotFoundException {
        super.resetStorage();
        this.getPortalLayout().resetStorage();
    }

    public void useMetaPortalLayout() {
        this.setPortalLayout(PortalConfig.initDefaultLayout());
        this.setDefaultLayout(true);
    }

    public boolean isDefaultSite() {
        return !StringUtils.equals((CharSequence)this.getProperty("NO_DEFAULT_PATH"), (CharSequence)"true");
    }

    public void setDefaultSite(boolean defaultSite) {
        this.setProperty("NO_DEFAULT_PATH", String.valueOf(!defaultSite));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PortalConfig)) {
            return false;
        }
        PortalConfig other = (PortalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefaultLayout() != other.isDefaultLayout()) {
            return false;
        }
        if (this.isDisplayed() != other.isDisplayed()) {
            return false;
        }
        if (this.getDisplayOrder() != other.getDisplayOrder()) {
            return false;
        }
        if (this.getBannerFileId() != other.getBannerFileId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAccessPermissions(), other.getAccessPermissions())) {
            return false;
        }
        String this$editPermission = this.getEditPermission();
        String other$editPermission = other.getEditPermission();
        if (this$editPermission == null ? other$editPermission != null : !this$editPermission.equals(other$editPermission)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$skin = this.getSkin();
        String other$skin = other.getSkin();
        if (this$skin == null ? other$skin != null : !this$skin.equals(other$skin)) {
            return false;
        }
        Container this$portalLayout = this.getPortalLayout();
        Container other$portalLayout = other.getPortalLayout();
        if (this$portalLayout == null ? other$portalLayout != null : !((Object)this$portalLayout).equals(other$portalLayout)) {
            return false;
        }
        String this$bannerUploadId = this.getBannerUploadId();
        String other$bannerUploadId = other.getBannerUploadId();
        return !(this$bannerUploadId == null ? other$bannerUploadId != null : !this$bannerUploadId.equals(other$bannerUploadId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PortalConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefaultLayout() ? 79 : 97);
        result = result * 59 + (this.isDisplayed() ? 79 : 97);
        result = result * 59 + this.getDisplayOrder();
        long $bannerFileId = this.getBannerFileId();
        result = result * 59 + (int)($bannerFileId >>> 32 ^ $bannerFileId);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAccessPermissions());
        String $editPermission = this.getEditPermission();
        result = result * 59 + ($editPermission == null ? 43 : $editPermission.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $skin = this.getSkin();
        result = result * 59 + ($skin == null ? 43 : $skin.hashCode());
        Container $portalLayout = this.getPortalLayout();
        result = result * 59 + ($portalLayout == null ? 43 : ((Object)$portalLayout).hashCode());
        String $bannerUploadId = this.getBannerUploadId();
        result = result * 59 + ($bannerUploadId == null ? 43 : $bannerUploadId.hashCode());
        return result;
    }

    public /* synthetic */ void JiBX_access_store_name_2_0(String arg1) {
        this.name = arg1;
    }

    public /* synthetic */ void JiBX_access_store_label_2_0(String arg1) {
        this.label = arg1;
    }

    public /* synthetic */ void JiBX_access_store_description_2_0(String arg1) {
        this.description = arg1;
    }

    public /* synthetic */ void JiBX_access_store_locale_2_0(String arg1) {
        this.locale = arg1;
    }

    public /* synthetic */ void JiBX_access_store_accessPermissions_2_0(String[] arg1) {
        this.accessPermissions = arg1;
    }

    public /* synthetic */ void JiBX_access_store_editPermission_2_0(String arg1) {
        this.editPermission = arg1;
    }

    public /* synthetic */ void JiBX_access_store_skin_2_0(String arg1) {
        this.skin = arg1;
    }

    public /* synthetic */ void JiBX_access_store_displayed_2_0(boolean arg1) {
        this.displayed = arg1;
    }

    public /* synthetic */ void JiBX_access_store_displayOrder_2_0(int arg1) {
        this.displayOrder = arg1;
    }

    public /* synthetic */ Properties JiBX_access_load_properties_2_0() {
        return this.properties;
    }

    public /* synthetic */ void JiBX_access_store_properties_2_0(Properties arg1) {
        this.properties = arg1;
    }

    public /* synthetic */ Container JiBX_access_load_portalLayout_2_0() {
        return this.portalLayout;
    }

    public /* synthetic */ void JiBX_access_store_portalLayout_2_0(Container arg1) {
        this.portalLayout = arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.PortalConfig").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.PortalConfig";
    }

    public /* synthetic */ String JiBX_access_load_name_2_0() {
        return this.name;
    }

    public /* synthetic */ String JiBX_access_load_label_2_0() {
        return this.label;
    }

    public /* synthetic */ String JiBX_access_load_description_2_0() {
        return this.description;
    }

    public /* synthetic */ String JiBX_access_load_locale_2_0() {
        return this.locale;
    }

    public /* synthetic */ String[] JiBX_access_load_accessPermissions_2_0() {
        return this.accessPermissions;
    }

    public /* synthetic */ String JiBX_access_load_editPermission_2_0() {
        return this.editPermission;
    }

    public /* synthetic */ String JiBX_access_load_skin_2_0() {
        return this.skin;
    }

    public /* synthetic */ boolean JiBX_access_load_displayed_2_0() {
        return this.displayed;
    }

    public /* synthetic */ int JiBX_access_load_displayOrder_2_0() {
        return this.displayOrder;
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.PortalConfig").marshal((Object)this, arg1);
    }
}

