/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.observe.storage;

import io.meeds.social.observe.model.Observer;
import io.meeds.social.observe.model.ObserverObject;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;

public class ObserverStorage {
    private static final String METADATA_NAME = "observers";
    public static final MetadataType METADATA_TYPE = new MetadataType((long)"observers".hashCode(), "observers");
    private MetadataService metadataService;

    public ObserverStorage(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public List<ObserverObject> getObservedObjects(long identityId, long offset, long limit) {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndCreator(METADATA_TYPE.getName(), identityId, offset, limit);
        return metadataItems.stream().map(MetadataItem::getObject).map(ObserverObject::new).toList();
    }

    public List<Long> getObserverIdentityIds(String objectType, String objectId) {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(METADATA_TYPE.getName(), new MetadataObject(objectType, objectId));
        return metadataItems.stream().map(MetadataItem::getCreatorId).toList();
    }

    public void createObserver(Observer observer) throws ObjectAlreadyExistsException {
        long identityId = observer.getIdentityId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE.getName(), String.valueOf(identityId), identityId);
        ObserverObject object = observer.getObject();
        this.metadataService.createMetadataItem((MetadataObject)object, metadataKey, identityId);
    }

    public void deleteObserver(Observer observer) throws ObjectNotFoundException {
        long userIdentityId = observer.getIdentityId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE.getName(), String.valueOf(userIdentityId), userIdentityId);
        List observers = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, (MetadataObject)observer.getObject());
        if (CollectionUtils.isNotEmpty((Collection)observers)) {
            for (MetadataItem observerItem : observers) {
                this.metadataService.deleteMetadataItem(observerItem.getId(), userIdentityId);
            }
        }
    }

    public boolean isObserved(long identityId, String objectType, String objectId) {
        List observerItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(String.valueOf(identityId), METADATA_TYPE.getName(), objectType, objectId, 0L, 1L);
        return !observerItems.isEmpty();
    }
}

