/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.exoplatform.commons.utils.Text;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.portlet.PortletExceptionHandleService;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;

public class UIPortletLifecycle
extends Lifecycle<UIPortlet> {
    protected static final Log LOG = ExoLogger.getLogger((String)"portal:UIPortletLifecycle");

    @Override
    public void processAction(UIPortlet uicomponent, WebuiRequestContext context) throws Exception {
        try {
            Event<UIComponent> event;
            String portletActionType;
            Event<UIComponent> event2;
            String windowState;
            Event<UIComponent> event3;
            PortletMode currentPortletMode = uicomponent.getCurrentPortletMode();
            WindowState currentWindowState = uicomponent.getCurrentWindowState();
            String action = context.getRequestParameter("portal:action");
            if (action != null) {
                Event<UIComponent> event4 = uicomponent.createEvent(action, Event.Phase.PROCESS, context);
                if (event4 != null) {
                    event4.broadcast();
                }
                return;
            }
            String portletMode = context.getRequestParameter("portal:portletMode");
            if (portletMode != null && (event3 = uicomponent.createEvent("ChangePortletMode", Event.Phase.PROCESS, context)) != null) {
                event3.broadcast();
            }
            if ((windowState = context.getRequestParameter("portal:windowState")) != null && (event2 = uicomponent.createEvent("ChangeWindowState", Event.Phase.PROCESS, context)) != null) {
                event2.broadcast();
            }
            if ((portletActionType = context.getRequestParameter("portal:type")) != null) {
                if (portletActionType.equals("action")) {
                    event = uicomponent.createEvent("ProcessAction", Event.Phase.PROCESS, context);
                    if (event != null) {
                        event.broadcast();
                    }
                } else if (portletActionType.equals("resource") && (event = uicomponent.createEvent("ServeResource", Event.Phase.PROCESS, context)) != null) {
                    event.broadcast();
                }
            } else {
                event = uicomponent.createEvent("Render", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
            }
            if (currentPortletMode != null && !currentPortletMode.equals((Object)uicomponent.getCurrentPortletMode())) {
                context.setAttribute("ChangePortletModeEvent", uicomponent.getCurrentPortletMode().toString());
                event = uicomponent.createEvent("ChangePortletMode", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
                context.setAttribute("ChangePortletModeEvent", null);
            }
            if (currentWindowState != null && !currentWindowState.equals((Object)uicomponent.getCurrentWindowState())) {
                context.setAttribute("PortletChangeWindowStateEvent", uicomponent.getCurrentWindowState().toString());
                event = uicomponent.createEvent("ChangeWindowState", Event.Phase.PROCESS, context);
                if (event != null) {
                    event.broadcast();
                }
                context.setAttribute("PortletChangeWindowStateEvent", null);
            }
            context.addUIComponentToUpdateByAjax(uicomponent);
        }
        catch (NoSuchDataException e) {
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            uiApp.refreshCachedUI();
            ApplicationMessage msg = new ApplicationMessage("UIPortlet.message.staleData", null, 1);
            uiApp.addMessage(msg);
        }
        catch (Exception e) {
            String message = e.getLocalizedMessage();
            LOG.error((Object)("Error processing the action: " + message), (Throwable)e);
            Object[] args = new Object[]{message};
            context.addUIComponentToUpdateByAjax(uicomponent);
            throw new MessageException(new ApplicationMessage("UIPortletLifecycle.msg.process-error", args, 0));
        }
    }

    @Override
    public void processRender(UIPortlet uicomponent, WebuiRequestContext context) throws Exception {
        PortalRequestContext portalRequestContext = PortalRequestContext.getCurrentInstance();
        String key = "UIPortlet_" + uicomponent.getApplicationId().split("/")[1] + "_" + uicomponent.getStorageId();
        boolean started = portalRequestContext.startServerTime(key);
        PortalRequestContext prcontext = (PortalRequestContext)context;
        Text markup = null;
        try {
            Map paramMap = prcontext.getRequest().getParameterMap();
            if (paramMap.containsKey("removePP")) {
                UIPortal uiPortal = Util.getUIPortal();
                for (String publicParamName : (String[])paramMap.get("removePP")) {
                    uiPortal.getPublicParameters().remove(publicParamName);
                }
            }
            RenderInvocation renderInvocation = uicomponent.create(RenderInvocation.class, prcontext);
            String appStatus = (String)uicomponent.getProperties().get((Object)"appStatus");
            if ("Window".equals(uicomponent.getPortletStyle()) && !"SHOW".equals(appStatus) && !"HIDE".equals(appStatus)) {
                markup = Text.create((String)"<span></span>");
            } else if (uicomponent.hasAccessPermission()) {
                PortletInvocationResponse response = uicomponent.invoke((PortletInvocation)renderInvocation);
                markup = uicomponent.generateRenderMarkup(response, prcontext);
            } else {
                markup = Text.create((String)"");
            }
        }
        catch (Exception e) {
            PortletContainerException pcException = new PortletContainerException((Throwable)e);
            PortletExceptionHandleService portletExceptionService = uicomponent.getApplicationComponent(PortletExceptionHandleService.class);
            if (portletExceptionService != null) {
                portletExceptionService.handle(pcException);
            }
            if (e instanceof NoSuchDataException) {
                UIPortalApplication uiApp = Util.getUIPortalApplication();
                uiApp.refreshCachedUI();
                markup = Text.create((String)context.getApplicationResourceBundle().getString("UIPortlet.message.staleData"));
            }
            if (e instanceof NoSuchPortletException) {
                markup = Text.create((String)"");
            }
            LOG.error("Portlet render threw an exception in page {}", new Object[]{prcontext.getRequest().getRequestURI(), pcException});
            markup = Text.create((String)context.getApplicationResourceBundle().getString("UIPortlet.message.RuntimeError"));
        }
        if (context.useAjax() && !prcontext.getFullRender()) {
            if (markup != null) {
                markup.writeTo(prcontext.getWriter());
            }
        } else {
            WebuiApplication app = (WebuiApplication)prcontext.getApplication();
            ApplicationResourceResolver resolver = app.getResourceResolver();
            WebuiBindingContext bcontext = new WebuiBindingContext((ResourceResolver)resolver, context.getWriter(), uicomponent, prcontext);
            bcontext.put("uicomponent", uicomponent);
            bcontext.put("portletContent", markup);
            try {
                this.renderTemplate(uicomponent.getTemplate(), bcontext);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getMessage(), e);
            }
        }
        if (started) {
            portalRequestContext.endServerTime(key);
        }
    }
}

