/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens.contracts.generated;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple2;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class PublicResolver
extends Contract {
    public static final String BINARY = "Bin file was not provided";
    public static final String FUNC_ABI = "ABI";
    public static final String FUNC_addr = "addr";
    public static final String FUNC_CLEARDNSZONE = "clearDNSZone";
    public static final String FUNC_CONTENTHASH = "contenthash";
    public static final String FUNC_DNSRECORD = "dnsRecord";
    public static final String FUNC_HASDNSRECORDS = "hasDNSRecords";
    public static final String FUNC_INTERFACEIMPLEMENTER = "interfaceImplementer";
    public static final String FUNC_ISAPPROVEDFORALL = "isApprovedForAll";
    public static final String FUNC_MULTICALL = "multicall";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_PUBKEY = "pubkey";
    public static final String FUNC_SETABI = "setABI";
    public static final String FUNC_setAddr = "setAddr";
    public static final String FUNC_SETAPPROVALFORALL = "setApprovalForAll";
    public static final String FUNC_SETCONTENTHASH = "setContenthash";
    public static final String FUNC_SETDNSRECORDS = "setDNSRecords";
    public static final String FUNC_SETINTERFACE = "setInterface";
    public static final String FUNC_SETNAME = "setName";
    public static final String FUNC_SETPUBKEY = "setPubkey";
    public static final String FUNC_SETTEXT = "setText";
    public static final String FUNC_SETZONEHASH = "setZonehash";
    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";
    public static final String FUNC_TEXT = "text";
    public static final String FUNC_ZONEHASH = "zonehash";
    public static final Event ABICHANGED_EVENT = new Event("ABIChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Uint256>(true){}));
    public static final Event ADDRCHANGED_EVENT = new Event("AddrChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Address>(){}));
    public static final Event ADDRESSCHANGED_EVENT = new Event("AddressChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Uint256>(){}, new TypeReference<DynamicBytes>(){}));
    public static final Event APPROVALFORALL_EVENT = new Event("ApprovalForAll", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Bool>(){}));
    public static final Event CONTENTHASHCHANGED_EVENT = new Event("ContenthashChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<DynamicBytes>(){}));
    public static final Event DNSRECORDCHANGED_EVENT = new Event("DNSRecordChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<DynamicBytes>(){}, new TypeReference<Uint16>(){}, new TypeReference<DynamicBytes>(){}));
    public static final Event DNSRECORDDELETED_EVENT = new Event("DNSRecordDeleted", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<DynamicBytes>(){}, new TypeReference<Uint16>(){}));
    public static final Event DNSZONECLEARED_EVENT = new Event("DNSZoneCleared", Arrays.asList(new TypeReference<Bytes32>(true){}));
    public static final Event DNSZONEHASHCHANGED_EVENT = new Event("DNSZonehashChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<DynamicBytes>(){}, new TypeReference<DynamicBytes>(){}));
    public static final Event INTERFACECHANGED_EVENT = new Event("InterfaceChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Bytes4>(true){}, new TypeReference<Address>(){}));
    public static final Event NAMECHANGED_EVENT = new Event("NameChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Utf8String>(){}));
    public static final Event PUBKEYCHANGED_EVENT = new Event("PubkeyChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Bytes32>(){}, new TypeReference<Bytes32>(){}));
    public static final Event TEXTCHANGED_EVENT = new Event("TextChanged", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Utf8String>(true){}, new TypeReference<Utf8String>(){}));

    @Deprecated
    protected PublicResolver(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected PublicResolver(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected PublicResolver(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected PublicResolver(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ABIChangedEventResponse> getABIChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(ABICHANGED_EVENT, transactionReceipt);
        ArrayList<ABIChangedEventResponse> responses = new ArrayList<ABIChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ABIChangedEventResponse typedResponse = new ABIChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.contentType = (BigInteger)eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ABIChangedEventResponse> aBIChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ABIChangedEventResponse>(){

            public ABIChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(ABICHANGED_EVENT, log);
                ABIChangedEventResponse typedResponse = new ABIChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.contentType = (BigInteger)eventValues.getIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ABIChangedEventResponse> aBIChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ABICHANGED_EVENT));
        return this.aBIChangedEventFlowable(filter);
    }

    public List<AddrChangedEventResponse> getAddrChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(ADDRCHANGED_EVENT, transactionReceipt);
        ArrayList<AddrChangedEventResponse> responses = new ArrayList<AddrChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddrChangedEventResponse typedResponse = new AddrChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.a = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AddrChangedEventResponse> addrChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, AddrChangedEventResponse>(){

            public AddrChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(ADDRCHANGED_EVENT, log);
                AddrChangedEventResponse typedResponse = new AddrChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.a = (String)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AddrChangedEventResponse> addrChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADDRCHANGED_EVENT));
        return this.addrChangedEventFlowable(filter);
    }

    public List<AddressChangedEventResponse> getAddressChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(ADDRESSCHANGED_EVENT, transactionReceipt);
        ArrayList<AddressChangedEventResponse> responses = new ArrayList<AddressChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddressChangedEventResponse typedResponse = new AddressChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.coinType = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.newAddress = (byte[])eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AddressChangedEventResponse> addressChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, AddressChangedEventResponse>(){

            public AddressChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(ADDRESSCHANGED_EVENT, log);
                AddressChangedEventResponse typedResponse = new AddressChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.coinType = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.newAddress = (byte[])eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AddressChangedEventResponse> addressChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADDRESSCHANGED_EVENT));
        return this.addressChangedEventFlowable(filter);
    }

    public List<ApprovalForAllEventResponse> getApprovalForAllEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(APPROVALFORALL_EVENT, transactionReceipt);
        ArrayList<ApprovalForAllEventResponse> responses = new ArrayList<ApprovalForAllEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.operator = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.approved = (Boolean)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalForAllEventResponse>(){

            public ApprovalForAllEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(APPROVALFORALL_EVENT, log);
                ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
                typedResponse.log = log;
                typedResponse.owner = (String)eventValues.getIndexedValues().get(0).getValue();
                typedResponse.operator = (String)eventValues.getIndexedValues().get(1).getValue();
                typedResponse.approved = (Boolean)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVALFORALL_EVENT));
        return this.approvalForAllEventFlowable(filter);
    }

    public List<ContenthashChangedEventResponse> getContenthashChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(CONTENTHASHCHANGED_EVENT, transactionReceipt);
        ArrayList<ContenthashChangedEventResponse> responses = new ArrayList<ContenthashChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContenthashChangedEventResponse typedResponse = new ContenthashChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.hash = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContenthashChangedEventResponse> contenthashChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ContenthashChangedEventResponse>(){

            public ContenthashChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(CONTENTHASHCHANGED_EVENT, log);
                ContenthashChangedEventResponse typedResponse = new ContenthashChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.hash = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ContenthashChangedEventResponse> contenthashChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTENTHASHCHANGED_EVENT));
        return this.contenthashChangedEventFlowable(filter);
    }

    public List<DNSRecordChangedEventResponse> getDNSRecordChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(DNSRECORDCHANGED_EVENT, transactionReceipt);
        ArrayList<DNSRecordChangedEventResponse> responses = new ArrayList<DNSRecordChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DNSRecordChangedEventResponse typedResponse = new DNSRecordChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.name = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.resource = (BigInteger)eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.record = (byte[])eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DNSRecordChangedEventResponse> dNSRecordChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DNSRecordChangedEventResponse>(){

            public DNSRecordChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(DNSRECORDCHANGED_EVENT, log);
                DNSRecordChangedEventResponse typedResponse = new DNSRecordChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.name = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.resource = (BigInteger)eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.record = (byte[])eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DNSRecordChangedEventResponse> dNSRecordChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DNSRECORDCHANGED_EVENT));
        return this.dNSRecordChangedEventFlowable(filter);
    }

    public List<DNSRecordDeletedEventResponse> getDNSRecordDeletedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(DNSRECORDDELETED_EVENT, transactionReceipt);
        ArrayList<DNSRecordDeletedEventResponse> responses = new ArrayList<DNSRecordDeletedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DNSRecordDeletedEventResponse typedResponse = new DNSRecordDeletedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.name = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.resource = (BigInteger)eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DNSRecordDeletedEventResponse> dNSRecordDeletedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DNSRecordDeletedEventResponse>(){

            public DNSRecordDeletedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(DNSRECORDDELETED_EVENT, log);
                DNSRecordDeletedEventResponse typedResponse = new DNSRecordDeletedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.name = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.resource = (BigInteger)eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DNSRecordDeletedEventResponse> dNSRecordDeletedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DNSRECORDDELETED_EVENT));
        return this.dNSRecordDeletedEventFlowable(filter);
    }

    public List<DNSZoneClearedEventResponse> getDNSZoneClearedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(DNSZONECLEARED_EVENT, transactionReceipt);
        ArrayList<DNSZoneClearedEventResponse> responses = new ArrayList<DNSZoneClearedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DNSZoneClearedEventResponse typedResponse = new DNSZoneClearedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DNSZoneClearedEventResponse> dNSZoneClearedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DNSZoneClearedEventResponse>(){

            public DNSZoneClearedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(DNSZONECLEARED_EVENT, log);
                DNSZoneClearedEventResponse typedResponse = new DNSZoneClearedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DNSZoneClearedEventResponse> dNSZoneClearedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DNSZONECLEARED_EVENT));
        return this.dNSZoneClearedEventFlowable(filter);
    }

    public List<DNSZonehashChangedEventResponse> getDNSZonehashChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(DNSZONEHASHCHANGED_EVENT, transactionReceipt);
        ArrayList<DNSZonehashChangedEventResponse> responses = new ArrayList<DNSZonehashChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DNSZonehashChangedEventResponse typedResponse = new DNSZonehashChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.lastzonehash = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.zonehash = (byte[])eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DNSZonehashChangedEventResponse> dNSZonehashChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DNSZonehashChangedEventResponse>(){

            public DNSZonehashChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(DNSZONEHASHCHANGED_EVENT, log);
                DNSZonehashChangedEventResponse typedResponse = new DNSZonehashChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.lastzonehash = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.zonehash = (byte[])eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DNSZonehashChangedEventResponse> dNSZonehashChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DNSZONEHASHCHANGED_EVENT));
        return this.dNSZonehashChangedEventFlowable(filter);
    }

    public List<InterfaceChangedEventResponse> getInterfaceChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(INTERFACECHANGED_EVENT, transactionReceipt);
        ArrayList<InterfaceChangedEventResponse> responses = new ArrayList<InterfaceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InterfaceChangedEventResponse typedResponse = new InterfaceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.interfaceID = (byte[])eventValues.getIndexedValues().get(1).getValue();
            typedResponse.implementer = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<InterfaceChangedEventResponse> interfaceChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, InterfaceChangedEventResponse>(){

            public InterfaceChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(INTERFACECHANGED_EVENT, log);
                InterfaceChangedEventResponse typedResponse = new InterfaceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.interfaceID = (byte[])eventValues.getIndexedValues().get(1).getValue();
                typedResponse.implementer = (String)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<InterfaceChangedEventResponse> interfaceChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)INTERFACECHANGED_EVENT));
        return this.interfaceChangedEventFlowable(filter);
    }

    public List<NameChangedEventResponse> getNameChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(NAMECHANGED_EVENT, transactionReceipt);
        ArrayList<NameChangedEventResponse> responses = new ArrayList<NameChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NameChangedEventResponse typedResponse = new NameChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.name = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NameChangedEventResponse> nameChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, NameChangedEventResponse>(){

            public NameChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(NAMECHANGED_EVENT, log);
                NameChangedEventResponse typedResponse = new NameChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.name = (String)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NameChangedEventResponse> nameChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NAMECHANGED_EVENT));
        return this.nameChangedEventFlowable(filter);
    }

    public List<PubkeyChangedEventResponse> getPubkeyChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(PUBKEYCHANGED_EVENT, transactionReceipt);
        ArrayList<PubkeyChangedEventResponse> responses = new ArrayList<PubkeyChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            PubkeyChangedEventResponse typedResponse = new PubkeyChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.x = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.y = (byte[])eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<PubkeyChangedEventResponse> pubkeyChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, PubkeyChangedEventResponse>(){

            public PubkeyChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(PUBKEYCHANGED_EVENT, log);
                PubkeyChangedEventResponse typedResponse = new PubkeyChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.x = (byte[])eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.y = (byte[])eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<PubkeyChangedEventResponse> pubkeyChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)PUBKEYCHANGED_EVENT));
        return this.pubkeyChangedEventFlowable(filter);
    }

    public List<TextChangedEventResponse> getTextChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(TEXTCHANGED_EVENT, transactionReceipt);
        ArrayList<TextChangedEventResponse> responses = new ArrayList<TextChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TextChangedEventResponse typedResponse = new TextChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.indexedKey = (byte[])eventValues.getIndexedValues().get(1).getValue();
            typedResponse.key = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TextChangedEventResponse> textChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TextChangedEventResponse>(){

            public TextChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = PublicResolver.this.extractEventParametersWithLog(TEXTCHANGED_EVENT, log);
                TextChangedEventResponse typedResponse = new TextChangedEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.indexedKey = (byte[])eventValues.getIndexedValues().get(1).getValue();
                typedResponse.key = (String)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TextChangedEventResponse> textChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TEXTCHANGED_EVENT));
        return this.textChangedEventFlowable(filter);
    }

    public RemoteFunctionCall<Tuple2<BigInteger, byte[]>> ABI(byte[] node, BigInteger contentTypes) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ABI, Arrays.asList(new Bytes32(node), new Uint256(contentTypes)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<DynamicBytes>(){}));
        return new RemoteFunctionCall<Tuple2<BigInteger, byte[]>>(function, new Callable<Tuple2<BigInteger, byte[]>>(){

            @Override
            public Tuple2<BigInteger, byte[]> call() throws Exception {
                List results = PublicResolver.this.executeCallMultipleValueReturn(function);
                return new Tuple2((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((byte[])((Type)results.get(1)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<String> addr(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_addr, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<byte[]> addr(byte[] node, BigInteger coinType) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_addr, Arrays.asList(new Bytes32(node), new Uint256(coinType)), Arrays.asList(new TypeReference<DynamicBytes>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<TransactionReceipt> clearDNSZone(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CLEARDNSZONE, Arrays.asList(new Bytes32(node)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<byte[]> contenthash(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CONTENTHASH, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<DynamicBytes>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<byte[]> dnsRecord(byte[] node, byte[] name, BigInteger resource) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DNSRECORD, Arrays.asList(new Bytes32(node), new Bytes32(name), new Uint16(resource)), Arrays.asList(new TypeReference<DynamicBytes>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<Boolean> hasDNSRecords(byte[] node, byte[] name) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_HASDNSRECORDS, Arrays.asList(new Bytes32(node), new Bytes32(name)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> interfaceImplementer(byte[] node, byte[] interfaceID) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_INTERFACEIMPLEMENTER, Arrays.asList(new Bytes32(node), new Bytes4(interfaceID)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Boolean> isApprovedForAll(String account, String operator) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDFORALL, Arrays.asList(new Address(160, account), new Address(160, operator)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> multicall(List<byte[]> data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MULTICALL, Arrays.asList(new DynamicArray(DynamicBytes.class, Utils.typeMap(data, DynamicBytes.class))), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> name(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Tuple2<byte[], byte[]>> pubkey(byte[] node) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PUBKEY, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<Bytes32>(){}, new TypeReference<Bytes32>(){}));
        return new RemoteFunctionCall<Tuple2<byte[], byte[]>>(function, new Callable<Tuple2<byte[], byte[]>>(){

            @Override
            public Tuple2<byte[], byte[]> call() throws Exception {
                List results = PublicResolver.this.executeCallMultipleValueReturn(function);
                return new Tuple2((Object)((byte[])((Type)results.get(0)).getValue()), (Object)((byte[])((Type)results.get(1)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> setABI(byte[] node, BigInteger contentType, byte[] data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETABI, Arrays.asList(new Bytes32(node), new Uint256(contentType), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setAddr(byte[] node, BigInteger coinType, byte[] a) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_setAddr, Arrays.asList(new Bytes32(node), new Uint256(coinType), new DynamicBytes(a)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setAddr(byte[] node, String a) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_setAddr, Arrays.asList(new Bytes32(node), new Address(160, a)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setApprovalForAll(String operator, Boolean approved) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETAPPROVALFORALL, Arrays.asList(new Address(160, operator), new Bool(approved)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setContenthash(byte[] node, byte[] hash) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETCONTENTHASH, Arrays.asList(new Bytes32(node), new DynamicBytes(hash)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setDNSRecords(byte[] node, byte[] data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETDNSRECORDS, Arrays.asList(new Bytes32(node), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setInterface(byte[] node, byte[] interfaceID, String implementer) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETINTERFACE, Arrays.asList(new Bytes32(node), new Bytes4(interfaceID), new Address(160, implementer)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setName(byte[] node, String newName) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETNAME, Arrays.asList(new Bytes32(node), new Utf8String(newName)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setPubkey(byte[] node, byte[] x, byte[] y) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETPUBKEY, Arrays.asList(new Bytes32(node), new Bytes32(x), new Bytes32(y)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setText(byte[] node, String key, String value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETTEXT, Arrays.asList(new Bytes32(node), new Utf8String(key), new Utf8String(value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setZonehash(byte[] node, byte[] hash) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETZONEHASH, Arrays.asList(new Bytes32(node), new DynamicBytes(hash)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> supportsInterface(byte[] interfaceID) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SUPPORTSINTERFACE, Arrays.asList(new Bytes4(interfaceID)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> text(byte[] node, String key) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TEXT, Arrays.asList(new Bytes32(node), new Utf8String(key)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<byte[]> zonehash(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ZONEHASH, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<DynamicBytes>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    @Deprecated
    public static PublicResolver load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new PublicResolver(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static PublicResolver load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new PublicResolver(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static PublicResolver load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new PublicResolver(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static PublicResolver load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new PublicResolver(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class TextChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] indexedKey;
        public String key;
    }

    public static class PubkeyChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] x;
        public byte[] y;
    }

    public static class NameChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public String name;
    }

    public static class InterfaceChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] interfaceID;
        public String implementer;
    }

    public static class DNSZonehashChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] lastzonehash;
        public byte[] zonehash;
    }

    public static class DNSZoneClearedEventResponse
    extends BaseEventResponse {
        public byte[] node;
    }

    public static class DNSRecordDeletedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] name;
        public BigInteger resource;
    }

    public static class DNSRecordChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] name;
        public BigInteger resource;
        public byte[] record;
    }

    public static class ContenthashChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] hash;
    }

    public static class ApprovalForAllEventResponse
    extends BaseEventResponse {
        public String owner;
        public String operator;
        public Boolean approved;
    }

    public static class AddressChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public BigInteger coinType;
        public byte[] newAddress;
    }

    public static class AddrChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public String a;
    }

    public static class ABIChangedEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public BigInteger contentType;
    }
}

