/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.ar;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.exoplatform.container.ar.ArchiveURLConnection;

class ArchiveURLStreamHandler
extends URLStreamHandler {
    ArchiveURLStreamHandler() {
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        if (!u.getProtocol().equals("ar")) {
            throw new MalformedURLException("Only the protocol ar is supported");
        }
        if (u.getHost() != null) {
            throw new MalformedURLException("Only local access is supported, so no host is expected");
        }
        String file = u.getFile();
        if (!file.startsWith("/")) {
            throw new MalformedURLException("The path of an archive URL must start with '/'");
        }
        if (file.contains("//")) {
            throw new MalformedURLException("The path of an archive URL cannot contain '//'");
        }
        int fromIndex = file.indexOf("!/");
        if (fromIndex != -1) {
            if (file.endsWith("!/")) {
                throw new MalformedURLException("The path of an archive URL cannot end with the separator '!/'");
            }
            if ((fromIndex = file.indexOf("!/", fromIndex + 2)) != -1 && (fromIndex = file.indexOf("!/", fromIndex + 2)) != -1) {
                throw new MalformedURLException("Only 2 level of achive is supported which means that you cannot use more than twice the separator '!/'");
            }
        }
        if (file.endsWith("/")) {
            throw new MalformedURLException("The path of an archive URL cannot end with '/' as only files are supported");
        }
        return new ArchiveURLConnection(u);
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        this.setURL(u, "ar", null, -1, null, null, spec.substring(start, limit), null, null);
    }
}

