/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.jpa.repository.query.ScrollDelegate;
import org.springframework.data.jpa.repository.support.EntityGraphFactory;
import org.springframework.data.jpa.repository.support.FluentQuerySupport;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;

class FetchableFluentQueryByPredicate<S, R>
extends FluentQuerySupport<S, R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Predicate predicate;
    private final Function<Sort, AbstractJPAQuery<?, ?>> finder;
    private final PredicateScrollDelegate<S> scroll;
    private final BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder;
    private final Function<Predicate, Long> countOperation;
    private final Function<Predicate, Boolean> existsOperation;
    private final EntityManager entityManager;

    FetchableFluentQueryByPredicate(Predicate predicate, Class<S> entityType, Function<Sort, AbstractJPAQuery<?, ?>> finder, PredicateScrollDelegate<S> scroll, BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, EntityManager entityManager, ProjectionFactory projectionFactory) {
        this(predicate, entityType, entityType, Sort.unsorted(), 0, Collections.emptySet(), finder, scroll, pagedFinder, countOperation, existsOperation, entityManager, projectionFactory);
    }

    private FetchableFluentQueryByPredicate(Predicate predicate, Class<S> entityType, Class<R> resultType, Sort sort, int limit, Collection<String> properties, Function<Sort, AbstractJPAQuery<?, ?>> finder, PredicateScrollDelegate<S> scroll, BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, EntityManager entityManager, ProjectionFactory projectionFactory) {
        super(resultType, sort, limit, properties, entityType, projectionFactory);
        this.predicate = predicate;
        this.finder = finder;
        this.scroll = scroll;
        this.pagedFinder = pagedFinder;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
        this.entityManager = entityManager;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.entityType, this.resultType, this.sort.and(sort), this.limit, this.properties, this.finder, this.scroll, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public FluentQuery.FetchableFluentQuery<R> limit(int limit) {
        Assert.isTrue((limit >= 0 ? 1 : 0) != 0, (String)"Limit must not be negative");
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.entityType, this.resultType, this.sort, limit, this.properties, this.finder, this.scroll, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        Assert.notNull(resultType, (String)"Projection target type must not be null");
        if (!resultType.isInterface()) {
            throw new UnsupportedOperationException("Class-based DTOs are not yet supported.");
        }
        return new FetchableFluentQueryByPredicate<S, NR>(this.predicate, this.entityType, resultType, this.sort, this.limit, this.properties, this.finder, this.scroll, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.entityType, this.resultType, this.sort, this.limit, this.mergeProperties(properties), this.finder, this.scroll, this.pagedFinder, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public R oneValue() {
        List results = ((AbstractJPAQuery)this.createSortedAndProjectedQuery().limit(2L)).fetch();
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public R firstValue() {
        List results = ((AbstractJPAQuery)this.createSortedAndProjectedQuery().limit(1L)).fetch();
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public List<R> all() {
        return this.convert(this.createSortedAndProjectedQuery().fetch());
    }

    public Window<R> scroll(ScrollPosition scrollPosition) {
        Assert.notNull((Object)scrollPosition, (String)"ScrollPosition must not be null");
        return this.scroll.scroll(this.sort, this.limit, scrollPosition).map(this.getConversionFunction());
    }

    public Page<R> page(Pageable pageable) {
        return pageable.isUnpaged() ? new PageImpl(this.all()) : this.readPage(pageable);
    }

    public Stream<R> stream() {
        return this.createSortedAndProjectedQuery().stream().map(this.getConversionFunction());
    }

    public long count() {
        return this.countOperation.apply(this.predicate);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.predicate);
    }

    private AbstractJPAQuery<?, ?> createSortedAndProjectedQuery() {
        AbstractJPAQuery<?, ?> query = this.finder.apply(this.sort);
        if (!this.properties.isEmpty()) {
            query.setHint("jakarta.persistence.fetchgraph", EntityGraphFactory.create(this.entityManager, this.entityType, this.properties));
        }
        if (this.limit != 0) {
            query.limit((long)this.limit);
        }
        return query;
    }

    private Page<R> readPage(Pageable pageable) {
        AbstractJPAQuery<?, ?> query = this.pagedFinder.apply(this.sort, pageable);
        if (!this.properties.isEmpty()) {
            query.setHint("jakarta.persistence.fetchgraph", EntityGraphFactory.create(this.entityManager, this.entityType, this.properties));
        }
        List<R> paginatedResults = this.convert(query.fetch());
        return PageableExecutionUtils.getPage(paginatedResults, (Pageable)pageable, () -> this.countOperation.apply(this.predicate));
    }

    private List<R> convert(List<?> resultList) {
        Function<Object, R> conversionFunction = this.getConversionFunction();
        ArrayList<R> mapped = new ArrayList<R>(resultList.size());
        for (Object o : resultList) {
            mapped.add(conversionFunction.apply(o));
        }
        return mapped;
    }

    private Function<Object, R> getConversionFunction() {
        return this.getConversionFunction(this.entityType, this.resultType);
    }

    static class PredicateScrollDelegate<T>
    extends ScrollDelegate<T> {
        private final FluentQuerySupport.ScrollQueryFactory scrollFunction;

        PredicateScrollDelegate(FluentQuerySupport.ScrollQueryFactory scrollQueryFactory, JpaEntityInformation<T, ?> entity) {
            super(entity);
            this.scrollFunction = scrollQueryFactory;
        }

        public Window<T> scroll(Sort sort, int limit, ScrollPosition scrollPosition) {
            Query query = this.scrollFunction.createQuery(sort, scrollPosition);
            if (limit > 0) {
                query = query.setMaxResults(limit);
            }
            return this.scroll(query, sort, scrollPosition);
        }
    }
}

