/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.hsqldb.auth.AuthBeanMultiplexer;
import org.hsqldb.auth.DenyException;
import org.hsqldb.auth.LdapAuthBean;

public class LdapAuthBeanTester {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("SYNTAX:  java " + AuthBeanMultiplexer.class.getName() + " path/to/file.properties <USERNAME> <PASSWORD>");
        }
        File file = new File(stringArray[0]);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file.getAbsolutePath());
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        String string = properties.getProperty("trustStore");
        String string2 = properties.getProperty("startTls");
        String string3 = properties.getProperty("ldapPort");
        String string4 = properties.getProperty("roleSchemaValuePattern");
        String string5 = properties.getProperty("accessValuePattern");
        String string6 = properties.getProperty("securityMechanism");
        String string7 = properties.getProperty("ldapHost");
        String string8 = properties.getProperty("principalTemplate");
        String string9 = properties.getProperty("initialContextFactory");
        String string10 = properties.getProperty("saslRealm");
        String string11 = properties.getProperty("parentDn");
        String string12 = properties.getProperty("rdnAttribute");
        String string13 = properties.getProperty("rolesSchemaAttribute");
        String string14 = properties.getProperty("accessAttribute");
        if (string != null) {
            if (!new File(string).isFile()) {
                throw new IllegalArgumentException("Specified trust store is not a file: " + string);
            }
            System.setProperty("javax.net.ssl.trustStore", string);
        }
        LdapAuthBean ldapAuthBean = new LdapAuthBean();
        if (string2 != null) {
            ldapAuthBean.setStartTls(Boolean.parseBoolean(string2));
        }
        if (string3 != null) {
            ldapAuthBean.setLdapPort(Integer.parseInt(string3));
        }
        if (string4 != null) {
            ldapAuthBean.setRoleSchemaValuePatternString(string4);
        }
        if (string5 != null) {
            ldapAuthBean.setAccessValuePatternString(string5);
        }
        if (string6 != null) {
            ldapAuthBean.setSecurityMechanism(string6);
        }
        if (string7 != null) {
            ldapAuthBean.setLdapHost(string7);
        }
        if (string8 != null) {
            ldapAuthBean.setPrincipalTemplate(string8);
        }
        if (string9 != null) {
            ldapAuthBean.setInitialContextFactory(string9);
        }
        if (string10 != null) {
            ldapAuthBean.setSaslRealm(string10);
        }
        if (string11 != null) {
            ldapAuthBean.setParentDn(string11);
        }
        if (string12 != null) {
            ldapAuthBean.setRdnAttribute(string12);
        }
        if (string13 != null) {
            ldapAuthBean.setRolesSchemaAttribute(string13);
        }
        if (string14 != null) {
            ldapAuthBean.setAccessAttribute(string14);
        }
        ldapAuthBean.init();
        Object[] objectArray = null;
        try {
            objectArray = ldapAuthBean.authenticate(stringArray[1], stringArray[2]);
        }
        catch (DenyException denyException) {
            System.out.println("<DENY ACCESS>");
            return;
        }
        if (objectArray == null) {
            System.out.println("<ALLOW ACCESS w/ local Roles+Schema>");
        } else {
            System.out.println(Integer.toString(objectArray.length) + " Roles/Schema: " + Arrays.toString(objectArray));
        }
    }
}

