/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.thumbnail.ImageThumbnailService;

public class ThumbnailFileListener
extends Listener<FileInfo, Object> {
    private static final String FILE_UPDATED_EVENT = "file.updated";
    private static final String FILE_DELETED_EVENT = "file.deleted";
    private final ImageThumbnailService imageThumbnailService;

    public ThumbnailFileListener(ImageThumbnailService imageThumbnailService) {
        this.imageThumbnailService = imageThumbnailService;
    }

    public void onEvent(Event<FileInfo, Object> event) throws Exception {
        String eventName = event.getEventName();
        FileInfo fileInfo = (FileInfo)event.getSource();
        if (fileInfo != null && (eventName.equals(FILE_UPDATED_EVENT) || eventName.equals(FILE_DELETED_EVENT))) {
            this.imageThumbnailService.deleteThumbnails(fileInfo.getId());
        }
    }
}

