/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PageTemplateDescriptor;
import io.meeds.layout.model.PageTemplateDescriptorList;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.service.injection.LayoutTranslationImportService;
import io.meeds.layout.service.injection.PageTemplateImportService$AjcClosure1;
import io.meeds.layout.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class PageTemplateImportService {
    private static final Scope PAGE_TEMPLATE_IMPORT_SCOPE;
    private static final Context PAGE_TEMPLATE_CONTEXT;
    private static final String PAGE_TEMPLATE_VERSION = "version";
    private static final Log LOG;
    private static final Random RANDOM;
    @Autowired
    private LayoutTranslationImportService layoutTranslationService;
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private PageTemplateService pageTemplateService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${meeds.pages.import.override:false}")
    private boolean forceReimportTemplates;
    @Value(value="${meeds.pages.import.version:2}")
    private long pageTemplateImportVersion;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::importPageTemplates);
    }

    @ContainerTransactional
    public void importPageTemplates() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PageTemplateImportService$AjcClosure1 pageTemplateImportService$AjcClosure1 = new PageTemplateImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(pageTemplateImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected List<PageTemplateDescriptor> parseDescriptors(URL url) {
        List<PageTemplateDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                PageTemplateDescriptorList list2 = JsonUtils.fromJsonString(content, PageTemplateDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing page templates from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importDescriptor(PageTemplateDescriptor descriptor) {
        String descriptorId = descriptor.getId();
        long existingTemplateId = this.getSettingValue(descriptorId);
        if (this.forceReimportTemplates || existingTemplateId == 0L) {
            this.importPageTemplate(descriptor, existingTemplateId);
        } else {
            LOG.debug("Ignore re-importing Page Template {}", new Object[]{descriptorId});
        }
    }

    protected void importPageTemplate(PageTemplateDescriptor d, long oldTemplateId) {
        LOG.info("Importing Page Template {}", new Object[]{d.getId()});
        try {
            PageTemplate pageTemplate = this.createPageTemplate(d, oldTemplateId);
            if (this.forceReimportTemplates || oldTemplateId == 0L || pageTemplate.getId() != oldTemplateId) {
                LOG.info("Importing Page Template {} title translations", new Object[]{d.getId()});
                this.saveNames(d, pageTemplate);
                LOG.info("Importing Page Template {} description translations", new Object[]{d.getId()});
                this.saveDescriptions(d, pageTemplate);
                LOG.info("Importing Page Template {} illustration", new Object[]{d.getId()});
                this.saveIllustration(pageTemplate.getId(), d.getIllustrationPath());
                this.setSettingValue(d.getId(), pageTemplate.getId());
            }
            LOG.info("Importing Page Template {} finished successfully", new Object[]{d.getId()});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing page template {}", new Object[]{d.getId(), e});
        }
    }

    protected void saveNames(PageTemplateDescriptor d, PageTemplate pageTemplate) {
        this.layoutTranslationService.saveTranslationLabels("pageTemplate", pageTemplate.getId(), "title", d.getNames());
    }

    protected void saveDescriptions(PageTemplateDescriptor d, PageTemplate pageTemplate) {
        this.layoutTranslationService.saveTranslationLabels("pageTemplate", pageTemplate.getId(), "description", d.getDescriptions());
    }

    protected PageTemplate createPageTemplate(PageTemplateDescriptor d, long oldTemplateId) {
        boolean isNew;
        PageTemplate pageTemplate = null;
        if (oldTemplateId > 0L) {
            pageTemplate = this.pageTemplateService.getPageTemplate(oldTemplateId);
        }
        boolean bl = isNew = pageTemplate == null;
        if (isNew) {
            pageTemplate = new PageTemplate();
        }
        pageTemplate.setCategory(d.getCategory());
        pageTemplate.setSystem(d.isSystem());
        try (InputStream is = this.configurationManager.getInputStream(d.getLayoutPath());){
            String xml = IOUtil.getStreamContentAsString((InputStream)is);
            Container layout = this.fromXML(xml);
            pageTemplate.setContent(JsonUtils.toJsonString(new LayoutModel((ModelObject)layout)));
        }
        if (isNew) {
            return this.pageTemplateService.createPageTemplate(pageTemplate);
        }
        return this.pageTemplateService.updatePageTemplate(pageTemplate);
    }

    protected void saveIllustration(long pageTemplateId, String imagePath) {
        File tempFile = null;
        try {
            tempFile = this.getIllustrationFile(imagePath);
            String uploadId = "PageTemplateIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.deleteAttachments("pageTemplate", String.valueOf(pageTemplateId));
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "pageTemplate", String.valueOf(pageTemplateId), null, this.layoutAclService.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving Image '%s' as attachment for template '%s'", imagePath, pageTemplateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    protected Container fromXML(String xml) {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(Container.class, (byte[])xml.getBytes(StandardCharsets.UTF_8));
        return (Container)obj.getObject();
    }

    protected void setSettingValue(String name, long value) {
        this.settingService.set(PAGE_TEMPLATE_CONTEXT, PAGE_TEMPLATE_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(PAGE_TEMPLATE_CONTEXT, PAGE_TEMPLATE_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private File getIllustrationFile(String imagePath) throws Exception {
        try (InputStream inputStream = this.configurationManager.getInputStream(imagePath);){
            File tempFile = File.createTempFile("temp", ".png");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            File file = tempFile;
            return file;
        }
    }

    static {
        PageTemplateImportService.ajc$preClinit();
        PAGE_TEMPLATE_IMPORT_SCOPE = Scope.APPLICATION.id("PAGE_TEMPLATE_IMPORT");
        PAGE_TEMPLATE_CONTEXT = Context.GLOBAL.id("PAGE_TEMPLATE");
        LOG = ExoLogger.getLogger(PageTemplateImportService.class);
        RANDOM = new Random();
    }

    static final /* synthetic */ void importPageTemplates_aroundBody0(PageTemplateImportService ajc$this, JoinPoint joinPoint) {
        LOG.info((Object)"Importing Page Templates");
        if (!ajc$this.forceReimportTemplates && ajc$this.getSettingValue(PAGE_TEMPLATE_VERSION) != ajc$this.pageTemplateImportVersion) {
            ajc$this.forceReimportTemplates = true;
        }
        ConversationState.setCurrent((ConversationState)ajc$this.layoutAclService.getSuperUserConversationState());
        try {
            Enumeration<URL> templateFiles = PortalContainer.getInstance().getPortalClassLoader().getResources("page-templates.json");
            Collections.list(templateFiles).stream().map(ajc$this::parseDescriptors).flatMap(Collection::stream).sorted((d1, d2) -> {
                if (d1.getOrder() == d2.getOrder()) {
                    return d1.getId().compareTo(d2.getId());
                }
                return d1.getOrder() - d2.getOrder();
            }).forEach(ajc$this::importDescriptor);
            LOG.info((Object)"Importing Page Templates finished successfully");
            LOG.info((Object)"Processing Post Page Templates import");
            ajc$this.layoutTranslationService.postImport("pageTemplate");
            LOG.info((Object)"Processing Post Page Templates import finished");
            ajc$this.setSettingValue(PAGE_TEMPLATE_VERSION, ajc$this.pageTemplateImportVersion);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing page templates", (Throwable)e);
        }
        finally {
            ConversationState.setCurrent(null);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PageTemplateImportService.java", PageTemplateImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importPageTemplates", "io.meeds.layout.service.injection.PageTemplateImportService", "", "", "", "void"), 117);
    }
}

