/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingOperationReport;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportAction;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportUser;
import org.exoplatform.social.core.binding.model.UserSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.GroupSpaceBindingStorage;

public class GroupSpaceBindingServiceImpl
implements GroupSpaceBindingService {
    private static final Log LOG = ExoLogger.getLogger(GroupSpaceBindingServiceImpl.class);
    private static final int USERS_TO_BIND_PAGE_SIZE = 20;
    private GroupSpaceBindingStorage groupSpaceBindingStorage;
    private OrganizationService organizationService;
    private SpaceService spaceService;
    private static Boolean requestStarted = false;

    public GroupSpaceBindingServiceImpl(InitParams params, GroupSpaceBindingStorage groupSpaceBindingStorage, OrganizationService organizationService, SpaceService spaceService) throws Exception {
        this.groupSpaceBindingStorage = groupSpaceBindingStorage;
        this.organizationService = organizationService;
        this.spaceService = spaceService;
    }

    @Override
    public GroupSpaceBindingQueue findFirstGroupSpaceBindingQueue() {
        LOG.debug((Object)"Retrieving First GroupSpaceBindingQueue to treat");
        return this.groupSpaceBindingStorage.findFirstGroupSpaceBindingQueue();
    }

    @Override
    public List<GroupSpaceBinding> findGroupSpaceBindingsBySpace(String spaceId) {
        LOG.debug((Object)("Retrieving group/space bindings for space:" + spaceId));
        return this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(spaceId);
    }

    @Override
    public List<GroupSpaceBinding> findGroupSpaceBindingsByGroup(String group) {
        LOG.debug((Object)("Retrieving group/space bindings for group:" + group));
        return this.groupSpaceBindingStorage.findGroupSpaceBindingsByGroup(group);
    }

    @Override
    public List<UserSpaceBinding> findUserSpaceBindingsBySpace(String spaceId, String userName) {
        LOG.debug((Object)("Retrieving user bindings for member:" + userName + "/" + spaceId));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(spaceId, userName);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsByUser(String userName) {
        LOG.debug((Object)("Retrieving user bindings for member:" + userName));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsByUser(userName);
    }

    @Override
    public List<GroupSpaceBindingReportUser> findReportsForCsv(long spaceId, long groupSpaceBindingId, String group, String action) {
        LOG.debug("Retrieving GroupSpaceBindingReports for space={}, groupSpaceBinding={}, group={}, actions={}", new Object[]{spaceId, groupSpaceBindingId, group, action});
        return this.groupSpaceBindingStorage.findReportsForCsv(spaceId, groupSpaceBindingId, group, action);
    }

    @Override
    public List<GroupSpaceBindingOperationReport> getGroupSpaceBindingReportOperations() {
        return this.groupSpaceBindingStorage.getGroupSpaceBindingReportOperations();
    }

    @Override
    public List<GroupSpaceBindingOperationReport> getGroupSpaceBindingReportOperations(String spaceId) {
        return this.groupSpaceBindingStorage.getGroupSpaceBindingReportOperations(spaceId);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsByGroup(String group, String userName) {
        LOG.debug((Object)("Retrieving user bindings for user : " + userName + " with group : " + group));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsByGroup(group, userName);
    }

    @Override
    public void createGroupSpaceBindingQueue(GroupSpaceBindingQueue groupSpaceBindingsQueue) {
        this.groupSpaceBindingStorage.createGroupSpaceBindingQueue(groupSpaceBindingsQueue);
    }

    @Override
    public void prepareDeleteGroupSpaceBinding(GroupSpaceBinding groupSpaceBinding) {
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(groupSpaceBinding.getId(), Long.parseLong(groupSpaceBinding.getSpaceId()), groupSpaceBinding.getGroup(), "REMOVE");
        if (this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(report.getGroupSpaceBindingId(), report.getAction()) == null) {
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(report);
        }
        GroupSpaceBindingQueue bindingQueue = new GroupSpaceBindingQueue(groupSpaceBinding, GroupSpaceBindingQueue.ACTION_REMOVE);
        this.groupSpaceBindingStorage.createGroupSpaceBindingQueue(bindingQueue);
    }

    @Override
    public void deleteGroupSpaceBinding(GroupSpaceBinding groupSpaceBinding) {
        LOG.debug((Object)("Delete binding group :" + groupSpaceBinding.getGroup() + " for space :" + groupSpaceBinding.getSpaceId()));
        long startTime = System.currentTimeMillis();
        Space space = this.spaceService.getSpaceById(groupSpaceBinding.getSpaceId());
        GroupSpaceBindingReportAction bindingReportRemoveAction = this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(groupSpaceBinding.getId(), "REMOVE");
        if (bindingReportRemoveAction == null) {
            GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(groupSpaceBinding.getId(), Long.parseLong(groupSpaceBinding.getSpaceId()), groupSpaceBinding.getGroup(), "REMOVE");
            bindingReportRemoveAction = this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(report);
        }
        for (UserSpaceBinding userSpaceBinding : this.groupSpaceBindingStorage.findUserAllBindingsByGroupBinding(groupSpaceBinding)) {
            this.deleteUserBinding(userSpaceBinding, bindingReportRemoveAction);
        }
        bindingReportRemoveAction.setEndDate(new Date());
        this.groupSpaceBindingStorage.updateGroupSpaceBindingReportAction(bindingReportRemoveAction);
        this.groupSpaceBindingStorage.deleteGroupBinding(groupSpaceBinding.getId());
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        LOG.info("service={} operation={} parameters=\"space:{},totalSpaceMembers:{},boundSpaceMembers:{}\" status=ok duration_ms={}", new Object[]{"group-binding", "remove-binding", space.getPrettyName(), space.getMembers().length, this.countBoundUsers(space.getId()), totalTime});
    }

    @Override
    public void deleteUserBinding(UserSpaceBinding userSpaceBinding, GroupSpaceBindingReportAction bindingReportAction) {
        boolean shouldBeRemovedFromSpace;
        LOG.debug("Delete user binding for member : {} from ", new Object[]{userSpaceBinding.getUser(), userSpaceBinding.getGroupBinding().getSpaceId()});
        this.groupSpaceBindingStorage.deleteUserBinding(userSpaceBinding.getId());
        boolean hasOtherBindings = this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(userSpaceBinding.getGroupBinding().getSpaceId(), userSpaceBinding.getUser()).size() > 0;
        boolean isStillPresent = true;
        boolean bl = shouldBeRemovedFromSpace = !hasOtherBindings;
        if (bindingReportAction.getAction().equals("REMOVE")) {
            boolean bl2 = shouldBeRemovedFromSpace = shouldBeRemovedFromSpace && userSpaceBinding.isMemberBefore() == false;
        }
        if (shouldBeRemovedFromSpace) {
            this.spaceService.removeMember(this.spaceService.getSpaceById(userSpaceBinding.getGroupBinding().getSpaceId()), userSpaceBinding.getUser());
            isStillPresent = false;
        }
        GroupSpaceBindingReportUser report = new GroupSpaceBindingReportUser(bindingReportAction, userSpaceBinding.getUser(), "REMOVE_USER");
        report.setStillInSpace(isStillPresent);
        report.setWasPresentBefore(userSpaceBinding.isMemberBefore().booleanValue());
        this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(report);
    }

    @Override
    public void deleteAllSpaceBindingsBySpace(String spaceId) {
        LOG.debug((Object)("Delete all bindings for space :" + spaceId));
        for (GroupSpaceBinding groupSpaceBinding : this.findGroupSpaceBindingsBySpace(spaceId)) {
            this.deleteGroupSpaceBinding(groupSpaceBinding);
        }
    }

    @Override
    public void deleteAllSpaceBindingsByGroup(String groupId) {
        LOG.debug((Object)("Delete all bindings for group :" + groupId));
        for (GroupSpaceBinding groupSpaceBinding : this.findGroupSpaceBindingsByGroup(groupId)) {
            this.deleteGroupSpaceBinding(groupSpaceBinding);
        }
    }

    @Override
    public long countUserBindings(String spaceId, String userName) {
        LOG.debug((Object)("Count member binding :" + userName + " space:" + spaceId));
        return this.groupSpaceBindingStorage.countUserBindings(spaceId, userName);
    }

    @Override
    public long countBoundUsers(String spaceId) {
        LOG.debug((Object)("Count bound users for space:" + spaceId));
        return this.groupSpaceBindingStorage.countBoundUsers(spaceId);
    }

    @Override
    public void saveGroupSpaceBindings(List<GroupSpaceBinding> groupSpaceBindings) {
        LOG.debug("Saving group space binding between spaceId: {} and groups: {}.", new Object[]{groupSpaceBindings.get(0).getSpaceId(), groupSpaceBindings.toString()});
        try {
            ArrayList boundGroupsAndSpacesList = new ArrayList();
            ArrayList bindingQueueList = new ArrayList();
            groupSpaceBindings.stream().forEach(groupSpaceBinding -> boundGroupsAndSpacesList.add(this.saveGroupSpaceBinding((GroupSpaceBinding)groupSpaceBinding)));
            boundGroupsAndSpacesList.stream().forEach(groupSpaceBinding -> bindingQueueList.add(new GroupSpaceBindingQueue(groupSpaceBinding, GroupSpaceBindingQueue.ACTION_CREATE)));
            bindingQueueList.stream().forEach(groupSpaceBindingQueue -> this.createGroupSpaceBindingQueue((GroupSpaceBindingQueue)groupSpaceBindingQueue));
        }
        catch (Exception e) {
            LOG.error((Object)("Error when saving group space binding " + String.valueOf(groupSpaceBindings)), (Throwable)e);
            throw new RuntimeException("Failed saving groupSpaceBindings: " + groupSpaceBindings.toString(), e);
        }
    }

    @Override
    public GroupSpaceBinding saveGroupSpaceBinding(GroupSpaceBinding groupSpaceBinding) {
        GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction((groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding)).getId(), Long.parseLong(groupSpaceBinding.getSpaceId()), groupSpaceBinding.getGroup(), "ADD");
        if (this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(report.getGroupSpaceBindingId(), report.getAction()) == null) {
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(report);
        }
        return groupSpaceBinding;
    }

    @Override
    public void bindUsersFromGroupSpaceBinding(GroupSpaceBinding groupSpaceBinding) {
        Space space = this.spaceService.getSpaceById(groupSpaceBinding.getSpaceId());
        int offset = 0;
        long startTime = System.currentTimeMillis();
        try {
            ListAccess groupMembersAccess = this.organizationService.getUserHandler().findUsersByGroupId(groupSpaceBinding.getGroup());
            int totalGroupMembersSize = groupMembersAccess.getSize();
            GroupSpaceBindingReportAction bindingReportAddAction = this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(groupSpaceBinding.getId(), "ADD");
            if (bindingReportAddAction == null) {
                GroupSpaceBindingReportAction report = new GroupSpaceBindingReportAction(groupSpaceBinding.getId(), Long.parseLong(groupSpaceBinding.getSpaceId()), groupSpaceBinding.getGroup(), "ADD");
                bindingReportAddAction = this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(report);
            }
            do {
                long startBunchTime = System.currentTimeMillis();
                long toBind = totalGroupMembersSize - offset;
                int limit = toBind < 20L ? (int)toBind : 20;
                List<User> users = Arrays.asList((User[])groupMembersAccess.load(offset, limit));
                long count = users.size();
                int currentCount = offset;
                for (User user : users) {
                    ++currentCount;
                    this.startRequest();
                    long startTimeUser = System.currentTimeMillis();
                    String userId = user.getUserName();
                    this.saveUserBinding(userId, groupSpaceBinding, space, bindingReportAddAction);
                    long endTimeUser = System.currentTimeMillis();
                    long totalTimeUser = endTimeUser - startTimeUser;
                    LOG.debug((Object)("Time to treat user " + userId + " (" + currentCount + "/" + totalGroupMembersSize + ") : " + totalTimeUser + " ms"));
                    this.endRequest();
                }
                offset = (int)((long)offset + count);
                LOG.info("Binding process: Bound Users({})", new Object[]{offset});
                long endBunchTime = System.currentTimeMillis();
                long totalBunchTime = endBunchTime - startBunchTime;
                LOG.info((Object)("Time to treat " + count + " (" + offset + "/" + totalGroupMembersSize + ") users : " + totalBunchTime + " ms"));
            } while (offset < totalGroupMembersSize);
            bindingReportAddAction.setEndDate(new Date());
            this.groupSpaceBindingStorage.updateGroupSpaceBindingReportAction(bindingReportAddAction);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when binding users from group " + groupSpaceBinding.getGroup() + ", to space " + groupSpaceBinding.getSpaceId()), (Throwable)e);
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"space:{},totalSpaceMembers:{},boundSpaceMembers:{}\" status=ko duration_ms={}", new Object[]{"group-binding", "new-binding", space.getPrettyName(), space.getMembers().length, this.countBoundUsers(space.getId()), totalTime});
            throw new RuntimeException("Failed saving groupSpaceBinding", e);
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        LOG.info("service={} operation={} parameters=\"space:{},totalSpaceMembers:{},boundSpaceMembers:{}\" status=ok duration_ms={}", new Object[]{"group-binding", "new-binding", space.getPrettyName(), space.getMembers().length, this.countBoundUsers(space.getId()), totalTime});
    }

    @Override
    public boolean isUserBoundAndMemberBefore(String spaceId, String userId) {
        return this.groupSpaceBindingStorage.isUserBoundAndMemberBefore(spaceId, userId);
    }

    @Override
    public boolean isBoundSpace(String spaceId) {
        return this.groupSpaceBindingStorage.isBoundSpace(spaceId);
    }

    @Override
    public void deleteFromBindingQueue(GroupSpaceBindingQueue bindingQueue) {
        this.groupSpaceBindingStorage.deleteGroupBindingQueue(bindingQueue.getId());
    }

    private void endRequest() {
        if (requestStarted.booleanValue() && this.organizationService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            requestStarted = false;
        }
    }

    private void startRequest() {
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    @Override
    public GroupSpaceBinding findGroupSpaceBindingById(String bindingId) {
        return this.groupSpaceBindingStorage.findGroupSpaceBindingById(bindingId);
    }

    @Override
    public List<GroupSpaceBinding> getGroupSpaceBindingsFromQueueByAction(String action) {
        return this.groupSpaceBindingStorage.getGroupSpaceBindingsFromQueueByAction(action);
    }

    @Override
    public void saveUserBinding(String userId, GroupSpaceBinding groupSpaceBinding, Space space, GroupSpaceBindingReportAction bindingReportAction) {
        boolean isUserAlreadyBound;
        Object[] members = space.getMembers();
        UserSpaceBinding userSpaceBinding = new UserSpaceBinding(userId, groupSpaceBinding);
        boolean bl = isUserAlreadyBound = this.countUserBindings(groupSpaceBinding.getSpaceId(), userId) > 0L;
        if (!isUserAlreadyBound) {
            userSpaceBinding.setIsMemberBefore(Boolean.valueOf(ArrayUtils.contains((Object[])members, (Object)userId)));
        } else {
            userSpaceBinding.setIsMemberBefore(Boolean.valueOf(this.isUserBoundAndMemberBefore(groupSpaceBinding.getSpaceId(), userId)));
        }
        GroupSpaceBindingReportUser groupSpaceBindingReportUser = new GroupSpaceBindingReportUser(bindingReportAction, userId, "ADD_USER");
        groupSpaceBindingReportUser.setWasPresentBefore(userSpaceBinding.isMemberBefore().booleanValue());
        this.spaceService.addMember(space, userId);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(groupSpaceBindingReportUser);
    }

    @Override
    public GroupSpaceBindingReportAction saveGroupSpaceBindingReport(GroupSpaceBindingReportAction groupSpaceBindingReportAction) {
        return this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(groupSpaceBindingReportAction);
    }

    @Override
    public GroupSpaceBindingReportAction findGroupSpaceBindingReportAction(long bindingId, String action) {
        return this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(bindingId, action);
    }

    @Override
    public void updateGroupSpaceBindingReportAction(GroupSpaceBindingReportAction groupSpaceBindingReportAction) {
        this.groupSpaceBindingStorage.updateGroupSpaceBindingReportAction(groupSpaceBindingReportAction);
    }

    @Override
    public List<GroupSpaceBindingQueue> getAllFromBindingQueue() {
        return this.groupSpaceBindingStorage.getAllFromBindingQueue();
    }
}

