/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.List;
import org.hibernate.query.criteria.JpaFunction;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.expression.Expression;

public abstract class SqmFunction<T>
extends AbstractSqmExpression<T>
implements JpaFunction<T>,
SemanticPathPart {
    private final String functionName;
    private final SqmFunctionDescriptor functionDescriptor;
    private final List<? extends SqmTypedNode<?>> arguments;

    public SqmFunction(String functionName, SqmFunctionDescriptor functionDescriptor, SqmExpressible<T> type, List<? extends SqmTypedNode<?>> arguments, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
        this.functionName = functionName;
        this.functionDescriptor = functionDescriptor;
        this.arguments = arguments;
    }

    public SqmFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public List<? extends SqmTypedNode<?>> getArguments() {
        return this.arguments;
    }

    public abstract Expression convertToSqlAst(SqmToSqlAstConverter var1);

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        switch (this.functionName) {
            case "cast": {
                sb.append("cast(");
                this.arguments.get(0).appendHqlString(sb);
                sb.append(" as ");
                this.arguments.get(1).appendHqlString(sb);
                sb.append(')');
                break;
            }
            case "extract": {
                sb.append("extract(");
                this.arguments.get(0).appendHqlString(sb);
                sb.append(" from ");
                this.arguments.get(1).appendHqlString(sb);
                sb.append(')');
                break;
            }
            case "format": {
                sb.append("format(");
                this.arguments.get(0).appendHqlString(sb);
                sb.append(" as ");
                this.arguments.get(1).appendHqlString(sb);
                sb.append(')');
                break;
            }
            case "overlay": {
                sb.append("overlay(");
                this.arguments.get(0).appendHqlString(sb);
                sb.append(" placing ");
                this.arguments.get(1).appendHqlString(sb);
                sb.append(" from ");
                this.arguments.get(2).appendHqlString(sb);
                if (this.arguments.size() == 4) {
                    sb.append(" for ");
                    this.arguments.get(3).appendHqlString(sb);
                }
                sb.append(')');
                break;
            }
            case "trim": {
                sb.append("trim(");
                switch (this.arguments.size()) {
                    case 1: {
                        this.arguments.get(0).appendHqlString(sb);
                        break;
                    }
                    case 2: {
                        this.arguments.get(0).appendHqlString(sb);
                        sb.append(" from ");
                        this.arguments.get(1).appendHqlString(sb);
                        break;
                    }
                    case 3: {
                        this.arguments.get(0).appendHqlString(sb);
                        sb.append(' ');
                        this.arguments.get(1).appendHqlString(sb);
                        sb.append(" from ");
                        this.arguments.get(3).appendHqlString(sb);
                    }
                }
                sb.append(')');
                break;
            }
            case "pad": {
                sb.append("pad(");
                this.arguments.get(0).appendHqlString(sb);
                sb.append(" with");
                for (int i = 1; i < this.arguments.size(); ++i) {
                    sb.append(' ');
                    this.arguments.get(i).appendHqlString(sb);
                }
                sb.append(')');
                break;
            }
            case "position": {
                sb.append("position(");
                this.arguments.get(0).appendHqlString(sb);
                sb.append(" in ");
                this.arguments.get(1).appendHqlString(sb);
                sb.append(')');
                break;
            }
            default: {
                sb.append(this.functionName);
                if (this.arguments.isEmpty()) {
                    if (this.functionDescriptor.alwaysIncludesParentheses()) {
                        sb.append("()");
                    }
                    return;
                }
                sb.append('(');
                for (int i = 1; i < this.arguments.size(); ++i) {
                    sb.append(", ");
                    this.arguments.get(i).appendHqlString(sb);
                }
                sb.append(')');
            }
        }
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        throw new UnsupportedOperationException();
    }
}

