/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wom.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.meeds.wom.api.model.HubReportPayload;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Instant;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.hateoas.server.core.Relation;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Relation(collectionRelation="reports", itemRelation="report")
public class HubReport
extends HubReportPayload {
    private long rewardId;
    private short city;
    private short cardType;
    private short mintingPower;
    private long maxUsers;
    private String deedManagerAddress;
    private String ownerAddress;
    private int ownerMintingPercentage;
    private double fixedRewardIndex;
    private double ownerFixedIndex;
    private double tenantFixedIndex;
    private boolean fraud;
    private double lastPeriodUemRewardAmount;
    private double uemRewardAmount;
    private double engagementScore;
    private Instant updatedDate;

    public HubReport(HubReportPayload hubReportPayload) {
        super(hubReportPayload.getReportId(), StringUtils.lowerCase((String)hubReportPayload.getHubAddress()), hubReportPayload.getDeedId(), hubReportPayload.getFromDate(), hubReportPayload.getToDate(), hubReportPayload.getSentDate(), hubReportPayload.getPeriodType(), hubReportPayload.getUsersCount(), hubReportPayload.getParticipantsCount(), hubReportPayload.getRecipientsCount(), hubReportPayload.getAchievementsCount(), hubReportPayload.getActionsCount(), StringUtils.lowerCase((String)hubReportPayload.getRewardTokenAddress()), hubReportPayload.getRewardTokenNetworkId(), hubReportPayload.getHubRewardAmount(), hubReportPayload.getHubTopRewardedAmount(), HubReport.lowerCase(hubReportPayload.getTransactions()));
    }

    public HubReport(long reportId, String hubAddress, long deedId, Instant fromDate, Instant toDate, Instant sentDate, String periodType, long usersCount, long participantsCount, long recipientsCount, long achievementsCount, long actionsCount, String rewardTokenAddress, long rewardTokenNetworkId, double hubRewardAmount, double hubTopReceiverAmount, SortedSet<String> transactions, long rewardId, short city, short cardType, short mintingPower, long maxUsers, String deedManagerAddress, String ownerAddress, int ownerMintingPercentage, double fixedRewardIndex, double ownerFixedIndex, double tenantFixedIndex, boolean fraud, double lastPeriodUemRewardAmount, double uemRewardAmount, Instant updatedDate) {
        super(reportId, hubAddress, deedId, fromDate, toDate, sentDate, periodType, usersCount, participantsCount, recipientsCount, achievementsCount, actionsCount, rewardTokenAddress, rewardTokenNetworkId, hubRewardAmount, hubTopReceiverAmount, transactions);
        this.rewardId = rewardId;
        this.city = city;
        this.cardType = cardType;
        this.mintingPower = mintingPower;
        this.maxUsers = maxUsers;
        this.deedManagerAddress = deedManagerAddress;
        this.ownerAddress = ownerAddress;
        this.ownerMintingPercentage = ownerMintingPercentage;
        this.fixedRewardIndex = fixedRewardIndex;
        this.ownerFixedIndex = ownerFixedIndex;
        this.tenantFixedIndex = tenantFixedIndex;
        this.fraud = fraud;
        this.lastPeriodUemRewardAmount = lastPeriodUemRewardAmount;
        this.uemRewardAmount = uemRewardAmount;
        this.updatedDate = updatedDate;
    }

    public HubReport(long reportId, String hubAddress, long deedId, Instant fromDate, Instant toDate, Instant sentDate, String periodType, long usersCount, long participantsCount, long recipientsCount, long achievementsCount, long actionsCount, String rewardTokenAddress, long rewardTokenNetworkId, double hubRewardAmount, double hubTopReceiverAmount, SortedSet<String> transactions, long rewardId, short city, short cardType, short mintingPower, long maxUsers, String deedManagerAddress, String ownerAddress, int ownerMintingPercentage, double fixedRewardIndex, double ownerFixedIndex, double tenantFixedIndex, boolean fraud, double lastPeriodUemRewardAmount, double uemRewardAmount, Instant updatedDate, double engagementScore) {
        this(reportId, hubAddress, deedId, fromDate, toDate, sentDate, periodType, usersCount, participantsCount, recipientsCount, achievementsCount, actionsCount, rewardTokenAddress, rewardTokenNetworkId, hubRewardAmount, hubTopReceiverAmount, transactions, rewardId, city, cardType, mintingPower, maxUsers, deedManagerAddress, ownerAddress, ownerMintingPercentage, fixedRewardIndex, ownerFixedIndex, tenantFixedIndex, fraud, lastPeriodUemRewardAmount, uemRewardAmount, updatedDate);
        this.engagementScore = engagementScore;
    }

    public double getEd() {
        double achievementsCount = this.getAchievementsCount();
        double participantsCount = this.getParticipantsCount();
        if (participantsCount == 0.0 || achievementsCount == 0.0) {
            return 0.0;
        }
        return BigDecimal.valueOf(achievementsCount).divide(BigDecimal.valueOf(participantsCount), MathContext.DECIMAL128).doubleValue();
    }

    public double getDr() {
        return this.lastPeriodUemRewardAmount == 0.0 ? 1.0 : BigDecimal.valueOf(this.getHubRewardAmount()).divide(BigDecimal.valueOf(this.lastPeriodUemRewardAmount), MathContext.DECIMAL128).doubleValue();
    }

    public double getDs() {
        return this.getUsersCount() == 0L ? 0.0 : BigDecimal.valueOf(Math.min(this.getRecipientsCount(), this.getMaxUsers())).divide(BigDecimal.valueOf(this.getUsersCount()), MathContext.DECIMAL128).doubleValue();
    }

    public double getMp() {
        return (double)this.mintingPower / 100.0;
    }

    public long getRewardId() {
        return this.rewardId;
    }

    public short getCity() {
        return this.city;
    }

    public short getCardType() {
        return this.cardType;
    }

    public short getMintingPower() {
        return this.mintingPower;
    }

    public long getMaxUsers() {
        return this.maxUsers;
    }

    public String getDeedManagerAddress() {
        return this.deedManagerAddress;
    }

    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public int getOwnerMintingPercentage() {
        return this.ownerMintingPercentage;
    }

    public double getFixedRewardIndex() {
        return this.fixedRewardIndex;
    }

    public double getOwnerFixedIndex() {
        return this.ownerFixedIndex;
    }

    public double getTenantFixedIndex() {
        return this.tenantFixedIndex;
    }

    public boolean isFraud() {
        return this.fraud;
    }

    public double getLastPeriodUemRewardAmount() {
        return this.lastPeriodUemRewardAmount;
    }

    public double getUemRewardAmount() {
        return this.uemRewardAmount;
    }

    public double getEngagementScore() {
        return this.engagementScore;
    }

    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    public void setRewardId(long rewardId) {
        this.rewardId = rewardId;
    }

    public void setCity(short city) {
        this.city = city;
    }

    public void setCardType(short cardType) {
        this.cardType = cardType;
    }

    public void setMintingPower(short mintingPower) {
        this.mintingPower = mintingPower;
    }

    public void setMaxUsers(long maxUsers) {
        this.maxUsers = maxUsers;
    }

    public void setDeedManagerAddress(String deedManagerAddress) {
        this.deedManagerAddress = deedManagerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public void setOwnerMintingPercentage(int ownerMintingPercentage) {
        this.ownerMintingPercentage = ownerMintingPercentage;
    }

    public void setFixedRewardIndex(double fixedRewardIndex) {
        this.fixedRewardIndex = fixedRewardIndex;
    }

    public void setOwnerFixedIndex(double ownerFixedIndex) {
        this.ownerFixedIndex = ownerFixedIndex;
    }

    public void setTenantFixedIndex(double tenantFixedIndex) {
        this.tenantFixedIndex = tenantFixedIndex;
    }

    public void setFraud(boolean fraud) {
        this.fraud = fraud;
    }

    public void setLastPeriodUemRewardAmount(double lastPeriodUemRewardAmount) {
        this.lastPeriodUemRewardAmount = lastPeriodUemRewardAmount;
    }

    public void setUemRewardAmount(double uemRewardAmount) {
        this.uemRewardAmount = uemRewardAmount;
    }

    public void setEngagementScore(double engagementScore) {
        this.engagementScore = engagementScore;
    }

    public void setUpdatedDate(Instant updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Override
    public String toString() {
        return "HubReport(super=" + super.toString() + ", rewardId=" + this.getRewardId() + ", city=" + this.getCity() + ", cardType=" + this.getCardType() + ", mintingPower=" + this.getMintingPower() + ", maxUsers=" + this.getMaxUsers() + ", deedManagerAddress=" + this.getDeedManagerAddress() + ", ownerAddress=" + this.getOwnerAddress() + ", ownerMintingPercentage=" + this.getOwnerMintingPercentage() + ", fixedRewardIndex=" + this.getFixedRewardIndex() + ", ownerFixedIndex=" + this.getOwnerFixedIndex() + ", tenantFixedIndex=" + this.getTenantFixedIndex() + ", fraud=" + this.isFraud() + ", lastPeriodUemRewardAmount=" + this.getLastPeriodUemRewardAmount() + ", uemRewardAmount=" + this.getUemRewardAmount() + ", engagementScore=" + this.getEngagementScore() + ", updatedDate=" + this.getUpdatedDate() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HubReport)) {
            return false;
        }
        HubReport other = (HubReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getRewardId() != other.getRewardId()) {
            return false;
        }
        if (this.getCity() != other.getCity()) {
            return false;
        }
        if (this.getCardType() != other.getCardType()) {
            return false;
        }
        if (this.getMintingPower() != other.getMintingPower()) {
            return false;
        }
        if (this.getMaxUsers() != other.getMaxUsers()) {
            return false;
        }
        if (this.getOwnerMintingPercentage() != other.getOwnerMintingPercentage()) {
            return false;
        }
        if (Double.compare(this.getFixedRewardIndex(), other.getFixedRewardIndex()) != 0) {
            return false;
        }
        if (Double.compare(this.getOwnerFixedIndex(), other.getOwnerFixedIndex()) != 0) {
            return false;
        }
        if (Double.compare(this.getTenantFixedIndex(), other.getTenantFixedIndex()) != 0) {
            return false;
        }
        if (this.isFraud() != other.isFraud()) {
            return false;
        }
        if (Double.compare(this.getLastPeriodUemRewardAmount(), other.getLastPeriodUemRewardAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getUemRewardAmount(), other.getUemRewardAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getEngagementScore(), other.getEngagementScore()) != 0) {
            return false;
        }
        String this$deedManagerAddress = this.getDeedManagerAddress();
        String other$deedManagerAddress = other.getDeedManagerAddress();
        if (this$deedManagerAddress == null ? other$deedManagerAddress != null : !this$deedManagerAddress.equals(other$deedManagerAddress)) {
            return false;
        }
        String this$ownerAddress = this.getOwnerAddress();
        String other$ownerAddress = other.getOwnerAddress();
        if (this$ownerAddress == null ? other$ownerAddress != null : !this$ownerAddress.equals(other$ownerAddress)) {
            return false;
        }
        Instant this$updatedDate = this.getUpdatedDate();
        Instant other$updatedDate = other.getUpdatedDate();
        return !(this$updatedDate == null ? other$updatedDate != null : !((Object)this$updatedDate).equals(other$updatedDate));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HubReport;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $rewardId = this.getRewardId();
        result = result * 59 + (int)($rewardId >>> 32 ^ $rewardId);
        result = result * 59 + this.getCity();
        result = result * 59 + this.getCardType();
        result = result * 59 + this.getMintingPower();
        long $maxUsers = this.getMaxUsers();
        result = result * 59 + (int)($maxUsers >>> 32 ^ $maxUsers);
        result = result * 59 + this.getOwnerMintingPercentage();
        long $fixedRewardIndex = Double.doubleToLongBits(this.getFixedRewardIndex());
        result = result * 59 + (int)($fixedRewardIndex >>> 32 ^ $fixedRewardIndex);
        long $ownerFixedIndex = Double.doubleToLongBits(this.getOwnerFixedIndex());
        result = result * 59 + (int)($ownerFixedIndex >>> 32 ^ $ownerFixedIndex);
        long $tenantFixedIndex = Double.doubleToLongBits(this.getTenantFixedIndex());
        result = result * 59 + (int)($tenantFixedIndex >>> 32 ^ $tenantFixedIndex);
        result = result * 59 + (this.isFraud() ? 79 : 97);
        long $lastPeriodUemRewardAmount = Double.doubleToLongBits(this.getLastPeriodUemRewardAmount());
        result = result * 59 + (int)($lastPeriodUemRewardAmount >>> 32 ^ $lastPeriodUemRewardAmount);
        long $uemRewardAmount = Double.doubleToLongBits(this.getUemRewardAmount());
        result = result * 59 + (int)($uemRewardAmount >>> 32 ^ $uemRewardAmount);
        long $engagementScore = Double.doubleToLongBits(this.getEngagementScore());
        result = result * 59 + (int)($engagementScore >>> 32 ^ $engagementScore);
        String $deedManagerAddress = this.getDeedManagerAddress();
        result = result * 59 + ($deedManagerAddress == null ? 43 : $deedManagerAddress.hashCode());
        String $ownerAddress = this.getOwnerAddress();
        result = result * 59 + ($ownerAddress == null ? 43 : $ownerAddress.hashCode());
        Instant $updatedDate = this.getUpdatedDate();
        result = result * 59 + ($updatedDate == null ? 43 : ((Object)$updatedDate).hashCode());
        return result;
    }

    public HubReport() {
    }
}

