/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.entity.WalletBlockchainStateEntity;

public class WalletBlockchainStateDAO
extends GenericDAOJPAImpl<WalletBlockchainStateEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(WalletBlockchainStateDAO.class);

    public WalletBlockchainStateEntity findByWalletIdAndContract(long walletId, String contractAddress) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletBlockchainState.findByWalletIdAndContract", WalletBlockchainStateEntity.class);
        query.setParameter("walletId", (Object)walletId);
        query.setParameter("contractAddress", (Object)contractAddress);
        try {
            List resultList = query.getResultList();
            if (resultList == null || resultList.isEmpty()) {
                return null;
            }
            if (resultList.size() > 1) {
                LOG.debug("Multiple WalletBlockchainStateEntity was found for wallet with id {}", new Object[]{walletId});
            }
            return (WalletBlockchainStateEntity)resultList.get(0);
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

