/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;

@Entity(name="SocSpaceMember")
@ExoEntity
@Table(name="SOC_SPACES_MEMBERS")
@NamedQueries(value={@NamedQuery(name="SpaceMember.deleteBySpace", query="DELETE FROM SocSpaceMember mem WHERE mem.space.id = :spaceId"), @NamedQuery(name="SpaceMember.getSpaceIdentitiesIdByMemberId", query="SELECT DISTINCT identity.id FROM SocIdentityEntity AS identity WHERE  identity.providerId = 'space' AND  identity.remoteId IN    (SELECT DISTINCT spaceMember.space.prettyName FROM SocSpaceMember AS spaceMember where      spaceMember.userId = :userId AND      spaceMember.status = :status    ) "), @NamedQuery(name="SpaceMember.getSpaceIdByMemberId", query="SELECT DISTINCT spaceMember.space.id FROM SocSpaceMember AS spaceMember  WHERE spaceMember.userId = :userId   AND spaceMember.status = :status   ORDER BY spaceMember.space.id DESC"), @NamedQuery(name="SpaceMember.getSpaceMembersByStatus", query="SELECT spaceMember.userId FROM SocSpaceMember AS spaceMember  WHERE spaceMember.status = :status  AND   spaceMember.space.id = :spaceId "), @NamedQuery(name="SpaceMember.countSpaceMembersByStatus", query="SELECT count(*) FROM SocSpaceMember AS spaceMember  WHERE spaceMember.status = :status  AND   spaceMember.space.id = :spaceId "), @NamedQuery(name="SpaceMember.getMember", query="SELECT mem FROM SocSpaceMember mem WHERE mem.userId = :userId AND mem.space.id = :spaceId AND mem.status = :status"), @NamedQuery(name="SpaceMember.deleteByUsername", query="DELETE FROM SocSpaceMember sm WHERE sm.userId = :username"), @NamedQuery(name="SpaceMember.getSpaceMemberShip", query="SELECT mem FROM SocSpaceMember mem WHERE mem.userId = :userId AND mem.space.id = :spaceId"), @NamedQuery(name="SpaceMember.countPendingSpaceRequestsToManage", query="SELECT count(*) FROM SocSpaceMember mem WHERE mem.status = :status AND mem.space.id in (SELECT mem_tmp.space.id FROM SocSpaceMember mem_tmp WHERE mem_tmp.userId = :userId AND mem_tmp.status = :user_status)"), @NamedQuery(name="SpaceMember.getPendingSpaceRequestsToManage", query="SELECT mem.userId, mem.space.id FROM SocSpaceMember mem WHERE mem.status = :status AND mem.space.id in (SELECT mem_tmp.space.id FROM SocSpaceMember mem_tmp WHERE mem_tmp.userId = :userId AND mem_tmp.status = :user_status)")})
public class SpaceMemberEntity
implements Serializable {
    private static final long serialVersionUID = 1015703779692801839L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_SPACE_MEMBER_ID", sequenceName="SEQ_SOC_SPACE_MEMBER_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_SPACE_MEMBER_ID")
    @Column(name="SPACE_MEMBER_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="SPACE_ID", nullable=false)
    private SpaceEntity space;
    @Column(name="USER_ID", nullable=false)
    private String userId;
    @Column(name="STATUS", nullable=false)
    private Status status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LAST_ACCESS")
    private Date lastAccess = new Date(86400000L);
    @Column(name="VISITED")
    private boolean visited;

    public SpaceMemberEntity() {
        this(null, null, null);
    }

    public SpaceMemberEntity(SpaceEntity space, String userId, Status status) {
        this.setSpace(space);
        this.setUserId(userId);
        this.setStatus(status);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SpaceEntity getSpace() {
        return this.space;
    }

    public void setSpace(SpaceEntity space) {
        this.space = space;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceMemberEntity that = (SpaceMemberEntity)o;
        if (!this.space.equals(that.space)) {
            return false;
        }
        if (!this.userId.equals(that.userId)) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.space.hashCode();
        result = 31 * result + this.userId.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public static enum Status {
        MEMBER,
        MANAGER,
        REDACTOR,
        PENDING,
        INVITED,
        IGNORED,
        PUBLISHER;

    }
}

