/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.repository.Temporal;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class JpaParameters
extends Parameters<JpaParameters, JpaParameter> {
    @Deprecated(since="3.2.1", forRemoval=true)
    public JpaParameters(Method method) {
        this(ParametersSource.of((Method)method), null);
    }

    public JpaParameters(ParametersSource parametersSource) {
        super(parametersSource, methodParameter -> new JpaParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
    }

    protected JpaParameters(ParametersSource parametersSource, Function<MethodParameter, JpaParameter> parameterFactory) {
        super(parametersSource, parameterFactory);
    }

    private JpaParameters(List<JpaParameter> parameters) {
        super(parameters);
    }

    @Deprecated(forRemoval=true)
    protected JpaParameter createParameter(MethodParameter parameter) {
        return new JpaParameter(parameter);
    }

    protected JpaParameters createFrom(List<JpaParameter> parameters) {
        return new JpaParameters(parameters);
    }

    public boolean hasLimitingParameters() {
        return this.hasLimitParameter() || this.hasPageableParameter();
    }

    public static class JpaParameter
    extends Parameter {
        @Nullable
        private final Temporal annotation;
        @Nullable
        private TemporalType temporalType;

        @Deprecated(since="3.2.1", forRemoval=true)
        protected JpaParameter(MethodParameter parameter) {
            super(parameter);
            this.annotation = (Temporal)parameter.getParameterAnnotation(Temporal.class);
            this.temporalType = null;
            if (!this.isDateParameter() && this.hasTemporalParamAnnotation()) {
                throw new IllegalArgumentException(Temporal.class.getSimpleName() + " annotation is only allowed on Date parameter");
            }
        }

        protected JpaParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
            this.annotation = (Temporal)parameter.getParameterAnnotation(Temporal.class);
            this.temporalType = null;
            if (!this.isDateParameter() && this.hasTemporalParamAnnotation()) {
                throw new IllegalArgumentException(Temporal.class.getSimpleName() + " annotation is only allowed on Date parameter");
            }
        }

        public boolean isBindable() {
            return super.isBindable() || this.isTemporalParameter();
        }

        boolean isTemporalParameter() {
            return this.isDateParameter() && this.hasTemporalParamAnnotation();
        }

        @Nullable
        TemporalType getTemporalType() {
            if (this.temporalType == null) {
                this.temporalType = this.annotation == null ? null : this.annotation.value();
            }
            return this.temporalType;
        }

        TemporalType getRequiredTemporalType() throws IllegalStateException {
            TemporalType temporalType = this.getTemporalType();
            if (temporalType != null) {
                return temporalType;
            }
            throw new IllegalStateException(String.format("Required temporal type not found for %s", this.getType()));
        }

        private boolean hasTemporalParamAnnotation() {
            return this.annotation != null;
        }

        private boolean isDateParameter() {
            return this.getType().equals(Date.class);
        }
    }
}

