/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.SiteConfigTemplates;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.importer.NavigationImporter;
import org.exoplatform.portal.mop.importer.PageImporter;
import org.exoplatform.portal.mop.importer.PortalConfigImporter;
import org.exoplatform.portal.mop.importer.Status;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;

public class NewPortalConfigListener
extends BaseComponentPlugin {
    private static final Pattern OWNER_PATTERN = Pattern.compile("@owner@");
    private final UserPortalConfigService owner_;
    private ConfigurationManager cmanager_;
    private LayoutService layoutService;
    private volatile List<NewPortalConfig> configs;
    private List<SiteConfigTemplates> templateConfigs;
    private String pageTemplatesLocation_;
    private String metaPortal;
    private boolean metaPortalSpecified = false;
    private String defaultPortalTemplate;
    private boolean isUseTryCatch;
    private boolean overrideExistingData;
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private NavigationService navigationService_;
    private DescriptionStorage descriptionStorage;
    private LocaleConfigService localeConfigService_;
    private UserACL userACL_;
    final Set<String> createdOwners = new HashSet<String>();
    private boolean isFirstStartup = false;

    public NewPortalConfigListener(UserPortalConfigService owner, LayoutService layoutService, ConfigurationManager cmanager, InitParams params, NavigationService navigationService, DescriptionStorage descriptionStorage, UserACL userACL, LocaleConfigService localeConfigService) {
        this.owner_ = owner;
        this.cmanager_ = cmanager;
        this.layoutService = layoutService;
        this.navigationService_ = navigationService;
        this.descriptionStorage = descriptionStorage;
        this.userACL_ = userACL;
        this.localeConfigService_ = localeConfigService;
        ValueParam valueParam = params.getValueParam("page.templates.location");
        if (valueParam != null) {
            this.pageTemplatesLocation_ = valueParam.getValue();
        }
        if ((valueParam = params.getValueParam("meta.portal")) != null) {
            this.metaPortal = valueParam.getValue();
        } else {
            valueParam = params.getValueParam("default.portal");
            if (valueParam != null) {
                this.metaPortal = valueParam.getValue();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.metaPortal)) {
            this.metaPortalSpecified = true;
        }
        if ((valueParam = params.getValueParam("default.portal.template")) != null) {
            this.defaultPortalTemplate = valueParam.getValue().trim();
        }
        this.configs = params.getObjectParamValues(NewPortalConfig.class);
        this.templateConfigs = params.getObjectParamValues(SiteConfigTemplates.class);
        valueParam = params.getValueParam("initializing.failure.ignore");
        this.isUseTryCatch = valueParam != null ? valueParam.getValue().toLowerCase().equals("true") : true;
        valueParam = params.getValueParam("override");
        if (valueParam != null) {
            this.overrideExistingData = "true".equals(valueParam.getValue());
        }
        for (NewPortalConfig ele : this.configs) {
            if (ele.getOverrideMode() != null) continue;
            ele.setOverrideMode(this.overrideExistingData);
        }
    }

    private void touchImport() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            this.layoutService.saveImportStatus(Status.DONE);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performImport() throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            boolean perform = true;
            Status st = this.layoutService.getImportStatus();
            if (st != null) {
                perform = Status.WANT_REIMPORT == st;
            } else if (this.layoutService.getPortalConfig(this.metaPortal) != null) {
                perform = false;
                this.layoutService.saveImportStatus(Status.DONE);
            } else {
                this.isFirstStartup = true;
            }
            boolean bl = perform;
            return bl;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        boolean prepareImport = this.performImport();
        if (this.isUseTryCatch) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (NewPortalConfig ele : this.configs) {
                    try {
                        if (!ele.getOverrideMode().booleanValue() && !prepareImport) continue;
                        this.initPortalConfigDB(ele);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (NewPortalConfig ele : this.configs) {
                    try {
                        if (!ele.getOverrideMode().booleanValue() && !prepareImport) continue;
                        this.initPageDB(ele);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (NewPortalConfig ele : this.configs) {
                    try {
                        if (!ele.getOverrideMode().booleanValue() && !prepareImport) continue;
                        this.initPageNavigationDB(ele);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            for (NewPortalConfig ele : this.configs) {
                if (!ele.getOverrideMode().booleanValue() && !prepareImport) continue;
                this.initPortalConfigDB(ele);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
        for (NewPortalConfig ele : this.configs) {
            if (!ele.getOverrideMode().booleanValue() && !prepareImport) continue;
            this.initPageDB(ele);
        }
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            for (NewPortalConfig ele : this.configs) {
                if (!ele.getOverrideMode().booleanValue() && !prepareImport) continue;
                this.initPageNavigationDB(ele);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
        this.touchImport();
    }

    String getDefaultPortalTemplate() {
        return this.defaultPortalTemplate;
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    String getDefaultPortal() {
        return this.getMetaPortal();
    }

    String getMetaPortal() {
        return this.metaPortal;
    }

    NewPortalConfig getPortalConfig(String ownerType, String template) {
        for (NewPortalConfig portalConfig : this.configs) {
            if (!portalConfig.getOwnerType().equals(ownerType)) continue;
            return new NewPortalConfig(portalConfig);
        }
        return null;
    }

    public void mergePlugin(NewPortalConfigListener other) {
        ArrayList<Object> result;
        if (other.metaPortalSpecified) {
            this.metaPortal = other.metaPortal;
        }
        if (other.defaultPortalTemplate != null && other.defaultPortalTemplate.length() > 0) {
            this.defaultPortalTemplate = other.defaultPortalTemplate;
        }
        if (this.configs == null) {
            this.configs = other.configs;
        } else if (other.configs != null && !other.configs.isEmpty()) {
            result = new ArrayList<NewPortalConfig>(this.configs);
            result.addAll(other.configs);
            this.configs = Collections.unmodifiableList(result);
        }
        if (this.templateConfigs == null) {
            this.templateConfigs = other.templateConfigs;
        } else if (other.templateConfigs != null && !other.templateConfigs.isEmpty()) {
            result = new ArrayList<SiteConfigTemplates>(this.templateConfigs);
            result.addAll(other.templateConfigs);
            this.templateConfigs = Collections.unmodifiableList(result);
        }
    }

    public void deleteListenerElements(NewPortalConfigListener other) {
        ArrayList<Object> result;
        if (this.configs == null) {
            this.log.warn((Object)"No Portal configurations was loaded, nothing to delete !");
        } else if (other.configs != null && !other.configs.isEmpty()) {
            result = new ArrayList<NewPortalConfig>(this.configs);
            for (NewPortalConfig newPortalConfigToDelete : other.configs) {
                int i = 0;
                while (i < result.size()) {
                    NewPortalConfig newPortalConfig = (NewPortalConfig)result.get(i);
                    if (newPortalConfigToDelete.getOwnerType().equals(newPortalConfig.getOwnerType())) {
                        for (String owner : newPortalConfigToDelete.getPredefinedOwner()) {
                            newPortalConfig.getPredefinedOwner().remove(owner);
                        }
                    }
                    if (newPortalConfig.getPredefinedOwner().size() == 0) {
                        result.remove(newPortalConfig);
                        continue;
                    }
                    ++i;
                }
            }
            this.configs = Collections.unmodifiableList(result);
        }
        if (this.templateConfigs == null) {
            this.log.warn((Object)"No Portal templates configurations was loaded, nothing to delete !");
        } else if (other.templateConfigs != null && !other.templateConfigs.isEmpty()) {
            result = new ArrayList<SiteConfigTemplates>(this.templateConfigs);
            this.deleteSiteConfigTemplates(other, result, PortalConfig.PORTAL_TYPE);
            this.deleteSiteConfigTemplates(other, result, PortalConfig.GROUP_TYPE);
            this.deleteSiteConfigTemplates(other, result, PortalConfig.USER_TYPE);
            this.templateConfigs = Collections.unmodifiableList(result);
        }
    }

    private void deleteSiteConfigTemplates(NewPortalConfigListener other, List<SiteConfigTemplates> result, String templateType) {
        for (SiteConfigTemplates siteConfigTemplatesToDelete : other.templateConfigs) {
            Set<String> portalTemplatesToDelete = siteConfigTemplatesToDelete.getTemplates(templateType);
            if (portalTemplatesToDelete == null || portalTemplatesToDelete.size() <= 0) continue;
            int i = 0;
            while (i < result.size()) {
                SiteConfigTemplates siteConfigTemplates = result.get(i);
                Set<String> portalTemplates = siteConfigTemplates.getTemplates(templateType);
                if (portalTemplatesToDelete != null && portalTemplatesToDelete.size() > 0) {
                    portalTemplates.removeAll(portalTemplatesToDelete);
                }
                if (!(siteConfigTemplates.getTemplates(PortalConfig.PORTAL_TYPE) != null && siteConfigTemplates.getTemplates(PortalConfig.PORTAL_TYPE).size() != 0 || siteConfigTemplates.getTemplates(PortalConfig.GROUP_TYPE) != null && siteConfigTemplates.getTemplates(PortalConfig.GROUP_TYPE).size() != 0 || siteConfigTemplates.getTemplates(PortalConfig.USER_TYPE) != null && siteConfigTemplates.getTemplates(PortalConfig.USER_TYPE).size() != 0)) {
                    result.remove(siteConfigTemplates);
                    continue;
                }
                ++i;
            }
        }
    }

    public void initPortalConfigDB(NewPortalConfig config) throws Exception {
        for (String owner : config.getPredefinedOwner()) {
            if (!this.createPortalConfig(config, owner)) continue;
            this.createdOwners.add(owner);
        }
    }

    public void initPageDB(NewPortalConfig config) throws Exception {
        for (String owner : config.getPredefinedOwner()) {
            if (!this.createdOwners.contains(owner)) continue;
            this.createPage(config, owner);
        }
    }

    public void initPageNavigationDB(NewPortalConfig config) throws Exception {
        for (String owner : config.getPredefinedOwner()) {
            this.createPageNavigation(config, owner);
        }
    }

    public boolean createPortalConfig(NewPortalConfig config, String owner) throws Exception {
        String type = config.getOwnerType();
        String fixedOwnerName = NewPortalConfigListener.fixOwnerName(type, owner);
        PortalConfig pConfig = null;
        if (config.isUseMetaPortalLayout()) {
            persistedPortalConfig = this.layoutService.getPortalConfig(type, fixedOwnerName);
            if (persistedPortalConfig != null) {
                return true;
            }
            pConfig = this.buildEmptyPortalConfig(type, fixedOwnerName);
        } else {
            UnmarshalledObject<PortalConfig> obj;
            if ((StringUtils.isNotBlank((CharSequence)config.getTemplateName()) || StringUtils.isNotBlank((CharSequence)config.getTemplateLocation())) && (obj = this.getConfig(config, owner, type, PortalConfig.class)) != null) {
                pConfig = (PortalConfig)obj.getObject();
            }
            if (pConfig == null) {
                persistedPortalConfig = this.layoutService.getPortalConfig(type, fixedOwnerName);
                if (persistedPortalConfig != null) {
                    return true;
                }
                pConfig = this.buildEmptyPortalConfig(type, fixedOwnerName);
            }
        }
        ImportMode importMode = this.getRightMode(config.getImportMode());
        PortalConfigImporter portalImporter = new PortalConfigImporter(importMode, pConfig, this.layoutService);
        try {
            portalImporter.perform();
            return true;
        }
        catch (Exception ex) {
            this.log.error((Object)("An Exception occured when creating the Portal Configuration. Exception message: " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPage(NewPortalConfig config, String owner) throws Exception {
        UnmarshalledObject<Page.PageSet> pageSet = this.getConfig(config, owner, "pages", Page.PageSet.class);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ImportMode importMode = this.getRightMode(config.getImportMode());
            ArrayList list = pageSet != null ? ((Page.PageSet)pageSet.getObject()).getPages() : new ArrayList();
            PageImporter importer = new PageImporter(importMode, new SiteKey(config.getOwnerType(), owner), list, this.layoutService);
            importer.perform();
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void createPageNavigation(NewPortalConfig config, String owner) throws Exception {
        UnmarshalledObject<PageNavigation> obj = this.getConfig(config, owner, "navigation", PageNavigation.class);
        if (obj == null) {
            return;
        }
        PageNavigation navigation = (PageNavigation)obj.getObject();
        ImportMode importMode = this.getRightMode(config.getImportMode());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(config.getOwnerType(), owner);
        Locale locale = portalConfig != null && portalConfig.getLocale() != null ? new Locale(portalConfig.getLocale()) : Locale.ENGLISH;
        NavigationImporter merge = new NavigationImporter(locale, importMode, navigation, this.navigationService_, this.descriptionStorage);
        merge.perform();
    }

    public <T> UnmarshalledObject<T> getConfig(NewPortalConfig config, String portalName, String fileName, Class<T> objectType) throws Exception {
        String templateName = StringUtils.isBlank((CharSequence)config.getTemplateName()) ? fileName : config.getTemplateName();
        String portalType = config.getOwnerType();
        String location = config.getTemplateLocation();
        return this.getConfig(portalType, portalName, objectType, fileName, location, templateName);
    }

    public <T> T getConfig(String portalType, String portalName, Class<T> objectType, String parentLocation) {
        String fileName;
        if (objectType.isAssignableFrom(PortalConfig.class)) {
            fileName = switch (portalType.toLowerCase()) {
                case "portal" -> "portal";
                case "group" -> "group";
                case "user" -> "user";
                default -> throw new IllegalArgumentException("Unexpected value: " + portalType);
            };
        } else if (objectType.isAssignableFrom(Page.PageSet.class)) {
            fileName = "pages";
        } else if (objectType.isAssignableFrom(PageNavigation.class)) {
            fileName = "navigation";
        } else {
            throw new IllegalArgumentException("Unexpected value: " + objectType);
        }
        UnmarshalledObject<T> config = this.getConfig(portalType, portalName, objectType, fileName, parentLocation, null);
        return (T)(config == null ? null : config.getObject());
    }

    public <T> UnmarshalledObject<T> getConfig(String portalType, String portalName, Class<T> objectType, String fileName, String parentLocation) {
        return this.getConfig(portalType, portalName, objectType, fileName, parentLocation, null);
    }

    public <T> UnmarshalledObject<T> getConfig(String portalType, String portalName, Class<T> objectType, String fileName, String parentLocation, String templateName) {
        String filePath = "/" + portalType + "/" + portalName + "/" + fileName + ".xml";
        String templateFilePath = StringUtils.isBlank((CharSequence)templateName) ? null : "/" + portalType + "/template/" + templateName + "/" + fileName + ".xml";
        List<CallSite> relativePaths = templateFilePath == null ? Collections.singletonList(filePath) : Arrays.asList(filePath, templateFilePath);
        return this.getConfig(portalName, portalType, objectType, parentLocation, relativePaths);
    }

    public <T> UnmarshalledObject<T> getConfig(String portalName, String portalType, Class<T> objectType, String parentLocation, List<String> relativePaths) {
        String xml = ((Stream)relativePaths.stream().sequential()).map(filePath -> this.getConfig(parentLocation, (String)filePath)).filter(Objects::nonNull).findFirst().orElse(null);
        if (xml != null) {
            xml = OWNER_PATTERN.matcher(xml).replaceAll(StringEscapeUtils.escapeXml11((String)portalName));
            try {
                return this.fromXML(portalType, portalName, xml, objectType);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Error parsing configuration from location %s for portal with type %s and name %s (object type = %s)", parentLocation, portalType, portalName, objectType.getSimpleName()), e);
            }
        }
        return null;
    }

    private String fixPath(String path) {
        while (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        return path;
    }

    private String getConfig(String location, String path) {
        Object s = location + path;
        String content = null;
        try {
            this.log.debug((Object)("Attempt to load file " + (String)s));
            s = this.fixPath((String)s);
            content = IOUtil.getStreamContentAsString((InputStream)this.cmanager_.getInputStream((String)s));
            this.log.debug((Object)("Loaded file from path " + (String)s + " with content " + content));
        }
        catch (Exception ignore) {
            this.log.debug((Object)("Could not get file " + (String)s + " will return null instead"));
        }
        return content;
    }

    public Page createPageFromTemplate(String ownerType, String owner, String temp) throws Exception {
        Object path = this.pageTemplatesLocation_ + "/" + temp + "/page.xml";
        path = this.fixPath((String)path);
        try (InputStream is = this.cmanager_.getInputStream((String)path);){
            String xml = IOUtil.getStreamContentAsString((InputStream)is);
            Page page = (Page)this.fromXML(ownerType, owner, xml, Page.class).getObject();
            return page;
        }
    }

    public String getTemplateConfig(String type, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        for (SiteConfigTemplates tempConfig : this.templateConfigs) {
            Set<String> templates = tempConfig.getTemplates(type);
            if (templates == null || !templates.contains(name)) continue;
            return tempConfig.getLocation();
        }
        return null;
    }

    public Set<String> getTemplateConfigs(String siteType) {
        HashSet<String> result = new HashSet<String>();
        for (SiteConfigTemplates tempConfig : this.templateConfigs) {
            Set<String> templates = tempConfig.getTemplates(siteType);
            if (templates == null || templates.size() <= 0) continue;
            result.addAll(templates);
        }
        return result;
    }

    public PortalConfig getPortalConfigFromTemplate(String siteType, String templateName) {
        String templatePath = this.getTemplateConfig(siteType, templateName);
        NewPortalConfig config = new NewPortalConfig(templatePath);
        config.setTemplateName(templateName);
        config.setOwnerType(siteType);
        UnmarshalledObject<PortalConfig> result = null;
        try {
            result = this.getConfig(config, templateName, siteType, PortalConfig.class);
            if (result != null) {
                return (PortalConfig)result.getObject();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Cannot find configuration of template: " + templateName));
        }
        return null;
    }

    private <T> UnmarshalledObject<T> fromXML(String ownerType, String owner, String xml, Class<T> clazz) throws Exception {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(clazz, (byte[])xml.getBytes("UTF-8"));
        Object o = obj.getObject();
        if (o instanceof PageNavigation) {
            PageNavigation nav = (PageNavigation)o;
            nav.setOwnerType(ownerType);
            nav.setOwnerId(owner);
            if (nav.getPriority() < 1) {
                nav.setPriority(-1);
            }
            NewPortalConfigListener.fixOwnerName((PageNavigation)o);
        } else if (o instanceof PortalConfig) {
            PortalConfig portalConfig = (PortalConfig)o;
            portalConfig.setType(ownerType);
            portalConfig.setName(owner);
            NewPortalConfigListener.fixOwnerName(portalConfig);
        } else if (o instanceof Page.PageSet) {
            for (Page page : ((Page.PageSet)o).getPages()) {
                page.setOwnerType(ownerType);
                page.setOwnerId(owner);
                NewPortalConfigListener.fixOwnerName(page);
            }
        }
        return obj;
    }

    private PortalConfig buildEmptyPortalConfig(String type, String ownerName) throws Exception {
        PortalConfig pConfig = new PortalConfig(type, ownerName);
        pConfig.useMetaPortalLayout();
        this.checkPortalConfigGroupProperties(pConfig);
        return pConfig;
    }

    private void checkPortalConfigGroupProperties(PortalConfig portalConfig) throws Exception {
        if (portalConfig.getAccessPermissions() == null || portalConfig.getAccessPermissions().length == 0) {
            if (StringUtils.equals((CharSequence)portalConfig.getType(), (CharSequence)SiteType.GROUP.getName())) {
                portalConfig.setAccessPermissions(new String[]{"*:" + portalConfig.getName()});
            } else if (StringUtils.equals((CharSequence)portalConfig.getType(), (CharSequence)SiteType.USER.getName())) {
                portalConfig.setAccessPermissions(new String[]{portalConfig.getName()});
            } else {
                portalConfig.setAccessPermissions(new String[]{"Everyone"});
            }
        }
        if (StringUtils.isBlank((CharSequence)portalConfig.getEditPermission())) {
            if (StringUtils.equals((CharSequence)portalConfig.getType(), (CharSequence)SiteType.GROUP.getName())) {
                portalConfig.setEditPermission(this.userACL_.getAdminMSType() + ":" + portalConfig.getName());
            } else if (StringUtils.equals((CharSequence)portalConfig.getType(), (CharSequence)SiteType.USER.getName())) {
                portalConfig.setEditPermission(portalConfig.getName());
            } else {
                portalConfig.setEditPermission(this.userACL_.getSuperUser());
            }
        }
        if (StringUtils.isBlank((CharSequence)portalConfig.getLocale())) {
            portalConfig.setLocale(this.localeConfigService_.getDefaultLocaleConfig().getLocaleName());
        }
    }

    private static String fixOwnerName(String type, String owner) {
        if (type.equals(PortalConfig.GROUP_TYPE) && !owner.startsWith("/")) {
            return "/" + owner;
        }
        return owner;
    }

    private static void fixOwnerName(PortalConfig config) {
        config.setName(NewPortalConfigListener.fixOwnerName(config.getType(), config.getName()));
        NewPortalConfigListener.fixOwnerName(config.getPortalLayout());
    }

    private static void fixOwnerName(Container container) {
        for (Object o : container.getChildren()) {
            if (!(o instanceof Container)) continue;
            NewPortalConfigListener.fixOwnerName((Container)o);
        }
    }

    private static void fixOwnerName(PageNavigation pageNav) {
        pageNav.setOwnerId(NewPortalConfigListener.fixOwnerName(pageNav.getOwnerType(), pageNav.getOwnerId()));
        ArrayList fragments = pageNav.getFragments();
        if (fragments != null) {
            for (NavigationFragment fragment : fragments) {
                NewPortalConfigListener.fixOwnerName(fragment);
            }
        }
    }

    private static void fixOwnerName(NavigationFragment fragment) {
        ArrayList nodes = fragment.getNodes();
        if (nodes != null) {
            for (PageNode pageNode : nodes) {
                NewPortalConfigListener.fixOwnerName(pageNode);
            }
        }
    }

    private static void fixOwnerName(PageNode pageNode) {
        if (pageNode.getPageReference() != null) {
            Object pageRef = pageNode.getPageReference();
            int pos1 = ((String)pageRef).indexOf("::");
            int pos2 = ((String)pageRef).indexOf("::", pos1 + 2);
            String type = ((String)pageRef).substring(0, pos1);
            String owner = ((String)pageRef).substring(pos1 + 2, pos2);
            String name = ((String)pageRef).substring(pos2 + 2);
            owner = NewPortalConfigListener.fixOwnerName(type, owner);
            pageRef = type + "::" + owner + "::" + name;
            pageNode.setPageReference((String)pageRef);
        }
        if (pageNode.getNodes() != null) {
            for (PageNode childPageNode : pageNode.getNodes()) {
                NewPortalConfigListener.fixOwnerName(childPageNode);
            }
        }
    }

    private static void fixOwnerName(Page page) {
        page.setOwnerId(NewPortalConfigListener.fixOwnerName(page.getOwnerType(), page.getOwnerId()));
        NewPortalConfigListener.fixOwnerName((Container)page);
    }

    private ImportMode getRightMode(String mode) {
        ImportMode importMode = mode != null ? ImportMode.valueOf((String)mode.trim().toUpperCase()) : this.owner_.getDefaultImportMode();
        if (this.isFirstStartup && (importMode == ImportMode.CONSERVE || importMode == ImportMode.INSERT)) {
            return ImportMode.MERGE;
        }
        return importMode;
    }

    public void reloadConfig(String ownerType, String predefinedOwner, String location, String importMode, boolean overrideMode) {
        this.configs.stream().filter(newPortalConfig -> ownerType.equals(newPortalConfig.getOwnerType()) && newPortalConfig.isPredefinedOwner(predefinedOwner) && location.equals(newPortalConfig.getLocation())).forEach(newPortalConfig -> {
            String initialImportMode = newPortalConfig.getImportMode();
            boolean initialOverrideMode = newPortalConfig.getOverrideMode();
            newPortalConfig.setImportMode(importMode);
            newPortalConfig.setOverrideMode(overrideMode);
            this.log.info("Force portal config reimport for {}, importMode={}, overrideMode={}", new Object[]{newPortalConfig, importMode, overrideMode});
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                this.initPortalConfigDB((NewPortalConfig)newPortalConfig);
            }
            catch (Exception e) {
                this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                this.initPageDB((NewPortalConfig)newPortalConfig);
            }
            catch (Exception e) {
                this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                this.initPageNavigationDB((NewPortalConfig)newPortalConfig);
            }
            catch (Exception e) {
                this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            newPortalConfig.setImportMode(initialImportMode);
            newPortalConfig.setOverrideMode(initialOverrideMode);
        });
    }
}

