/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.LeaderboardFilter;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.rest.model.RealizationValidityContext;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;

public interface RealizationService {
    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter var1, Identity var2, int var3, int var4) throws IllegalAccessException;

    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter var1, int var2, int var3);

    public int countRealizationsByFilter(RealizationFilter var1, Identity var2) throws IllegalAccessException;

    public int countRealizationsByFilter(RealizationFilter var1);

    public RealizationDTO getRealizationById(long var1, Identity var3) throws IllegalAccessException, ObjectNotFoundException;

    public RealizationDTO getRealizationById(long var1);

    public boolean isRealizationManager(String var1);

    public InputStream exportXlsx(RealizationFilter var1, Identity var2, String var3, Locale var4) throws IllegalAccessException;

    public List<RealizationDTO> findRealizationsByObjectIdAndObjectType(String var1, String var2);

    public int getLeaderboardRank(String var1, Date var2, Long var3);

    public List<ProfileReputation> getScorePerProgramByIdentityId(String var1);

    public List<RealizationDTO> createRealizations(String var1, String var2, String var3, String var4, String var5, String var6);

    public void createRealizationsAsync(String var1, String var2, String var3, String var4, String var5, String var6);

    public void updateRealizationStatus(long var1, RealizationStatus var3, String var4) throws IllegalAccessException, ObjectNotFoundException;

    public void updateRealizationStatus(long var1, RealizationStatus var3) throws ObjectNotFoundException;

    public List<RealizationDTO> cancelRealizations(String var1, String var2, String var3, String var4, String var5);

    public List<RealizationDTO> deleteRealizations(String var1, String var2);

    public RealizationValidityContext getRealizationValidityContext(RuleDTO var1, String var2);

    public long getScoreByIdentityIdAndBetweenDates(String var1, Date var2, Date var3);

    public long getScoreByIdentityId(String var1);

    public List<PiechartLeaderboard> getLeaderboardStatsByIdentityId(String var1, Date var2, Date var3);

    public List<StandardLeaderboard> getLeaderboard(LeaderboardFilter var1, String var2) throws IllegalAccessException;

    public Map<Long, Long> getScoresByIdentityIdsAndBetweenDates(List<String> var1, Date var2, Date var3);

    public long countParticipantsBetweenDates(Date var1, Date var2);
}

