/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.springframework.aop.Advisor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

class MethodSecurityAdvisorRegistrar
implements ImportBeanDefinitionRegistrar {
    MethodSecurityAdvisorRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerAsAdvisor("preFilterAuthorization", registry);
        this.registerAsAdvisor("preAuthorizeAuthorization", registry);
        this.registerAsAdvisor("postFilterAuthorization", registry);
        this.registerAsAdvisor("postAuthorizeAuthorization", registry);
        this.registerAsAdvisor("securedAuthorization", registry);
        this.registerAsAdvisor("jsr250Authorization", registry);
    }

    private void registerAsAdvisor(String prefix, BeanDefinitionRegistry registry) {
        String advisorName = prefix + "Advisor";
        if (registry.containsBeanDefinition(advisorName)) {
            return;
        }
        String interceptorName = prefix + "MethodInterceptor";
        if (!registry.containsBeanDefinition(interceptorName)) {
            return;
        }
        BeanDefinition definition = registry.getBeanDefinition(interceptorName);
        if (!(definition instanceof RootBeanDefinition)) {
            return;
        }
        RootBeanDefinition advisor = new RootBeanDefinition((RootBeanDefinition)definition);
        advisor.setTargetType(Advisor.class);
        registry.registerBeanDefinition(prefix + "Advisor", (BeanDefinition)advisor);
    }
}

