/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.core.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;
import org.springframework.util.Assert;

public class UserDetailsMapFactoryBean
implements FactoryBean<Collection<UserDetails>> {
    private final Map<String, String> userProperties;

    public UserDetailsMapFactoryBean(Map<String, String> userProperties) {
        Assert.notNull(userProperties, (String)"userProperties cannot be null");
        this.userProperties = userProperties;
    }

    public Collection<UserDetails> getObject() {
        ArrayList<UserDetails> users = new ArrayList<UserDetails>(this.userProperties.size());
        UserAttributeEditor editor = new UserAttributeEditor();
        this.userProperties.forEach((name, property) -> {
            editor.setAsText(property);
            UserAttribute attr = (UserAttribute)editor.getValue();
            Assert.state((attr != null ? 1 : 0) != 0, () -> "The entry with username '" + name + "' and value '" + property + "' could not be converted to a UserDetails.");
            String password = attr.getPassword();
            boolean disabled = !attr.isEnabled();
            List authorities = attr.getAuthorities();
            users.add(User.withUsername((String)name).password(password).disabled(disabled).authorities((Collection)authorities).build());
        });
        return users;
    }

    public Class<?> getObjectType() {
        return Collection.class;
    }
}

