/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.FeaturePlugin;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="eXo Feature Service")
@NameTemplate(value={@Property(key="service", value="feature"), @Property(key="view", value="ExoFeatureService")})
@RESTEndpoint(path="featureservice")
public class ExoFeatureServiceImpl
implements ExoFeatureService,
Startable {
    private static final String NAME_SPACES = "exo:";
    private SettingService settingService;
    private OrganizationService organizationService;
    private IdentityRegistry identityRegistry;
    private Map<String, Boolean> featuresProperties = new HashMap<String, Boolean>();
    private Map<String, FeaturePlugin> plugins = new HashMap<String, FeaturePlugin>();

    public ExoFeatureServiceImpl(SettingService settingService, IdentityRegistry identityRegistry, OrganizationService organizationService) {
        this.settingService = settingService;
        this.organizationService = organizationService;
        this.identityRegistry = identityRegistry;
    }

    @Managed
    @ManagedDescription(value="Determine if the feature is active")
    @Impact(value=ImpactType.READ)
    public boolean isActiveFeature(@ManagedDescription(value="Feature name") @ManagedName(value="featureName") String featureName) {
        SettingValue sValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + featureName);
        Boolean active = sValue != null ? Boolean.valueOf(sValue.getValue().toString()) : this.getFeaturePropertyValue(featureName);
        return active == null || active != false;
    }

    public void saveActiveFeature(String featureName, boolean isActive) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + featureName, SettingValue.create((Boolean)isActive));
    }

    @Managed
    @ManagedDescription(value="Activate/Deactivate feature")
    @Impact(value=ImpactType.WRITE)
    public void changeFeatureActivation(@ManagedDescription(value="Feature name") @ManagedName(value="featureName") String featureName, @ManagedDescription(value="Is active") @ManagedName(value="isActive") String isActive) {
        boolean isActiveBool = Boolean.parseBoolean(isActive);
        this.saveActiveFeature(featureName, isActiveBool);
    }

    public void addFeaturePlugin(FeaturePlugin featurePlugin) {
        this.plugins.put(featurePlugin.getName(), featurePlugin);
    }

    public boolean isFeatureActiveForUser(@ManagedDescription(value="Feature name") @ManagedName(value="featureName") String featureName, @ManagedDescription(value="Username") @ManagedName(value="userName") String username) {
        if (!this.isActiveFeature(featureName)) {
            return false;
        }
        FeaturePlugin featurePlugin = this.plugins.get(featureName);
        if (featurePlugin != null) {
            return featurePlugin.isFeatureActiveForUser(featureName, username);
        }
        List<String> permissions = this.getFeaturePermissionPropertyValues(featureName);
        return permissions.isEmpty() || permissions.stream().anyMatch(permission -> this.isUserMemberOf(username, (String)permission));
    }

    private Boolean getFeaturePropertyValue(String featureName) {
        String propertyName = "exo.feature." + featureName + ".enabled";
        if (this.featuresProperties.containsKey(propertyName)) {
            return this.featuresProperties.get(propertyName);
        }
        String propertyValue = System.getProperty(propertyName);
        Boolean active = propertyValue != null ? Boolean.valueOf(propertyValue) : null;
        this.featuresProperties.put(propertyName, active);
        return active;
    }

    private List<String> getFeaturePermissionPropertyValues(String featureName) {
        String propertyName = "exo.feature." + featureName + ".permissions";
        String propertyValue = System.getProperty(propertyName);
        if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
            return Arrays.stream(StringUtils.split((String)propertyValue, (String)",")).map(String::trim).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private final boolean isUserMemberOf(String username, String permissionExpression) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)permissionExpression)) {
            return false;
        }
        if ((permissionExpression = permissionExpression.replace("*:", "")).contains(":")) {
            String[] permissionParts = permissionExpression.split(":");
            String membershipType = permissionParts[0];
            String group = permissionParts[1];
            Identity identity = this.identityRegistry.getIdentity(username);
            if (identity != null) {
                return identity.isMemberOf(group, membershipType);
            }
            try {
                Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, group);
                return memberships != null && memberships.stream().anyMatch(membership -> StringUtils.equals((CharSequence)membership.getMembershipType(), (CharSequence)membershipType));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error getting memberships of user " + username, e);
            }
        }
        if (permissionExpression.contains("/")) {
            Identity identity = this.identityRegistry.getIdentity(username);
            if (identity != null) {
                return identity.isMemberOf(permissionExpression);
            }
            try {
                Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, permissionExpression);
                return memberships != null && !memberships.isEmpty();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error getting memberships of user " + username, e);
            }
        }
        return StringUtils.equals((CharSequence)username, (CharSequence)permissionExpression);
    }

    public void start() {
        for (Map.Entry<String, FeaturePlugin> entry : this.plugins.entrySet()) {
            entry.getValue().init();
        }
    }

    public void stop() {
    }
}

