/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInputBase;

@ComponentConfig(template="system:/groovy/webui/form/UIFormInputItemSelector.gtmpl")
public class UIFormInputItemSelector<T>
extends UIFormInputBase<T> {
    private Class<? extends T> type_;
    protected List<SelectItemCategory<T>> categories_ = new ArrayList<SelectItemCategory<T>>();

    public UIFormInputItemSelector(String name, String bindingField, Class<T> typeValue) {
        super(name, bindingField, typeValue);
        this.setComponentConfig(this.getClass(), null);
    }

    public List<SelectItemCategory<T>> getItemCategories() {
        return this.categories_;
    }

    public void setItemCategories(List<SelectItemCategory<T>> categories) {
        this.categories_ = categories;
        boolean selected = false;
        for (SelectItemCategory<T> ele : categories) {
            if (!ele.isSelected()) continue;
            if (selected) {
                ele.setSelected(false);
                continue;
            }
            selected = true;
        }
        if (!selected) {
            this.categories_.get(0).setSelected(true);
        }
    }

    public SelectItemCategory<T> getSelectedCategory() {
        for (SelectItemCategory<T> category : this.categories_) {
            if (!category.isSelected()) continue;
            return category;
        }
        if (this.categories_.size() > 0) {
            SelectItemCategory<T> category = this.categories_.get(0);
            category.setSelected(true);
            category.getSelectItemOptions().get(0).setSelected(true);
            return category;
        }
        return null;
    }

    public SelectItemOption<T> getSelectedItemOption() {
        SelectItemCategory<T> selectedCategory = this.getSelectedCategory();
        if (selectedCategory == null) {
            return null;
        }
        return selectedCategory.getSelectedItemOption();
    }

    @Override
    public T getValue() {
        SelectItemCategory<T> selectedCategory = this.getSelectedCategory();
        if (selectedCategory == null) {
            return null;
        }
        SelectItemOption<T> selectedItem = selectedCategory.getSelectedItemOption();
        if (selectedItem == null) {
            return null;
        }
        return selectedItem.getValue();
    }

    @Override
    public UIFormInputItemSelector<T> setValue(Object input) {
        for (SelectItemCategory<T> category : this.categories_) {
            category.setSelected(this.isSelectItemCategory(category, input));
        }
        return this;
    }

    @Override
    public Class<? extends T> getTypeValue() {
        if (this.type_ != null) {
            return this.type_;
        }
        if (this.getSelectedCategory() == null || this.getSelectedCategory().getSelectedItemOption() == null || this.getSelectedCategory().getSelectedItemOption().getValue() == null) {
            return this.typeValue_;
        }
        T val = this.getSelectedCategory().getSelectedItemOption().getValue();
        return val.getClass();
    }

    public void setTypeValue(Class<? extends T> type) {
        this.type_ = type;
    }

    private boolean isSelectItemCategory(SelectItemCategory<T> category, Object input) {
        List<SelectItemOption<T>> options = category.getSelectItemOptions();
        for (SelectItemOption<T> option : options) {
            if (!option.getValue().equals(input)) continue;
            option.setSelected(true);
            return true;
        }
        return category.getName().equals(input);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
        if (input == null || String.valueOf(input).length() < 1) {
            return;
        }
        this.setValue(input);
    }
}

