/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity(name="HibernateRealm")
@Table(name="jbid_realm")
@NamedQuery(name="HibernateRealm.findRealmByName", query="SELECT o FROM HibernateRealm o WHERE o.name = :name")
public class HibernateRealm {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="JBID_REALM_ID_SEQ")
    @SequenceGenerator(name="JBID_REALM_ID_SEQ", sequenceName="JBID_REALM_ID_SEQ", allocationSize=1)
    @Column(name="ID")
    private Long id;
    @Column(name="NAME", nullable=false)
    private String name;
    @ElementCollection(fetch=FetchType.LAZY)
    @MapKeyColumn(name="PROP_NAME")
    @Column(name="PROP_VALUE")
    @CollectionTable(name="jbid_real_props", joinColumns={@JoinColumn(name="PROP_ID", referencedColumnName="ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    private Map<String, String> properties = new HashMap<String, String>();

    public HibernateRealm() {
    }

    public HibernateRealm(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HibernateRealm)) {
            return false;
        }
        HibernateRealm other = (HibernateRealm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HibernateRealm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "HibernateRealm(id=" + this.getId() + ", name=" + this.getName() + ", properties=" + this.getProperties() + ")";
    }
}

