/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.portal.application.replication.ApplicationState;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.ConfigurationManager;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class StandaloneAppStateManager
extends StateManager {
    protected static final String APPLICATION_KEY = "StandaloneApp";
    private static final Log log = ExoLogger.getLogger(StandaloneAppStateManager.class);

    public UIApplication restoreUIRootComponent(WebuiRequestContext context) throws Exception {
        context.setStateManager((StateManager)this);
        WebuiApplication app = (WebuiApplication)context.getApplication();
        ApplicationState appState = null;
        HttpSession session = this.getSession(context);
        if (session != null) {
            appState = (ApplicationState)session.getAttribute(APPLICATION_KEY);
        }
        UIApplication uiapp = null;
        if (appState != null && Safe.equals((Object)context.getRemoteUser(), (Object)appState.getUserName())) {
            uiapp = appState.getApplication();
        }
        if (appState != null) {
            log.debug((Object)("Found application StandaloneApp :" + appState.getApplication()));
        } else {
            log.debug((Object)"Application StandaloneApp not found");
        }
        if (uiapp == null) {
            ConfigurationManager cmanager = app.getConfigurationManager();
            String uirootClass = cmanager.getApplication().getUIRootComponent().trim();
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(uirootClass);
            uiapp = (UIApplication)app.createUIComponent(type, null, null, context);
        }
        return uiapp;
    }

    public void storeUIRootComponent(WebuiRequestContext context) throws Exception {
        HttpSession session;
        UIApplication uiapp = context.getUIApplication();
        if (uiapp != null && (session = this.getSession(context)) != null) {
            log.debug((Object)"Storing application StandaloneApp");
            session.setAttribute(APPLICATION_KEY, (Object)new ApplicationState(uiapp, context.getRemoteUser()));
        }
    }

    public void expire(String sessionId, WebuiApplication app) {
    }

    protected HttpSession getSession(WebuiRequestContext webuiRC) {
        StandaloneAppRequestContext staRC = (StandaloneAppRequestContext)webuiRC;
        HttpServletRequest req = staRC.getRequest();
        return req.getSession(false);
    }
}

